/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.renderer.entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.yahoo.chirpycricket.mythicmounts.client.renderer.entity.LeashRenderer;
import com.yahoo.chirpycricket.mythicmounts.client.renderer.model.AnimatedLivingEntityModel;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import software.bernie.geckolib3.model.AnimatedGeoModel;
import software.bernie.geckolib3.renderers.geo.GeoEntityRenderer;
import software.bernie.geckolib3.renderers.geo.GeoLayerRenderer;
import software.bernie.geckolib3.renderers.geo.IGeoRenderer;

public class MountRenderer
extends GeoEntityRenderer<MountEntity> {
    LeashRenderer leashRender;
    boolean glowing = false;
    float shadRad = 1.0f;

    public MountRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<MountEntity> modelProvider, float shadowRadius) {
        super(renderManager, modelProvider);
        this.f_114477_ = shadowRadius;
        this.shadRad = shadowRadius;
        this.addLayer(new ArmorOverlayFeatureRenderer((IGeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public MountRenderer(EntityRendererProvider.Context renderManager, AnimatedGeoModel<MountEntity> modelProvider, float shadowRadius, boolean glow) {
        super(renderManager, modelProvider);
        this.f_114477_ = shadowRadius;
        this.shadRad = shadowRadius;
        this.glowing = glow;
        this.addLayer(new ArmorOverlayFeatureRenderer((IGeoRenderer<MountEntity>)this, new ArmorOverlayEntityRenderer(renderManager, modelProvider)));
    }

    public void render(MountEntity entity, float yaw, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        this.f_114477_ = entity.m_6162_() || entity.getIsMini() ? this.shadRad * entity.childScale : this.shadRad;
        if (this.glowing) {
            super.render((LivingEntity)entity, yaw, tickDelta, matrices, vertexConsumers, 255);
        } else {
            super.render((LivingEntity)entity, yaw, tickDelta, matrices, vertexConsumers, light);
        }
    }

    public ResourceLocation getTextureLocation(MountEntity entity) {
        Object filename = entity.getTextureFile() != null && !entity.getTextureFile().equals("") && !entity.getTextureFile().equals("textures/model/entity/") ? entity.getTextureFile() : "textures/model/entity/" + entity.getDefaultTexture();
        return new ResourceLocation("mythicmounts", (String)filename);
    }

    public RenderType getRenderType(MountEntity animatable, float partialTicks, PoseStack stack, MultiBufferSource renderTypeBuffer, VertexConsumer vertexBuilder, int packedLightIn, ResourceLocation textureLocation) {
        String guiBookClass = "class vazkii.patchouli.client.book.gui.GuiBookEntry";
        if (Minecraft.m_91087_().f_91080_ != null && Minecraft.m_91087_().f_91080_.getClass().toString().equals("class vazkii.patchouli.client.book.gui.GuiBookEntry")) {
            return RenderType.m_110473_((ResourceLocation)textureLocation);
        }
        return RenderType.m_110473_((ResourceLocation)textureLocation);
    }

    public class ArmorOverlayFeatureRenderer
    extends GeoLayerRenderer<MountEntity> {
        private final ArmorOverlayEntityRenderer armorOverlayEntityRenderer;
        ResourceLocation armorTextureLocation;

        public ArmorOverlayFeatureRenderer(IGeoRenderer<MountEntity> entityRendererIn, ArmorOverlayEntityRenderer armorOverlayEntityRenderer) {
            super(entityRendererIn);
            this.armorTextureLocation = null;
            this.armorOverlayEntityRenderer = armorOverlayEntityRenderer;
        }

        public void render(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, MountEntity mountEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netyHeadRot, float headPitch) {
            String[] overlays = mountEntity.getOverlays();
            if (overlays != null && overlays.length > 0) {
                for (String overlay : overlays) {
                    if (overlay.length() <= 0) continue;
                    this.armorTextureLocation = new ResourceLocation("mythicmounts", overlay);
                    RenderSystem.m_157427_(GameRenderer::m_172811_);
                    this.armorOverlayEntityRenderer.render(this.getEntityModel().getModel(new ResourceLocation("mythicmounts", ((AnimatedLivingEntityModel)MountRenderer.this.getGeoModelProvider()).geoFile)), (Object)mountEntity, partialTicks, RenderType.m_110452_((ResourceLocation)this.armorTextureLocation), matrixStackIn, bufferIn, bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.armorTextureLocation)), packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
                }
            }
            if (mountEntity.m_7481_()) {
                this.armorTextureLocation = new ResourceLocation("mythicmounts", mountEntity.getArmorTextureFile());
                Item equippedArmor = mountEntity.m_30722_().m_41720_();
                float a = 1.0f;
                float r = 1.0f;
                float g = 1.0f;
                float b = 1.0f;
                if (equippedArmor instanceof DyeableArmorItem) {
                    DyeableArmorItem c = (DyeableArmorItem)equippedArmor;
                    int m = c.m_41121_(mountEntity.m_30722_());
                    r = (float)(m >> 16 & 0xFF) / 255.0f;
                    g = (float)(m >> 8 & 0xFF) / 255.0f;
                    b = (float)(m & 0xFF) / 255.0f;
                }
                RenderSystem.m_157427_(GameRenderer::m_172811_);
                this.armorOverlayEntityRenderer.render(this.getEntityModel().getModel(new ResourceLocation("mythicmounts", ((AnimatedLivingEntityModel)MountRenderer.this.getGeoModelProvider()).geoFile)), (Object)mountEntity, partialTicks, RenderType.m_110452_((ResourceLocation)this.armorTextureLocation), matrixStackIn, bufferIn, bufferIn.m_6299_(RenderType.m_110452_((ResourceLocation)this.armorTextureLocation)), packedLightIn, OverlayTexture.f_118083_, r, g, b, a);
            }
        }
    }

    public class ArmorOverlayEntityRenderer
    extends GeoEntityRenderer<MountEntity> {
        protected ArmorOverlayEntityRenderer(EntityRendererProvider.Context ctx, AnimatedGeoModel<MountEntity> modelProvider) {
            super(ctx, modelProvider);
        }
    }
}

