/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts.client.integration.patchouli;

import com.yahoo.chirpycricket.mythicmounts.config.Settings;
import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class EntityInfoProcessor
implements IComponentProcessor {
    String entityId = "";
    String title = "";

    public void setup(IVariableProvider variables) {
        this.entityId = variables.get("entity_id").asString();
        this.title = variables.get("page_title").asString();
    }

    public IVariable process(String key) {
        Entities.EntityInfo entityInfo = null;
        for (Entities.EntityInfo e : Entities.EntityInfo.values()) {
            if (!("mythicmounts:" + e.path).equals(this.entityId)) continue;
            entityInfo = e;
        }
        if (key.equals("page_title")) {
            return IVariable.wrap((String)this.title);
        }
        if (this.title.equals("Habitats")) {
            return IVariable.wrap((String)this.getBiomes(entityInfo));
        }
        if (this.title.equals("Food")) {
            return IVariable.wrap((String)EntityInfoProcessor.cleanArrayStr(Arrays.toString(Settings.settings.get((Object)((Object)entityInfo.key)).foodItems)));
        }
        if (this.title.equals("Breeding Items")) {
            return IVariable.wrap((String)EntityInfoProcessor.cleanArrayStr(Arrays.toString(Settings.settings.get((Object)((Object)entityInfo.key)).breedingItems)));
        }
        if (this.title.equals("Taming Items")) {
            return IVariable.wrap((String)EntityInfoProcessor.cleanArrayStr(Arrays.toString(Settings.settings.get((Object)((Object)entityInfo.key)).tamingItems)));
        }
        if (this.title.equals("Base Stats")) {
            return IVariable.wrap((String)EntityInfoProcessor.cleanArrayStr(Arrays.toString(MountEntity.getStats(entityInfo.key).toArray())));
        }
        return null;
    }

    private static String cleanArrayStr(String arrayStr) {
        if (arrayStr.length() < 2) {
            return "";
        }
        return "$(br)$(br)" + arrayStr.substring(1, arrayStr.length() - 1);
    }

    public String getBiomes(Entities.EntityInfo entityInfo) {
        Object listStr = "$(br)";
        Registry biomeRegistry = (Registry)Minecraft.m_91087_().f_91073_.m_5962_().m_6632_(ForgeRegistries.BIOMES.getRegistryKey()).get();
        int lineCount = 0;
        for (Biome biome : biomeRegistry) {
            String biomeStr;
            for (MobSpawnSettings.SpawnerData sd : biome.modifiableBiomeInfo().get().mobSpawnSettings().m_151798_(MobCategory.CREATURE).m_146338_()) {
                if (!((EntityType)entityInfo.type.get()).equals(sd.f_48404_)) continue;
                biomeStr = biomeRegistry.m_7981_((Object)biome).toString();
                if (biomeStr.substring(0, 10).equals("minecraft:")) {
                    biomeStr = biomeStr.substring(10, biomeStr.length());
                }
                listStr = (String)listStr + "$(li)" + biomeStr;
                ++lineCount;
            }
            for (MobSpawnSettings.SpawnerData sd : biome.modifiableBiomeInfo().get().mobSpawnSettings().m_151798_(MobCategory.MONSTER).m_146338_()) {
                if (!((EntityType)entityInfo.type.get()).equals(sd.f_48404_)) continue;
                biomeStr = biomeRegistry.m_7981_((Object)biome).toString();
                if (biomeStr.substring(0, 10).equals("minecraft:")) {
                    biomeStr = biomeStr.substring(10, biomeStr.length());
                }
                listStr = (String)listStr + "$(li)" + biomeStr;
                ++lineCount;
            }
            for (MobSpawnSettings.SpawnerData sd : biome.modifiableBiomeInfo().get().mobSpawnSettings().m_151798_(MobCategory.AMBIENT).m_146338_()) {
                if (!((EntityType)entityInfo.type.get()).equals(sd.f_48404_)) continue;
                biomeStr = biomeRegistry.m_7981_((Object)biome).toString();
                if (biomeStr.substring(0, 10).equals("minecraft:")) {
                    biomeStr = biomeStr.substring(10, biomeStr.length());
                }
                listStr = (String)listStr + "$(li)" + biomeStr;
                ++lineCount;
            }
        }
        if (lineCount > 15 && ((String)(listStr = ((String)listStr).replaceAll("\\$\\(li\\)", ","))).length() > 500) {
            listStr = ((String)listStr).substring(0, 500) + "...";
        }
        return listStr;
    }
}

