/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.chirpycricket.mythicmounts;

import com.yahoo.chirpycricket.mythicmounts.entity.MountEntity;
import com.yahoo.chirpycricket.mythicmounts.registery.Entities;
import com.yahoo.chirpycricket.mythicmounts.screen.MountScreenHandler;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(modid="mythicmounts", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class CommonListener {
    public static final MenuType<MountScreenHandler> MOUNT_SCREEN_HANDLER = IForgeMenuType.create((windowId, inv, data) -> {
        Entity entity = inv.f_35978_.f_19853_.m_6815_(data.readInt());
        if (entity instanceof MountEntity) {
            return new MountScreenHandler(windowId, inv, (MountEntity)entity);
        }
        return null;
    });

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (Entities.EntityInfo entityInfo : Entities.EntityInfo.values()) {
            }
        });
    }

    @SubscribeEvent
    public static void registerEntityAttributes(EntityAttributeCreationEvent event) {
        Entities.initEntityTypes();
        for (Entities.EntityInfo entry : Entities.EntityInfo.values()) {
            event.put((EntityType)entry.type.get(), MountEntity.setAttributes(entry.key));
        }
    }

    @SubscribeEvent
    public static void onContainerTypeRegistry(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.MENU_TYPES, helper -> helper.register(new ResourceLocation("mythicmounts", "mount_inventory"), MOUNT_SCREEN_HANDLER));
    }
}

