/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.world.feature.structure;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.ConfiguredFeatureHandler;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.MowzieStructure;
import com.bobmowzie.mowziesmobs.server.world.feature.structure.jigsaw.MowzieJigsawManager;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraftforge.common.util.Lazy;
import org.apache.logging.log4j.Level;

public class MonasteryStructure
extends MowzieStructure {
    public static final Set<String> MUST_CONNECT_POOLS = Set.of("mowziesmobs:monastery/path_pool", "mowziesmobs:monastery/path_connector_pool");
    public static final Set<String> REPLACE_POOLS = Set.of("mowziesmobs:monastery/path_pool");
    public static final String STRAIGHT_POOL = "mowziesmobs:monastery/dead_end_connect_pool";
    private static final Lazy<List<MobSpawnSettings.SpawnerData>> STRUCTURE_MONSTERS = Lazy.of(() -> ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20459_, 100, 4, 9), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20493_, 100, 4, 9)));
    private static final Lazy<List<MobSpawnSettings.SpawnerData>> STRUCTURE_CREATURES = Lazy.of(() -> ImmutableList.of((Object)new MobSpawnSettings.SpawnerData(EntityType.f_20520_, 30, 10, 15), (Object)new MobSpawnSettings.SpawnerData(EntityType.f_20517_, 100, 1, 2)));

    public MonasteryStructure(Structure.StructureSettings settings) {
        super(settings, ConfigHandler.COMMON.MOBS.SCULPTOR.generationConfig, ConfiguredFeatureHandler.SCULPTOR_BIOMES, true, true, true);
    }

    @Override
    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_DECORATION;
    }

    public static Optional<Structure.GenerationStub> createPiecesGenerator(Predicate<Structure.GenerationContext> canGeneratePredicate, Structure.GenerationContext context) {
        if (!canGeneratePredicate.test(context)) {
            return Optional.empty();
        }
        Structure.GenerationContext newContext = new Structure.GenerationContext(context.f_226621_(), context.f_226622_(), context.f_226623_(), context.f_226624_(), context.f_226625_(), context.f_226626_(), context.f_226627_(), context.f_226628_(), context.f_226629_(), context.f_226630_());
        BlockPos blockpos = context.f_226628_().m_151394_(0);
        Optional<Structure.GenerationStub> structurePiecesGenerator = MowzieJigsawManager.addPieces(newContext, (Holder<StructureTemplatePool>)Holder.m_205709_((Object)((StructureTemplatePool)context.f_226621_().m_206191_(Registry.f_122884_).m_7745_(new ResourceLocation("mowziesmobs", "monastery/start_pool")))), blockpos, false, true, 140, "mowziesmobs:monastery/path", "mowziesmobs:monastery/interior", MUST_CONNECT_POOLS, REPLACE_POOLS, STRAIGHT_POOL, 23);
        if (structurePiecesGenerator.isPresent()) {
            MowziesMobs.LOGGER.log(Level.DEBUG, "Monastery at " + blockpos);
        }
        return structurePiecesGenerator;
    }

    @Override
    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        return MonasteryStructure.createPiecesGenerator(t -> this.checkLocation((Structure.GenerationContext)t), context);
    }

    public StructureType<?> m_213658_() {
        return null;
    }
}

