/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimationController;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;

public class PlayerAbility
extends Ability<Player> {
    protected AnimationBuilder activeFirstPersonAnimation;
    protected ItemStack heldItemMainHandVisualOverride;
    protected ItemStack heldItemOffHandVisualOverride;
    protected HandDisplay firstPersonMainHandDisplay;
    protected HandDisplay firstPersonOffHandDisplay;

    public PlayerAbility(AbilityType<Player, ? extends Ability> abilityType, Player user, AbilitySection[] sectionTrack, int cooldownMax) {
        super(abilityType, user, sectionTrack, cooldownMax);
        if (user.f_19853_.f_46443_) {
            this.activeAnimation = new AnimationBuilder().addAnimation("idle");
            this.heldItemMainHandVisualOverride = null;
            this.heldItemOffHandVisualOverride = null;
            this.firstPersonMainHandDisplay = HandDisplay.DEFAULT;
            this.firstPersonOffHandDisplay = HandDisplay.DEFAULT;
        }
    }

    public PlayerAbility(AbilityType<Player, ? extends Ability> abilityType, Player user, AbilitySection[] sectionTrack) {
        this(abilityType, user, sectionTrack, 0);
    }

    public void playAnimation(String animationName, GeckoPlayer.Perspective perspective, boolean shouldLoop) {
        if (this.getUser() != null && ((Player)this.getUser()).f_19853_.m_5776_()) {
            AnimationBuilder newActiveAnimation = new AnimationBuilder().addAnimation(animationName, Boolean.valueOf(shouldLoop));
            if (perspective == GeckoPlayer.Perspective.FIRST_PERSON) {
                this.activeFirstPersonAnimation = newActiveAnimation;
            } else {
                this.activeAnimation = newActiveAnimation;
            }
            MowzieAnimationController<GeckoPlayer> controller = GeckoPlayer.getAnimationController((Player)this.getUser(), perspective);
            GeckoPlayer geckoPlayer = GeckoPlayer.getGeckoPlayer((Player)this.getUser(), perspective);
            if (controller != null && geckoPlayer != null) {
                controller.playAnimation(geckoPlayer, newActiveAnimation);
            }
        }
    }

    @Override
    public void playAnimation(String animationName, boolean shouldLoop) {
        this.playAnimation(animationName, GeckoPlayer.Perspective.FIRST_PERSON, shouldLoop);
        this.playAnimation(animationName, GeckoPlayer.Perspective.THIRD_PERSON, shouldLoop);
    }

    @Override
    public void end() {
        super.end();
        if (((Player)this.getUser()).f_19853_.f_46443_) {
            this.heldItemMainHandVisualOverride = null;
            this.heldItemOffHandVisualOverride = null;
            this.firstPersonMainHandDisplay = HandDisplay.DEFAULT;
            this.firstPersonOffHandDisplay = HandDisplay.DEFAULT;
        }
    }

    @Override
    public boolean canUse() {
        return super.canUse() && !((Player)this.getUser()).m_5833_();
    }

    @Override
    protected boolean canContinueUsing() {
        return super.canContinueUsing() && !((Player)this.getUser()).m_5833_();
    }

    @Override
    public <E extends IAnimatable> PlayState animationPredicate(AnimationEvent<E> e, GeckoPlayer.Perspective perspective) {
        AnimationBuilder whichAnimation = perspective == GeckoPlayer.Perspective.FIRST_PERSON ? this.activeFirstPersonAnimation : this.activeAnimation;
        if (whichAnimation == null || whichAnimation.getRawAnimationList().isEmpty()) {
            return PlayState.STOP;
        }
        e.getController().setAnimation(whichAnimation);
        return PlayState.CONTINUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack heldItemMainHandOverride() {
        return this.heldItemMainHandVisualOverride;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ItemStack heldItemOffHandOverride() {
        return this.heldItemOffHandVisualOverride;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandDisplay getFirstPersonMainHandDisplay() {
        return this.firstPersonMainHandDisplay;
    }

    @OnlyIn(value=Dist.CLIENT)
    public HandDisplay getFirstPersonOffHandDisplay() {
        return this.firstPersonOffHandDisplay;
    }

    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
    }

    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
    }

    public void onRightClickWithItem(PlayerInteractEvent.RightClickItem event) {
    }

    public void onRightClickEntity(PlayerInteractEvent.EntityInteract event) {
    }

    public void onLeftClickEmpty(PlayerInteractEvent.LeftClickEmpty event) {
    }

    public void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
    }

    public void onLeftClickEntity(AttackEntityEvent event) {
    }

    @Override
    public void onTakeDamage(LivingHurtEvent event) {
    }

    public void onJump(LivingEvent.LivingJumpEvent event) {
    }

    public void onRightMouseDown(Player player) {
    }

    public void onLeftMouseDown(Player player) {
    }

    public void onRightMouseUp(Player player) {
    }

    public void onLeftMouseUp(Player player) {
    }

    public void onSneakDown(Player player) {
    }

    public void onSneakUp(Player player) {
    }

    public static enum HandDisplay {
        DEFAULT,
        DONT_RENDER,
        FORCE_RENDER;

    }
}

