/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.EntityUmvuthana;
import com.bobmowzie.mowziesmobs.server.entity.umvuthana.MaskType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class ModelUmvuthana
extends MowzieAnimatedGeoModel<EntityUmvuthana> {
    public ResourceLocation getModelResource(EntityUmvuthana object) {
        return new ResourceLocation("mowziesmobs", "geo/umvuthana.geo.json");
    }

    public ResourceLocation getTextureResource(EntityUmvuthana entity) {
        boolean isElite = entity.getMaskType() == MaskType.FAITH || entity.getMaskType() == MaskType.FURY;
        return new ResourceLocation("mowziesmobs", isElite ? "textures/entity/umvuthana_elite.png" : "textures/entity/umvuthana.png");
    }

    public ResourceLocation getAnimationResource(EntityUmvuthana object) {
        return new ResourceLocation("mowziesmobs", "animations/umvuthana.animation.json");
    }

    @Override
    public void codeAnimations(EntityUmvuthana entity, Integer uniqueID, AnimationEvent<?> customPredicate) {
        boolean isRaptor = entity.getMaskType() == MaskType.FURY;
        boolean isElite = entity.getMaskType() == MaskType.FAITH || isRaptor;
        this.getMowzieBone((String)"crestRight").isHidden = !isElite;
        this.getMowzieBone((String)"crestLeft").isHidden = !isElite;
        this.getMowzieBone((String)"crest1").isHidden = !isElite;
        this.getMowzieBone((String)"leftIndexTalon").isHidden = !isRaptor;
        this.getMowzieBone((String)"leftIndexClaw").isHidden = isRaptor;
        this.getMowzieBone((String)"rightIndexTalon").isHidden = !isRaptor;
        this.getMowzieBone((String)"rightIndexClaw").isHidden = isRaptor;
        MowzieGeoBone root = this.getMowzieBone("root");
        if (isElite) {
            root.multiplyScale(0.93f, 0.93f, 0.93f);
        } else {
            root.multiplyScale(0.83f, 0.83f, 0.83f);
        }
        MowzieGeoBone mask = this.getMowzieBone("mask");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        if (entity.getActiveAbilityType() != EntityUmvuthana.TELEPORT_ABILITY) {
            mask.setScale(1.0f / (float)hips.getScale().f_86214_, 1.0f / (float)hips.getScale().f_86215_, 1.0f / (float)hips.getScale().f_86216_);
        }
        if (entity.m_6084_() && entity.active) {
            MowzieGeoBone head = this.getMowzieBone("head");
            MowzieGeoBone neck = this.getMowzieBone("neck");
            EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
            float headYaw = Mth.m_14177_((float)extraData.netHeadYaw);
            float headPitch = Mth.m_14177_((float)extraData.headPitch);
            head.addRotationX(headPitch * ((float)Math.PI / 180) / 2.0f);
            head.addRotationY(headYaw * ((float)Math.PI / 180) / 2.0f);
            neck.addRotationX(headPitch * ((float)Math.PI / 180) / 2.0f);
            neck.addRotationY(headYaw * ((float)Math.PI / 180) / 2.0f);
        }
        MowzieGeoBone maskHand = this.getMowzieBone("maskHand");
        MowzieGeoBone maskTwitcher = this.getMowzieBone("maskTwitcher");
        float maskPlaceSwitch = this.getControllerValue("maskPlacementSwitchController");
        if ((double)maskPlaceSwitch == 1.0) {
            maskTwitcher.isHidden = true;
            maskHand.isHidden = false;
        } else {
            maskTwitcher.isHidden = false;
            maskHand.isHidden = true;
        }
        float animSpeed = 1.4f;
        float limbSwing = customPredicate.getLimbSwing();
        float limbSwingAmount = customPredicate.getLimbSwingAmount();
        Vec3 moveVec = entity.m_20184_().m_82541_().m_82524_((float)Math.toRadians((double)entity.f_20883_ + 90.0));
        float forward = (float)Math.max(0.0, new Vec3(1.0, 0.0, 0.0).m_82526_(moveVec));
        float backward = (float)Math.max(0.0, new Vec3(-1.0, 0.0, 0.0).m_82526_(moveVec));
        float left = (float)Math.max(0.0, new Vec3(0.0, 0.0, -1.0).m_82526_(moveVec));
        float right = (float)Math.max(0.0, new Vec3(0.0, 0.0, 1.0).m_82526_(moveVec));
        limbSwingAmount *= 2.0f;
        limbSwingAmount = Math.min(0.7f, limbSwingAmount);
        float locomotionAnimController = this.getControllerValue("locomotionAnimController");
        float runAnim = this.getControllerValue("walkRunSwitchController");
        float walkAnim = 1.0f - runAnim;
        this.walkForwardAnim(forward * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.walkBackwardAnim(backward * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.walkLeftAnim(left * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.walkRightAnim(right * locomotionAnimController * walkAnim, limbSwing, limbSwingAmount, animSpeed);
        this.runAnim(locomotionAnimController * runAnim, limbSwing, limbSwingAmount, animSpeed);
    }

    private void runAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.7f;
        speed = (float)((double)speed * 0.8);
        hips.addPositionY(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.7) * 2.0 * (double)globalHeight + (double)(4.0f * globalHeight)) * limbSwingAmount);
        hips.addRotationX(blend * -0.4f * limbSwingAmount * globalHeight);
        hips.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        chest.addRotationY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4 - 1.7) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) - 1.5) * 0.25 * (double)globalHeight - 0.2 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175 - 1.7) * 0.25 * (double)globalHeight + 0.2 * (double)globalHeight) * limbSwingAmount);
        leftThigh.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - (double)0.2f) * limbSwingAmount);
        leftShin.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.5) * -1.0 * (double)globalDegree - (double)(1.1f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.8f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + (double)0.2f) * limbSwingAmount);
        rightShin.addRotationX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        rightAnkle.addRotationX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        rightFoot.addRotationX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 3.5) * -1.0 * (double)globalDegree - (double)(1.1f * globalDegree)) * limbSwingAmount);
        rightToesBack.addRotationX(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.8f * globalDegree)) * limbSwingAmount);
        rightToesBack.addRotationX(blend * (float)(-Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftArm.addRotationY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.05 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.09 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.05 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkForwardAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPositionY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotationX(blend * -0.18f * limbSwingAmount * globalHeight);
        hips.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        chest.addRotationY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotationX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight + 0.18 * (double)globalHeight) * limbSwingAmount);
        leftThigh.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - (double)0.15f) * limbSwingAmount);
        leftShin.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.4f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree)) * limbSwingAmount);
        rightThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + (double)0.15f) * limbSwingAmount);
        rightShin.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.4f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightToesBack.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftArm.addRotationY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkBackwardAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPositionY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotationX(blend * 0.18f * limbSwingAmount * globalHeight);
        hips.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)0.1f * (double)globalHeight) * limbSwingAmount);
        chest.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotationX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight - 0.18 * (double)globalHeight) * limbSwingAmount);
        leftThigh.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.55f * (double)globalDegree - 0.3 * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.1f * (double)globalDegree - (double)0.15f) * limbSwingAmount);
        leftShin.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.4f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.55f * (double)globalDegree + 0.3 * (double)globalDegree)) * limbSwingAmount);
        rightThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 - 1.5) * (double)0.1f * (double)globalDegree + (double)0.15f) * limbSwingAmount);
        rightShin.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.4f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightToesBack.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 - 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftArm.addRotationY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkLeftAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPositionY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotationX(blend * -0.1f * limbSwingAmount * globalHeight);
        hips.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        hips.addRotationZ(blend * 0.08f * limbSwingAmount * globalHeight);
        chest.addRotationY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        stomach.addRotationZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        stomach.addRotationZ(blend * -((float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        neck.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotationX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight + 0.1 * (double)globalHeight) * limbSwingAmount);
        head.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight) * limbSwingAmount);
        head.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight) * limbSwingAmount);
        head.addRotationZ(blend * -0.03f * limbSwingAmount * globalHeight);
        leftThigh.addRotationX(blend * -0.05f * limbSwingAmount * globalHeight);
        leftThigh.addRotationZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree + 0.05 * (double)globalDegree)) * limbSwingAmount);
        leftThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - 0.15) * limbSwingAmount);
        leftShin.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.6f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftFoot.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree) * limbSwingAmount);
        leftFoot.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationX(blend * 0.05f * limbSwingAmount * globalHeight);
        rightThigh.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree - 0.05 * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + 0.15) * limbSwingAmount);
        rightShin.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.6f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightFoot.addRotationY(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree)) * limbSwingAmount);
        rightFoot.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightToesBack.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        leftShin.addRotationX(blend * -((float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6), 12.0) * (double)0.6f * (double)globalHeight)) * limbSwingAmount);
        leftAnkle.addRotationX(blend * (float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6), 12.0) * (double)0.6f * (double)globalHeight) * limbSwingAmount);
        leftArm.addRotationY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }

    private void walkRightAnim(float blend, float limbSwing, float limbSwingAmount, float speed) {
        MowzieGeoBone head = this.getMowzieBone("head");
        MowzieGeoBone neck = this.getMowzieBone("neck");
        MowzieGeoBone hips = this.getMowzieBone("hips");
        MowzieGeoBone stomach = this.getMowzieBone("stomach");
        MowzieGeoBone chest = this.getMowzieBone("chest");
        MowzieGeoBone leftThigh = this.getMowzieBone("leftThigh");
        MowzieGeoBone leftShin = this.getMowzieBone("leftShin");
        MowzieGeoBone leftAnkle = this.getMowzieBone("leftAnkle");
        MowzieGeoBone leftFoot = this.getMowzieBone("leftFoot");
        MowzieGeoBone leftToesBack = this.getMowzieBone("leftToesBack");
        MowzieGeoBone rightThigh = this.getMowzieBone("rightThigh");
        MowzieGeoBone rightShin = this.getMowzieBone("rightShin");
        MowzieGeoBone rightAnkle = this.getMowzieBone("rightAnkle");
        MowzieGeoBone rightFoot = this.getMowzieBone("rightFoot");
        MowzieGeoBone rightToesBack = this.getMowzieBone("rightToesBack");
        MowzieGeoBone leftArm = this.getMowzieBone("leftArm");
        MowzieGeoBone leftForeArm = this.getMowzieBone("leftForeArm");
        MowzieGeoBone leftHand = this.getMowzieBone("leftHand");
        MowzieGeoBone rightArm = this.getMowzieBone("rightArm");
        MowzieGeoBone rightForeArm = this.getMowzieBone("rightForeArm");
        MowzieGeoBone rightHand = this.getMowzieBone("rightHand");
        float globalHeight = 1.5f;
        float globalDegree = 1.5f;
        hips.addPositionY(blend * (float)(Math.cos(limbSwing * speed) * 1.5 * (double)globalHeight) * limbSwingAmount);
        hips.addRotationX(blend * -0.1f * limbSwingAmount * globalHeight);
        hips.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        hips.addRotationZ(blend * -0.08f * limbSwingAmount * globalHeight);
        chest.addRotationY(blend * (float)(-Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.2f * (double)globalHeight) * limbSwingAmount);
        stomach.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) + 1.4) * 0.025 * (double)globalHeight)) * limbSwingAmount);
        stomach.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight) * limbSwingAmount);
        stomach.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight) * limbSwingAmount);
        neck.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.0) * (double)-0.1f * (double)globalHeight) * limbSwingAmount);
        neck.addRotationX(blend * -((float)(Math.cos(limbSwing * speed) * 0.175 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.175) * 0.175 * (double)globalHeight + 0.1 * (double)globalHeight) * limbSwingAmount);
        head.addRotationZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.4) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationZ(blend * -((float)(Math.cos((double)(limbSwing * speed) - 0.5) * 0.02 * (double)globalHeight)) * limbSwingAmount);
        head.addRotationZ(blend * 0.03f * limbSwingAmount * globalHeight);
        leftThigh.addRotationX(blend * 0.05f * limbSwingAmount * globalHeight);
        leftThigh.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree + 0.05 * (double)globalDegree) * limbSwingAmount);
        leftThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree - 0.15) * limbSwingAmount);
        leftShin.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree) * limbSwingAmount);
        leftAnkle.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree + (double)(0.1f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree - (double)(0.6f * globalDegree)) * limbSwingAmount);
        leftFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        leftFoot.addRotationY(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree)) * limbSwingAmount);
        leftFoot.addRotationY(blend * -((float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree + (double)(1.4f * globalDegree)) * limbSwingAmount);
        leftToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightThigh.addRotationX(blend * -0.05f * limbSwingAmount * globalHeight);
        rightThigh.addRotationZ(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.55f * (double)globalDegree - 0.05 * (double)globalDegree)) * limbSwingAmount);
        rightThigh.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 1.5) * (double)0.1f * (double)globalDegree + 0.15) * limbSwingAmount);
        rightShin.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)-0.7f * (double)globalDegree)) * limbSwingAmount);
        rightAnkle.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.4) * (double)1.1f * (double)globalDegree - (double)(0.1f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-1.3f * (double)globalDegree + (double)(0.6f * globalDegree))) * limbSwingAmount);
        rightFoot.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree) * limbSwingAmount);
        rightFoot.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) * 0.5 + 2.5) * (double)-0.4f * (double)globalDegree) * limbSwingAmount);
        rightFoot.addRotationY(blend * -((float)(Math.cos((double)(limbSwing * speed * 1.0f) - 0.2) * (double)-0.2f * (double)globalDegree)) * limbSwingAmount);
        rightToesBack.addRotationX(blend * -((float)(Math.cos((double)(limbSwing * speed) * 0.5 + 3.1) * (double)1.6f * (double)globalDegree - (double)(1.4f * globalDegree))) * limbSwingAmount);
        rightToesBack.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed * 1.0f) + 0.1) * (double)0.3f * (double)globalDegree) * limbSwingAmount);
        rightShin.addRotationX(blend * -((float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6 + 1.5707963267948966), 12.0) * (double)0.6f * (double)globalHeight)) * limbSwingAmount);
        rightAnkle.addRotationX(blend * (float)(Math.pow(Math.cos((double)limbSwing * 0.25 * (double)speed - 0.6 + 1.5707963267948966), 12.0) * (double)0.6f * (double)globalHeight) * limbSwingAmount);
        leftArm.addRotationY(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        leftArm.addRotationZ(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        leftForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationY(blend * (float)(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight) * limbSwingAmount);
        rightArm.addRotationZ(blend * (float)(-(Math.cos((double)(limbSwing * speed) + 0.52) * 0.0707 * (double)globalHeight)) * limbSwingAmount);
        rightForeArm.addRotationX(blend * (float)(Math.cos((double)(limbSwing * speed) - 1.0) * 0.03 * (double)globalHeight) * limbSwingAmount);
    }
}

