/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.setup;

import dev.micle.totemofreviving.item.totem.DiamondTotemItem;
import dev.micle.totemofreviving.item.totem.IronTotemItem;
import dev.micle.totemofreviving.item.totem.NetheriteTotemItem;
import dev.micle.totemofreviving.item.totem.StrawTotemItem;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

public final class Config {
    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Server.SPEC);
    }

    public static class Server {
        private static final ForgeConfigSpec SPEC;
        private static final TotemConfig STRAW_TOTEM_CONFIG;
        private static final TotemConfig IRON_TOTEM_CONFIG;
        private static final TotemConfig DIAMOND_TOTEM_CONFIG;
        private static final TotemConfig NETHERITE_TOTEM_CONFIG;

        public static TotemConfig getStrawTotemConfig() {
            return STRAW_TOTEM_CONFIG;
        }

        public static TotemConfig getIronTotemConfig() {
            return IRON_TOTEM_CONFIG;
        }

        public static TotemConfig getDiamondTotemConfig() {
            return DIAMOND_TOTEM_CONFIG;
        }

        public static TotemConfig getNetheriteTotemConfig() {
            return NETHERITE_TOTEM_CONFIG;
        }

        static {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            builder.comment("WHEN MAKING CHANGES IT IS RECOMMENDED TO NOT BE IN A WORLD.\nCHANGES WILL MOST LIKELY REQUIRE A RESTART FOR EVERYTHING TO WORK PROPERLY.");
            STRAW_TOTEM_CONFIG = new TotemConfig(builder, StrawTotemItem.getName(), true, -1, 3, 1.0, false, false, 1);
            IRON_TOTEM_CONFIG = new TotemConfig(builder, IronTotemItem.getName(), true, -1, 5, 0.75, false, false, 4);
            DIAMOND_TOTEM_CONFIG = new TotemConfig(builder, DiamondTotemItem.getName(), true, -1, 10, 0.5, false, false, 10);
            NETHERITE_TOTEM_CONFIG = new TotemConfig(builder, NetheriteTotemItem.getName(), true, 1, 1, 1.0, true, true, 0);
            SPEC = builder.build();
        }
    }

    public static class TotemConfig {
        private final ForgeConfigSpec.BooleanValue IS_ENABLED;
        private final ForgeConfigSpec.IntValue CHARGE_COST;
        private final ForgeConfigSpec.IntValue CHARGE_COST_LIMIT;
        private final ForgeConfigSpec.DoubleValue CHARGE_COST_MULTIPLIER;
        private final ForgeConfigSpec.BooleanValue CAN_REVIVE_MORE_EXPENSIVE_TARGETS;
        private final ForgeConfigSpec.BooleanValue CAN_REVIVE_ACROSS_DIMENSIONS;
        private final ForgeConfigSpec.IntValue DURABILITY;

        public TotemConfig(ForgeConfigSpec.Builder builder, String name, boolean isEnabled, int chargeCost, int chargeCostLimit, double chargeCostMultiplier, boolean canReviveMoreExpensiveTargets, boolean canReviveAcrossDimensions, int durability) {
            builder.push(name);
            this.IS_ENABLED = builder.comment("Is the " + name + " enabled?").define("isEnabled", isEnabled);
            this.CHARGE_COST = builder.comment("The charge cost to revive a player.\n-1 means the cost is dynamic (follows the amount of deaths the target has)\nHigher values set the charge cost to static, meaning that this will be the amount of charges needed to revive someone.").defineInRange("chargeCost", chargeCost, -1, Integer.MAX_VALUE);
            this.CHARGE_COST_LIMIT = builder.comment("The max amount of charge this totem can hold at once. Only works with dynamic cost.").defineInRange("chargeCostLimit", chargeCostLimit, 1, Integer.MAX_VALUE);
            this.CHARGE_COST_MULTIPLIER = builder.comment("Charge cost multiplier. 0.5 means the charge cost will be 50% of the original cost. Only works with dynamic cost.").defineInRange("chargeCostMultiplier", chargeCostMultiplier, 0.01, 100.0);
            this.CAN_REVIVE_MORE_EXPENSIVE_TARGETS = builder.comment("Is the totem able to revive targets that cost more than the totems max charge?\nThis only applies if the totem is fully charged. (dynamic wont work if limit is 0)").define("canReviveMoreExpensiveTargets", canReviveMoreExpensiveTargets);
            this.CAN_REVIVE_ACROSS_DIMENSIONS = builder.comment("Is the totem able to revive targets across dimensions?").define("canReviveAcrossDimensions", canReviveAcrossDimensions);
            this.DURABILITY = builder.comment("The durability of the totem. 0 means unbreakable.").defineInRange("durability", durability, 0, Integer.MAX_VALUE);
            builder.pop();
        }

        public boolean getIsEnabled() {
            return (Boolean)this.IS_ENABLED.get();
        }

        public int getChargeCost() {
            return (Integer)this.CHARGE_COST.get();
        }

        public int getChargeCostLimit() {
            return (Integer)this.CHARGE_COST_LIMIT.get();
        }

        public double getChargeCostMultiplier() {
            return (Double)this.CHARGE_COST_MULTIPLIER.get();
        }

        public boolean getCanReviveMoreExpensiveTargets() {
            return (Boolean)this.CAN_REVIVE_MORE_EXPENSIVE_TARGETS.get();
        }

        public boolean getCanReviveAcrossDimensions() {
            return (Boolean)this.CAN_REVIVE_ACROSS_DIMENSIONS.get();
        }

        public int getDurability() {
            try {
                return (Integer)this.DURABILITY.get();
            }
            catch (IllegalStateException e) {
                return 10;
            }
        }
    }
}

