/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.network.client;

import dev.micle.totemofreviving.TotemOfReviving;
import dev.micle.totemofreviving.item.totem.TotemItem;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;

public class ReviveTargetPacket {
    private final InteractionHand hand;

    public ReviveTargetPacket(InteractionHand hand) {
        this.hand = hand;
    }

    public static void encode(ReviveTargetPacket packet, FriendlyByteBuf buffer) {
        buffer.m_130068_((Enum)packet.hand);
    }

    public static ReviveTargetPacket decode(FriendlyByteBuf buffer) {
        return new ReviveTargetPacket((InteractionHand)buffer.m_130066_(InteractionHand.class));
    }

    public static void handle(ReviveTargetPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayer target;
            ServerPlayer sender = context.getSender();
            if (sender == null) {
                return;
            }
            ItemStack totemStack = sender.m_21120_(packet.hand);
            try {
                target = TotemOfReviving.getProxy().getServer().m_6846_().m_11259_(TotemItem.getTargetUUID(totemStack));
                if (target == null) {
                    throw new NullPointerException("Target is null!");
                }
            }
            catch (NullPointerException exception) {
                sender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Unable to find player!")));
                return;
            }
            if (!target.m_5833_()) {
                sender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.GRAY + target.m_5446_().getString() + ChatFormatting.WHITE + " is not dead!")));
                return;
            }
            if (!target.m_9236_().equals(sender.m_9236_()) && !TotemItem.canReviveAcrossDimensions(totemStack)) {
                sender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.GRAY + target.m_5446_().getString() + ChatFormatting.WHITE + " is in a different dimension!")));
                return;
            }
            TotemItem.setTargetDeaths(totemStack, target);
            if (!TotemItem.canTotemAffordTarget(totemStack)) {
                sender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Not enough charge!")));
                return;
            }
            target.m_8999_(sender.m_9236_(), sender.m_20182_().f_82479_, sender.m_20182_().f_82480_, sender.m_20182_().f_82481_, sender.m_146908_(), sender.m_146909_());
            target.m_143403_(sender.m_9236_().m_7654_().m_130008_());
            TotemItem.setCharge(totemStack, TotemItem.getCharge(totemStack) - TotemItem.getTargetCost(totemStack));
            totemStack.m_41622_(1, (LivingEntity)sender, e -> e.m_21190_(packet.hand));
            sender.m_213846_((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Successfully revived " + ChatFormatting.GRAY + target.m_5446_().getString() + "!")));
        });
        context.setPacketHandled(true);
    }
}

