/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.item.totem;

import dev.micle.totemofreviving.TotemOfReviving;
import dev.micle.totemofreviving.item.totem.DiamondTotemItem;
import dev.micle.totemofreviving.item.totem.IronTotemItem;
import dev.micle.totemofreviving.item.totem.NetheriteTotemItem;
import dev.micle.totemofreviving.item.totem.StrawTotemItem;
import dev.micle.totemofreviving.network.NetworkManager;
import dev.micle.totemofreviving.network.client.ChangeTargetPacket;
import dev.micle.totemofreviving.network.client.ChargeTotemPacket;
import dev.micle.totemofreviving.network.client.ReviveTargetPacket;
import dev.micle.totemofreviving.setup.Config;
import dev.micle.totemofreviving.setup.ModKeyMappings;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class TotemItem
extends Item {
    private static final String TAG_TARGET_INDEX = "target_index";
    private static final String TAG_TARGET_UUID = "target_uuid";
    private static final String TAG_TARGET_NAME = "target_name";
    private static final String TAG_TARGET_DEATHS = "target_deaths";
    private static final String TAG_CHARGE = "charge";

    public TotemItem(int durability) {
        this(Rarity.COMMON, durability);
    }

    public TotemItem(Rarity rarity, int durability) {
        super(new Item.Properties().m_41491_(TotemOfReviving.ITEM_GROUP).m_41487_(1).m_41497_(rarity).m_41499_(durability));
    }

    public abstract boolean isCharge(ItemStack var1);

    public static int getTargetIndex(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return -1;
        }
        return stack.m_41784_().m_128451_(TAG_TARGET_INDEX);
    }

    public static void setTargetIndex(ItemStack stack, int targetIndex) {
        if (!TotemItem.isTotem(stack)) {
            return;
        }
        stack.m_41784_().m_128405_(TAG_TARGET_INDEX, targetIndex);
    }

    public static UUID getTargetUUID(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return null;
        }
        try {
            return UUID.fromString(stack.m_41784_().m_128461_(TAG_TARGET_UUID));
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    public static void setTargetUUID(ItemStack stack, UUID targetUUID) {
        if (!TotemItem.isTotem(stack)) {
            return;
        }
        stack.m_41784_().m_128359_(TAG_TARGET_UUID, targetUUID.toString());
    }

    public static String getTargetName(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return null;
        }
        return stack.m_41784_().m_128461_(TAG_TARGET_NAME);
    }

    public static void setTargetName(ItemStack stack, String targetName) {
        if (!TotemItem.isTotem(stack)) {
            return;
        }
        stack.m_41784_().m_128359_(TAG_TARGET_NAME, targetName);
    }

    public static int getTargetCost(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return -1;
        }
        return !TotemItem.isCostDynamic(stack) ? TotemItem.getConfig(stack).getChargeCost() : (int)((double)TotemItem.getTargetDeaths(stack) * TotemItem.getConfig(stack).getChargeCostMultiplier());
    }

    public static int getTargetDeaths(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return -1;
        }
        return stack.m_41784_().m_128451_(TAG_TARGET_DEATHS);
    }

    public static void setTargetDeaths(ItemStack stack, ServerPlayer target) {
        if (!TotemItem.isTotem(stack)) {
            return;
        }
        stack.m_41784_().m_128405_(TAG_TARGET_DEATHS, target.m_8951_().m_13015_(Stats.f_12988_.m_12902_((Object)Stats.f_12935_)));
    }

    public static boolean isTotemFull(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return false;
        }
        return TotemItem.getCharge(stack) == TotemItem.getMaxCharge(stack);
    }

    public static boolean canTotemAffordTarget(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return false;
        }
        if (TotemItem.getCharge(stack) < TotemItem.getTargetCost(stack)) {
            if (!TotemItem.isTotemFull(stack)) {
                return false;
            }
            return TotemItem.isTotemFull(stack) && TotemItem.canReviveMoreExpensiveTargets(stack);
        }
        return true;
    }

    public static int getCharge(ItemStack stack) {
        int maxCharge;
        if (!TotemItem.isTotem(stack)) {
            return -1;
        }
        int charge = stack.m_41784_().m_128451_(TAG_CHARGE);
        if (charge > (maxCharge = TotemItem.getMaxCharge(stack))) {
            charge = maxCharge;
            TotemItem.setCharge(stack, charge);
        }
        return charge;
    }

    public static void setCharge(ItemStack stack, int charge) {
        if (!TotemItem.isTotem(stack)) {
            return;
        }
        stack.m_41784_().m_128405_(TAG_CHARGE, charge);
    }

    public static int getMaxCharge(ItemStack stack) {
        Config.TotemConfig config = TotemItem.getConfig(stack);
        if (config == null) {
            return -1;
        }
        if (config.getChargeCost() == -1) {
            return config.getChargeCostLimit();
        }
        return config.getChargeCost();
    }

    public static boolean isCostDynamic(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return false;
        }
        return TotemItem.getConfig(stack).getChargeCost() == -1;
    }

    public static boolean canReviveAcrossDimensions(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return false;
        }
        return TotemItem.getConfig(stack).getCanReviveAcrossDimensions();
    }

    public static boolean canReviveMoreExpensiveTargets(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return false;
        }
        return TotemItem.getConfig(stack).getCanReviveMoreExpensiveTargets();
    }

    public static boolean isEnabled(ItemStack stack) {
        if (!TotemItem.isTotem(stack)) {
            return false;
        }
        return TotemItem.getConfig(stack).getIsEnabled();
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (world == null) {
            return;
        }
        UUID targetUUID = TotemItem.getTargetUUID(stack);
        String targetName = TotemItem.getTargetName(stack);
        int targetCost = TotemItem.getTargetCost(stack);
        int charge = TotemItem.getCharge(stack);
        int maxCharge = TotemItem.getMaxCharge(stack);
        double multiplier = TotemItem.getConfig(stack).getChargeCostMultiplier();
        if (TotemItem.getConfig(stack).getIsEnabled()) {
            if (targetUUID == null) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Target: " + ChatFormatting.DARK_RED + "NONE")));
            } else {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Target: " + ChatFormatting.GRAY + targetName)));
            }
            tooltip.add((Component)Component.m_237113_((String)""));
            if (!TotemItem.canTotemAffordTarget(stack)) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Charges: " + ChatFormatting.DARK_RED + "(" + charge + "/" + targetCost + ") " + ChatFormatting.RED + "[Max: " + ChatFormatting.DARK_RED + maxCharge + ChatFormatting.RED + "] [Multi: " + ChatFormatting.DARK_RED + multiplier + ChatFormatting.RED + "]")));
            } else {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Charges: " + ChatFormatting.GRAY + "(" + charge + "/" + targetCost + ") " + ChatFormatting.WHITE + "[Max: " + ChatFormatting.GRAY + maxCharge + ChatFormatting.WHITE + "] [Multi: " + ChatFormatting.GRAY + multiplier + ChatFormatting.WHITE + "]")));
            }
            if (TotemItem.canReviveMoreExpensiveTargets(stack)) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Can revive more expensive targets.")));
            }
            if (TotemItem.canReviveAcrossDimensions(stack)) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Can revive targets across dimensions.")));
            }
            tooltip.add((Component)Component.m_237113_((String)""));
            if (ModKeyMappings.ADVANCED_TOOLTIP.m_90857_()) {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Showing advanced tooltip.")));
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "[" + ChatFormatting.GRAY + "R-CLICK" + ChatFormatting.WHITE + "]")));
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "When second hand is empty: revive target.")));
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "When second hand is holding a reviving charge: charge totem.")));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "[" + ChatFormatting.GRAY + "L-SHIFT + R-CLICK" + ChatFormatting.WHITE + "]")));
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Change target.")));
            } else {
                tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.GRAY + "Hold [" + ChatFormatting.DARK_GRAY + "L-SHIFT" + ChatFormatting.GRAY + "] for advanced tooltip.")));
            }
        } else {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Totem is disabled!")));
        }
        super.m_7373_(stack, world, tooltip, tooltipFlag);
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack chargeItem;
        if (!TotemItem.getConfig(player.m_21120_(hand)).getIsEnabled() || !world.f_46443_) {
            return super.m_7203_(world, player, hand);
        }
        ItemStack itemStack = chargeItem = hand.equals((Object)InteractionHand.MAIN_HAND) ? player.m_21206_() : player.m_21205_();
        if (player.m_6047_()) {
            NetworkManager.getChannel().sendToServer((Object)new ChangeTargetPacket(hand));
        } else if (this.isCharge(chargeItem)) {
            NetworkManager.getChannel().sendToServer((Object)new ChargeTotemPacket(hand));
        } else {
            NetworkManager.getChannel().sendToServer((Object)new ReviveTargetPacket(hand));
        }
        return super.m_7203_(world, player, hand);
    }

    public int getMaxDamage(ItemStack stack) {
        return TotemItem.getConfig(stack).getDurability();
    }

    public boolean isDamageable(ItemStack stack) {
        return TotemItem.getConfig(stack).getDurability() != 0;
    }

    public int getDamage(ItemStack stack) {
        if (this.isDamageable(stack) && super.getDamage(stack) >= this.getMaxDamage(stack)) {
            stack.m_41764_(0);
            return this.getMaxDamage(stack);
        }
        return this.isDamageable(stack) ? super.getDamage(stack) : 0;
    }

    private static boolean isTotem(ItemStack stack) {
        return stack.m_41720_() instanceof TotemItem;
    }

    private static Config.TotemConfig getConfig(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof StrawTotemItem) {
            return Config.Server.getStrawTotemConfig();
        }
        if (item instanceof IronTotemItem) {
            return Config.Server.getIronTotemConfig();
        }
        if (item instanceof DiamondTotemItem) {
            return Config.Server.getDiamondTotemConfig();
        }
        if (item instanceof NetheriteTotemItem) {
            return Config.Server.getNetheriteTotemConfig();
        }
        return null;
    }
}

