/*
 * Decompiled with CFR 0.152.
 */
package dev.micle.totemofreviving.item.charge;

import dev.micle.totemofreviving.TotemOfReviving;
import dev.micle.totemofreviving.item.charge.DiamondChargeItem;
import dev.micle.totemofreviving.item.charge.IronChargeItem;
import dev.micle.totemofreviving.item.charge.NetheriteChargeItem;
import dev.micle.totemofreviving.item.charge.StrawChargeItem;
import dev.micle.totemofreviving.setup.Config;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ChargeItem
extends Item {
    public ChargeItem() {
        this(Rarity.COMMON);
    }

    public ChargeItem(Rarity rarity) {
        super(new Item.Properties().m_41491_(TotemOfReviving.ITEM_GROUP).m_41487_(64).m_41497_(rarity));
    }

    @OnlyIn(value=Dist.CLIENT)
    @ParametersAreNonnullByDefault
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag tooltipFlag) {
        if (ChargeItem.isEnabled(stack)) {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.WHITE + "Used for charging its corresponding totem.")));
        } else {
            tooltip.add((Component)Component.m_237113_((String)(ChatFormatting.RED + "Totem is disabled!")));
        }
        super.m_7373_(stack, world, tooltip, tooltipFlag);
    }

    public static boolean isEnabled(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof StrawChargeItem) {
            return Config.Server.getStrawTotemConfig().getIsEnabled();
        }
        if (item instanceof IronChargeItem) {
            return Config.Server.getIronTotemConfig().getIsEnabled();
        }
        if (item instanceof DiamondChargeItem) {
            return Config.Server.getDiamondTotemConfig().getIsEnabled();
        }
        if (item instanceof NetheriteChargeItem) {
            return Config.Server.getNetheriteTotemConfig().getIsEnabled();
        }
        return false;
    }
}

