/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.util;

import com.github.alexthe666.iceandfire.world.IafWorldData;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class WorldUtil {
    public static boolean isBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isChunkLoaded(LevelAccessor world, int x, int z) {
        if (world.m_7726_() instanceof ServerChunkCache) {
            ChunkHolder holder = ((ServerChunkCache)world.m_7726_()).f_8325_.m_140327_(ChunkPos.m_45589_((int)x, (int)z));
            if (holder != null) {
                return holder.m_140082_().getNow(ChunkHolder.f_139997_).left().isPresent();
            }
            return false;
        }
        return world.m_6522_(x, z, ChunkStatus.f_62326_, false) != null;
    }

    public static void markChunkDirty(Level world, BlockPos pos) {
        if (WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) {
            world.m_6325_(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_8092_(true);
            BlockState state = world.m_8055_(pos);
            world.m_7260_(pos, state, state, 3);
        }
    }

    public static boolean isChunkLoaded(LevelAccessor world, ChunkPos pos) {
        return WorldUtil.isChunkLoaded(world, pos.f_45578_, pos.f_45579_);
    }

    public static boolean isEntityBlockLoaded(LevelAccessor world, BlockPos pos) {
        return WorldUtil.isEntityChunkLoaded(world, pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, int x, int z) {
        return WorldUtil.isEntityChunkLoaded(world, new ChunkPos(x, z));
    }

    public static boolean isEntityChunkLoaded(LevelAccessor world, ChunkPos pos) {
        if (world instanceof ServerLevel) {
            return WorldUtil.isChunkLoaded(world, pos) && ((ServerLevel)world).m_143340_(pos.m_45615_());
        }
        return WorldUtil.isChunkLoaded(world, pos);
    }

    public static boolean isAABBLoaded(Level world, AABB box) {
        return WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.f_82288_ >> 4, (int)box.f_82290_ >> 4) && WorldUtil.isChunkLoaded((LevelAccessor)world, (int)box.f_82291_ >> 4, (int)box.f_82293_ >> 4);
    }

    public static boolean isPastTime(Level world, int pastTime) {
        return world.m_46468_() % 24000L <= (long)pastTime;
    }

    public static boolean isOverworldType(@NotNull Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223538_);
    }

    public static boolean isNetherType(@NotNull Level world) {
        return WorldUtil.isOfWorldType(world, (ResourceKey<DimensionType>)BuiltinDimensionTypes.f_223539_);
    }

    public static boolean isOfWorldType(@NotNull Level world, @NotNull ResourceKey<DimensionType> type) {
        RegistryAccess dynRegistries = world.m_5962_();
        ResourceLocation loc = ((Registry)dynRegistries.m_6632_(Registry.f_122818_).get()).m_7981_((Object)world.m_6042_());
        if (loc == null) {
            if (world.f_46443_) {
                return world.m_6042_().f_63837_().equals((Object)type.m_135782_());
            }
            return false;
        }
        ResourceKey regKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)loc);
        return regKey == type;
    }

    public static boolean isPeaceful(@NotNull Level world) {
        return !world.m_6106_().m_5470_().m_46207_(GameRules.f_46134_) || world.m_46791_().equals((Object)Difficulty.PEACEFUL);
    }

    public static int getDimensionMaxHeight(DimensionType dimensionType) {
        return dimensionType.f_63865_() + dimensionType.f_156647_();
    }

    public static int getDimensionMinHeight(DimensionType dimensionType) {
        return dimensionType.f_156647_();
    }

    public static boolean isInWorldHeight(int yBlock, Level world) {
        DimensionType dimensionType = world.m_6042_();
        return yBlock > WorldUtil.getDimensionMinHeight(dimensionType) && yBlock < WorldUtil.getDimensionMaxHeight(dimensionType);
    }

    public static BlockPos containing(double d, double e, double f) {
        return new BlockPos(Mth.m_14107_((double)d), Mth.m_14107_((double)e), Mth.m_14107_((double)f));
    }

    public static BlockPos containing(Position position) {
        return WorldUtil.containing(position.m_7096_(), position.m_7098_(), position.m_7094_());
    }

    public static boolean canGenerate(int configChance, WorldGenLevel level, RandomSource random, BlockPos origin, String id, boolean checkFluid) {
        return WorldUtil.canGenerate(configChance, level, random, origin, id, IafWorldData.FeatureType.SURFACE, checkFluid);
    }

    public static boolean canGenerate(int configChance, WorldGenLevel level, RandomSource random, BlockPos origin, String id, IafWorldData.FeatureType type, boolean checkFluid) {
        boolean canGenerate;
        boolean bl = canGenerate = random.m_188503_(configChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)level, origin) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)level, origin, id, type);
        if (canGenerate && checkFluid && !level.m_6425_(origin.m_7495_()).m_76178_()) {
            return false;
        }
        return canGenerate;
    }
}

