/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class UiRenderMacros {
    public static final double HALF_BIAS = 0.5;

    public static void drawLineRectGradient(PoseStack ps, int x, int y, int w, int h, int argbColorStart, int argbColorEnd) {
        UiRenderMacros.drawLineRectGradient(ps, x, y, w, h, argbColorStart, argbColorEnd, 1);
    }

    public static void drawLineRectGradient(PoseStack ps, int x, int y, int w, int h, int argbColorStart, int argbColorEnd, int lineWidth) {
        UiRenderMacros.drawLineRectGradient(ps, x, y, w, h, argbColorStart >> 16 & 0xFF, argbColorEnd >> 16 & 0xFF, argbColorStart >> 8 & 0xFF, argbColorEnd >> 8 & 0xFF, argbColorStart & 0xFF, argbColorEnd & 0xFF, argbColorStart >> 24 & 0xFF, argbColorEnd >> 24 & 0xFF, lineWidth);
    }

    public static void drawLineRectGradient(PoseStack ps, int x, int y, int w, int h, int redStart, int redEnd, int greenStart, int greenEnd, int blueStart, int blueEnd, int alphaStart, int alphaEnd, int lineWidth) {
        if (lineWidth < 1 || alphaStart == 0 && alphaEnd == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        if (alphaStart != 255 || alphaEnd != 255) {
            RenderSystem.m_69478_();
        } else {
            RenderSystem.m_69461_();
        }
        Matrix4f m = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + lineWidth), (float)(y + lineWidth), 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        Tesselator.m_85913_().m_85914_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)(x + w - lineWidth), (float)(y + h - lineWidth), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
    }

    public static void drawLineRect(PoseStack ps, int x, int y, int w, int h, int argbColor) {
        UiRenderMacros.drawLineRect(ps, x, y, w, h, argbColor, 1);
    }

    public static void drawLineRect(PoseStack ps, int x, int y, int w, int h, int argbColor, int lineWidth) {
        UiRenderMacros.drawLineRect(ps, x, y, w, h, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF, lineWidth);
    }

    public static void drawLineRect(PoseStack ps, int x, int y, int w, int h, int red, int green, int blue, int alpha, int lineWidth) {
        if (lineWidth < 1 || alpha == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        if (alpha != 255) {
            RenderSystem.m_69478_();
        } else {
            RenderSystem.m_69461_();
        }
        Matrix4f m = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + lineWidth), (float)(y + lineWidth), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w - lineWidth), (float)(y + lineWidth), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w - lineWidth), (float)(y + h - lineWidth), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + lineWidth), (float)(y + h - lineWidth), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
    }

    public static void fill(PoseStack ps, int x, int y, int w, int h, int argbColor) {
        UiRenderMacros.fill(ps, x, y, w, h, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void fill(PoseStack ps, int x, int y, int w, int h, int red, int green, int blue, int alpha) {
        if (alpha == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        if (alpha != 255) {
            RenderSystem.m_69478_();
        } else {
            RenderSystem.m_69461_();
        }
        Matrix4f m = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
    }

    public static void fillGradient(PoseStack ps, int x, int y, int w, int h, int argbColorStart, int argbColorEnd) {
        UiRenderMacros.fillGradient(ps, x, y, w, h, argbColorStart >> 16 & 0xFF, argbColorEnd >> 16 & 0xFF, argbColorStart >> 8 & 0xFF, argbColorEnd >> 8 & 0xFF, argbColorStart & 0xFF, argbColorEnd & 0xFF, argbColorStart >> 24 & 0xFF, argbColorEnd >> 24 & 0xFF);
    }

    public static void fillGradient(PoseStack ps, int x, int y, int w, int h, int redStart, int redEnd, int greenStart, int greenEnd, int blueStart, int blueEnd, int alphaStart, int alphaEnd) {
        if (alphaStart == 0 && alphaEnd == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        if (alphaStart != 255 || alphaEnd != 255) {
            RenderSystem.m_69478_();
        } else {
            RenderSystem.m_69461_();
        }
        Matrix4f m = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
    }

    public static void hLine(PoseStack ps, int x, int xEnd, int y, int argbColor) {
        UiRenderMacros.line(ps, x, y, xEnd, y, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void hLine(PoseStack ps, int x, int xEnd, int y, int red, int green, int blue, int alpha) {
        UiRenderMacros.line(ps, x, y, xEnd, y, red, green, blue, alpha);
    }

    public static void vLine(PoseStack ps, int x, int y, int yEnd, int argbColor) {
        UiRenderMacros.line(ps, x, y, x, yEnd, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void vLine(PoseStack ps, int x, int y, int yEnd, int red, int green, int blue, int alpha) {
        UiRenderMacros.line(ps, x, y, x, yEnd, red, green, blue, alpha);
    }

    public static void line(PoseStack ps, int x, int y, int xEnd, int yEnd, int argbColor) {
        UiRenderMacros.line(ps, x, y, xEnd, yEnd, argbColor >> 16 & 0xFF, argbColor >> 8 & 0xFF, argbColor & 0xFF, argbColor >> 24 & 0xFF);
    }

    public static void line(PoseStack ps, int x, int y, int xEnd, int yEnd, int red, int green, int blue, int alpha) {
        if (alpha == 0) {
            return;
        }
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        if (alpha != 255) {
            RenderSystem.m_69478_();
        } else {
            RenderSystem.m_69461_();
        }
        Matrix4f m = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.DEBUG_LINES, DefaultVertexFormat.f_85815_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)xEnd, (float)yEnd, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        Tesselator.m_85913_().m_85914_();
        RenderSystem.m_69461_();
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h) {
        UiRenderMacros.blit(ps, rl, x, y, w, h, 0.0f, 0.0f, 1.0f, 1.0f);
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h, int u, int v, int mapW, int mapH) {
        UiRenderMacros.blit(ps, rl, x, y, w, h, (float)u / (float)mapW, (float)v / (float)mapH, (float)(u + w) / (float)mapW, (float)(v + h) / (float)mapH);
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h, int u, int v, int uW, int vH, int mapW, int mapH) {
        UiRenderMacros.blit(ps, rl, x, y, w, h, (float)u / (float)mapW, (float)v / (float)mapH, (float)(u + uW) / (float)mapW, (float)(v + vH) / (float)mapH);
    }

    public static void blit(PoseStack ps, ResourceLocation rl, int x, int y, int w, int h, float uMin, float vMin, float uMax, float vMax) {
        Minecraft.m_91087_().m_91097_().m_174784_(rl);
        RenderSystem.m_157456_((int)0, (ResourceLocation)rl);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Matrix4f m = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLE_FAN, DefaultVertexFormat.f_85817_);
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_7421_(uMin, vMin).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_7421_(uMin, vMax).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_7421_(uMax, vMax).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_7421_(uMax, vMin).m_5752_();
        Tesselator.m_85913_().m_85914_();
    }

    protected static void blitRepeatable(PoseStack ps, ResourceLocation rl, int x, int y, int width, int height, int u, int v, int uWidth, int vHeight, int textureWidth, int textureHeight, int uRepeat, int vRepeat, int repeatWidth, int repeatHeight) {
        if (uRepeat < 0 || vRepeat < 0 || uRepeat >= uWidth || vRepeat >= vHeight || repeatWidth < 1 || repeatHeight < 1 || repeatWidth > uWidth - uRepeat || repeatHeight > vHeight - vRepeat) {
            throw new IllegalArgumentException("Repeatable box is outside of texture box");
        }
        int repeatCountX = Math.max(1, Math.max(0, width - (uWidth - repeatWidth)) / repeatWidth);
        int repeatCountY = Math.max(1, Math.max(0, height - (vHeight - repeatHeight)) / repeatHeight);
        Matrix4f mat = ps.m_85850_().m_85861_();
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85817_);
        for (int i = 0; i < repeatCountX; ++i) {
            int uAdjust = i == 0 ? 0 : uRepeat;
            int xStart = x + uAdjust + i * repeatWidth;
            int w = Math.min(repeatWidth + uRepeat - uAdjust, width - (uWidth - uRepeat - repeatWidth));
            float minU = (float)(u + uAdjust) / (float)textureWidth;
            float maxU = (float)(u + uAdjust + w) / (float)textureWidth;
            for (int j = 0; j < repeatCountY; ++j) {
                int vAdjust = j == 0 ? 0 : vRepeat;
                int yStart = y + vAdjust + j * repeatHeight;
                int h = Math.min(repeatHeight + vRepeat - vAdjust, height - (vHeight - vRepeat - repeatHeight));
                float minV = (float)(v + vAdjust) / (float)textureHeight;
                float maxV = (float)(v + vAdjust + h) / (float)textureHeight;
                UiRenderMacros.populateBlitTriangles(buffer, mat, xStart, xStart + w, yStart, yStart + h, minU, maxU, minV, maxV);
            }
        }
        int xEnd = x + Math.min(uRepeat + repeatCountX * repeatWidth, width - (uWidth - uRepeat - repeatWidth));
        int yEnd = y + Math.min(vRepeat + repeatCountY * repeatHeight, height - (vHeight - vRepeat - repeatHeight));
        int uLeft = width - (xEnd - x);
        int vLeft = height - (yEnd - y);
        float restMinU = (float)(u + uWidth - uLeft) / (float)textureWidth;
        float restMaxU = (float)(u + uWidth) / (float)textureWidth;
        float restMinV = (float)(v + vHeight - vLeft) / (float)textureHeight;
        float restMaxV = (float)(v + vHeight) / (float)textureHeight;
        for (int i = 0; i < repeatCountX; ++i) {
            int uAdjust = i == 0 ? 0 : uRepeat;
            int xStart = x + uAdjust + i * repeatWidth;
            int w = Math.min(repeatWidth + uRepeat - uAdjust, width - uLeft);
            float minU = (float)(u + uAdjust) / (float)textureWidth;
            float maxU = (float)(u + uAdjust + w) / (float)textureWidth;
            UiRenderMacros.populateBlitTriangles(buffer, mat, xStart, xStart + w, yEnd, yEnd + vLeft, minU, maxU, restMinV, restMaxV);
        }
        for (int j = 0; j < repeatCountY; ++j) {
            int vAdjust = j == 0 ? 0 : vRepeat;
            int yStart = y + vAdjust + j * repeatHeight;
            int h = Math.min(repeatHeight + vRepeat - vAdjust, height - vLeft);
            float minV = (float)(v + vAdjust) / (float)textureHeight;
            float maxV = (float)(v + vAdjust + h) / (float)textureHeight;
            UiRenderMacros.populateBlitTriangles(buffer, mat, xEnd, xEnd + uLeft, yStart, yStart + h, restMinU, restMaxU, minV, maxV);
        }
        UiRenderMacros.populateBlitTriangles(buffer, mat, xEnd, xEnd + uLeft, yEnd, yEnd + vLeft, restMinU, restMaxU, restMinV, restMaxV);
        Minecraft.m_91087_().m_91097_().m_174784_(rl);
        RenderSystem.m_157456_((int)0, (ResourceLocation)rl);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        Tesselator.m_85913_().m_85914_();
    }

    public static void populateFillTriangles(Matrix4f m, BufferBuilder buffer, int x, int y, int w, int h, int red, int green, int blue, int alpha) {
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(red, green, blue, alpha).m_5752_();
    }

    public static void populateFillGradientTriangles(Matrix4f m, BufferBuilder buffer, int x, int y, int w, int h, int redStart, int redEnd, int greenStart, int greenEnd, int blueStart, int blueEnd, int alphaStart, int alphaEnd) {
        buffer.m_85982_(m, (float)x, (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)y, 0.0f).m_6122_(redStart, greenStart, blueStart, alphaStart).m_5752_();
        buffer.m_85982_(m, (float)x, (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
        buffer.m_85982_(m, (float)(x + w), (float)(y + h), 0.0f).m_6122_(redEnd, greenEnd, blueEnd, alphaEnd).m_5752_();
    }

    public static void populateBlitTriangles(BufferBuilder buffer, Matrix4f mat, float xStart, float xEnd, float yStart, float yEnd, float uMin, float uMax, float vMin, float vMax) {
        buffer.m_85982_(mat, xStart, yStart, 0.0f).m_7421_(uMin, vMin).m_5752_();
        buffer.m_85982_(mat, xStart, yEnd, 0.0f).m_7421_(uMin, vMax).m_5752_();
        buffer.m_85982_(mat, xEnd, yStart, 0.0f).m_7421_(uMax, vMin).m_5752_();
        buffer.m_85982_(mat, xEnd, yStart, 0.0f).m_7421_(uMax, vMin).m_5752_();
        buffer.m_85982_(mat, xStart, yEnd, 0.0f).m_7421_(uMin, vMax).m_5752_();
        buffer.m_85982_(mat, xEnd, yEnd, 0.0f).m_7421_(uMax, vMax).m_5752_();
    }
}

