/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.misc;

import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="iceandfire", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IafDamageRegistry {
    public static final String GORGON_DMG_TYPE = "gorgon";
    public static final String DRAGON_FIRE_TYPE = "dragon_fire";
    public static final String DRAGON_ICE_TYPE = "dragon_ice";
    public static final String DRAGON_LIGHTNING_TYPE = "dragon_lightning";

    public static CustomEntityDamageSource causeGorgonDamage(@Nullable Entity entity) {
        return (CustomEntityDamageSource)new CustomEntityDamageSource(GORGON_DMG_TYPE, entity).m_19380_().m_19382_();
    }

    public static CustomEntityDamageSource causeDragonFireDamage(@Nullable Entity entity) {
        return new CustomEntityDamageSource(DRAGON_FIRE_TYPE, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonFireDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new CustomIndirectEntityDamageSource(DRAGON_FIRE_TYPE, source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonIceDamage(@Nullable Entity entity) {
        return new CustomEntityDamageSource(DRAGON_ICE_TYPE, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonIceDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new CustomIndirectEntityDamageSource(DRAGON_ICE_TYPE, source, indirectEntityIn);
    }

    public static CustomEntityDamageSource causeDragonLightningDamage(@Nullable Entity entity) {
        return new CustomEntityDamageSource(DRAGON_LIGHTNING_TYPE, entity);
    }

    public static CustomIndirectEntityDamageSource causeIndirectDragonLightningDamage(Entity source, @Nullable Entity indirectEntityIn) {
        return new CustomIndirectEntityDamageSource(DRAGON_LIGHTNING_TYPE, source, indirectEntityIn);
    }

    static class CustomEntityDamageSource
    extends EntityDamageSource {
        public CustomEntityDamageSource(String damageTypeIn, @NotNull Entity damageSourceEntityIn) {
            super(damageTypeIn, damageSourceEntityIn);
        }

        @NotNull
        public Component m_6157_(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.m_21232_();
            String s = "death.attack." + this.m_19385_();
            int index = entityLivingBaseIn.m_217043_().m_188503_(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.m_237110_((String)s2, (Object[])new Object[]{entityLivingBaseIn.m_5446_(), livingentity.m_5446_()}) : Component.m_237110_((String)s1, (Object[])new Object[]{entityLivingBaseIn.m_5446_()});
        }
    }

    static class CustomIndirectEntityDamageSource
    extends IndirectEntityDamageSource {
        public CustomIndirectEntityDamageSource(String damageTypeIn, Entity source, @Nullable Entity indirectEntityIn) {
            super(damageTypeIn, source, indirectEntityIn);
        }

        @NotNull
        public Component m_6157_(LivingEntity entityLivingBaseIn) {
            LivingEntity livingentity = entityLivingBaseIn.m_21232_();
            String s = "death.attack." + this.m_19385_();
            int index = entityLivingBaseIn.m_217043_().m_188503_(2);
            String s1 = s + "." + index;
            String s2 = s + ".attacker_" + index;
            return livingentity != null ? Component.m_237110_((String)s2, (Object[])new Object[]{entityLivingBaseIn.m_5446_(), livingentity.m_5446_()}) : Component.m_237110_((String)s1, (Object[])new Object[]{entityLivingBaseIn.m_5446_()});
        }
    }
}

