/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.props;

import com.github.alexthe666.citadel.Citadel;
import com.github.alexthe666.citadel.server.entity.CitadelEntityData;
import com.github.alexthe666.citadel.server.message.PropertiesMessage;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.entity.EntitySiren;
import java.util.HashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class SirenProperties {
    private static final String SIREN_DATA = "SirenDataIaf";
    private static final String SIREN_CHARMED = "IsCharmed";
    private static final String SIREN_ID = "CharmedBy";
    private static final String SIREN_TIME = "CharmeTime";
    private static final Random rand = new Random();
    private static HashMap<CompoundTag, Boolean> containsCharmedData = new HashMap();

    private static CompoundTag getOrCreateCharmData(LivingEntity entity) {
        return SirenProperties.getOrCreateCharmData(CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static CompoundTag getOrCreateCharmData(CompoundTag entityData) {
        if (containsCharmedData.containsKey(entityData) && containsCharmedData.get(entityData).booleanValue() && entityData.m_128425_(SIREN_DATA, 10)) {
            return (CompoundTag)entityData.m_128423_(SIREN_DATA);
        }
        if (entityData.m_128425_(SIREN_DATA, 10)) {
            containsCharmedData.put(entityData, true);
            return (CompoundTag)entityData.m_128423_(SIREN_DATA);
        }
        containsCharmedData.put(entityData, false);
        return SirenProperties.createDefaultData();
    }

    private static void clearCharmedStatus(LivingEntity entity) {
        CompoundTag charmData = SirenProperties.getOrCreateCharmData(entity);
        SirenProperties.clearCharmedStatus(charmData);
        SirenProperties.updateCharmData(entity, charmData);
    }

    private static CompoundTag clearCharmedStatus(CompoundTag nbt) {
        nbt.m_128405_(SIREN_TIME, 0);
        nbt.m_128379_(SIREN_CHARMED, false);
        nbt.m_128405_(SIREN_ID, -1);
        return nbt;
    }

    private static CompoundTag createDefaultData() {
        CompoundTag nbt = new CompoundTag();
        return SirenProperties.clearCharmedStatus(nbt);
    }

    public static void updateData(LivingEntity entity) {
        SirenProperties.updateData(entity, CitadelEntityData.getCitadelTag((LivingEntity)entity));
    }

    private static void updateData(LivingEntity entity, CompoundTag nbt) {
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)nbt);
        if (!entity.f_19853_.m_5776_()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", nbt, entity.m_19879_()));
        }
    }

    private static void updateCharmData(LivingEntity entity, CompoundTag nbt) {
        CompoundTag entityData = CitadelEntityData.getOrCreateCitadelTag((LivingEntity)entity);
        entityData.m_128365_(SIREN_DATA, (Tag)nbt);
        CitadelEntityData.setCitadelTag((LivingEntity)entity, (CompoundTag)entityData);
        if (!entity.f_19853_.m_5776_()) {
            Citadel.sendMSGToAll((Object)new PropertiesMessage("CitadelPatreonConfig", entityData, entity.m_19879_()));
        }
    }

    private static int getSingTime(LivingEntity entity) {
        CompoundTag nbt = SirenProperties.getOrCreateCharmData(entity);
        if (nbt.m_128441_(SIREN_TIME)) {
            return nbt.m_128451_(SIREN_TIME);
        }
        return 0;
    }

    public static void setCharmedBy(LivingEntity entity, LivingEntity charmedBy) {
        CompoundTag nbt = SirenProperties.getOrCreateCharmData(entity);
        nbt.m_128405_(SIREN_ID, charmedBy.m_19879_());
        nbt.m_128379_(SIREN_CHARMED, true);
        SirenProperties.updateCharmData(entity, nbt);
    }

    private static int getCharmedBy(LivingEntity entity) {
        CompoundTag nbt = SirenProperties.getOrCreateCharmData(entity);
        if (nbt.m_128441_(SIREN_ID)) {
            return nbt.m_128451_(SIREN_ID);
        }
        return -1;
    }

    @Nullable
    public static EntitySiren getSiren(LivingEntity entity) {
        Entity siren = entity.f_19853_.m_6815_(SirenProperties.getCharmedBy(entity));
        if (siren instanceof EntitySiren) {
            return (EntitySiren)siren;
        }
        return null;
    }

    public static boolean isCharmed(LivingEntity entity) {
        CompoundTag nbt = SirenProperties.getOrCreateCharmData(entity);
        if (!nbt.m_128441_(SIREN_CHARMED)) {
            nbt = SirenProperties.createDefaultData();
            SirenProperties.updateCharmData(entity, nbt);
        }
        return nbt.m_128471_(SIREN_CHARMED);
    }

    public static void tickCharmedEntity(LivingEntity entity) {
        EntitySiren siren = SirenProperties.getSiren(entity);
        if (siren != null && siren.isActuallySinging()) {
            if (EntitySiren.isWearingEarplugs(entity) || SirenProperties.getSingTime(entity) > IafConfig.sirenMaxSingTime) {
                SirenProperties.clearCharmedStatus(entity);
                siren.singCooldown = IafConfig.sirenTimeBetweenSongs;
            } else {
                if (!siren.m_6084_() || entity.m_20270_((Entity)siren) > 64.0f || entity instanceof Player && ((Player)entity).m_7500_()) {
                    SirenProperties.clearCharmedStatus(entity);
                    return;
                }
                if ((double)entity.m_20270_((Entity)siren) < 5.0) {
                    SirenProperties.clearCharmedStatus(entity);
                    siren.singCooldown = IafConfig.sirenTimeBetweenSongs;
                    siren.setSinging(false);
                    siren.m_6710_(entity);
                    siren.m_21561_(true);
                    siren.triggerOtherSirens(entity);
                    return;
                }
                CompoundTag sirenData = SirenProperties.getOrCreateCharmData(entity);
                sirenData.m_128379_(SIREN_CHARMED, true);
                sirenData.m_128405_(SIREN_TIME, SirenProperties.getSingTime(entity));
                SirenProperties.updateCharmData(entity, sirenData);
                if (rand.nextInt(7) == 0) {
                    for (int i = 0; i < 5; ++i) {
                        entity.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123750_, entity.m_20185_() + (rand.nextDouble() - 0.5) * 3.0, entity.m_20186_() + (rand.nextDouble() - 0.5) * 3.0, entity.m_20189_() + (rand.nextDouble() - 0.5) * 3.0, 0.0, 0.0, 0.0);
                    }
                }
                if (entity.f_19862_) {
                    entity.m_6862_(true);
                }
                double motionXAdd = (Math.signum(siren.m_20185_() - entity.m_20185_()) * 0.5 - entity.m_20184_().f_82479_) * 0.100000000372529;
                double motionYAdd = (Math.signum(siren.m_20186_() - entity.m_20186_() + 1.0) * 0.5 - entity.m_20184_().f_82480_) * 0.100000000372529;
                double motionZAdd = (Math.signum(siren.m_20189_() - entity.m_20189_()) * 0.5 - entity.m_20184_().f_82481_) * 0.100000000372529;
                entity.m_20256_(entity.m_20184_().m_82520_(motionXAdd, motionYAdd, motionZAdd));
                if (entity.m_20159_()) {
                    entity.m_8127_();
                }
                if (!(entity instanceof Player)) {
                    double d0 = siren.m_20185_() - entity.m_20185_();
                    double d2 = siren.m_20189_() - entity.m_20189_();
                    double d1 = siren.m_20186_() - 1.0 - entity.m_20186_();
                    double d3 = Math.sqrt(d0 * d0 + d2 * d2);
                    float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
                    float f1 = (float)(-(Mth.m_14136_((double)d1, (double)d3) * 57.29577951308232));
                    entity.m_146926_(SirenProperties.updateRotation(entity.m_146909_(), f1, 30.0f));
                    entity.m_146922_(SirenProperties.updateRotation(entity.m_146908_(), f, 30.0f));
                }
            }
        }
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = Mth.m_14177_((float)(targetAngle - angle));
        if (f > maxIncrease) {
            f = maxIncrease;
        }
        if (f < -maxIncrease) {
            f = -maxIncrease;
        }
        return angle + f;
    }
}

