/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.citadel.client.model.AdvancedEntityModel;
import com.github.alexthe666.citadel.client.model.AdvancedModelBox;
import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.iceandfire.client.ClientProxy;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.QuadrupedModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class LayerDragonRider
extends RenderLayer<EntityDragonBase, AdvancedEntityModel<EntityDragonBase>> {
    private final MobRenderer render;
    private final boolean excludeDreadQueenMob;

    public LayerDragonRider(MobRenderer renderIn, boolean excludeDreadQueenMob) {
        super((RenderLayerParent)renderIn);
        this.render = renderIn;
        this.excludeDreadQueenMob = excludeDreadQueenMob;
    }

    public void render(PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, EntityDragonBase dragon, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.m_85836_();
        if (!dragon.m_20197_().isEmpty()) {
            float dragonScale = dragon.getRenderSize() / 3.0f;
            for (Entity passenger : dragon.m_20197_()) {
                boolean prey;
                boolean bl = prey = dragon.getControllingPassenger() == null || dragon.getControllingPassenger().m_19879_() != passenger.m_19879_();
                if (this.excludeDreadQueenMob && passenger instanceof EntityDreadQueen) {
                    prey = false;
                }
                ClientProxy.currentDragonRiders.remove(passenger.m_20148_());
                float riderRot = passenger.f_19859_ + (passenger.m_146908_() - passenger.f_19859_) * partialTicks;
                int animationTicks = 0;
                if (dragon.getAnimation() == EntityDragonBase.ANIMATION_SHAKEPREY) {
                    animationTicks = dragon.getAnimationTick();
                }
                if (animationTicks == 0 || animationTicks >= 15) {
                    this.translateToBody(matrixStackIn);
                }
                if (prey) {
                    if (animationTicks == 0 || animationTicks >= 15 || dragon.isFlying()) {
                        this.translateToHead(matrixStackIn);
                        this.offsetPerDragonType(dragon.dragonType, matrixStackIn);
                        EntityRenderer render = Minecraft.m_91087_().m_91290_().m_114382_(passenger);
                        EntityModel modelBase = null;
                        if (render instanceof MobRenderer) {
                            modelBase = ((MobRenderer)render).m_7200_();
                        }
                        if ((passenger.m_20206_() > passenger.m_20205_() || modelBase instanceof HumanoidModel) && !(modelBase instanceof QuadrupedModel) && !(modelBase instanceof HorseModel)) {
                            matrixStackIn.m_85837_((double)(-0.15f * passenger.m_20206_()), (double)(0.1f * dragonScale - 0.1f * passenger.m_20206_()), (double)(-0.1f * dragonScale - 0.1f * passenger.m_20205_()));
                            matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(90.0f));
                            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(45.0f));
                        } else {
                            boolean horse = modelBase instanceof HorseModel;
                            matrixStackIn.m_85837_((double)((horse ? -0.08f : -0.15f) * passenger.m_20205_()), (double)(0.1f * dragonScale - 0.15f * passenger.m_20205_()), (double)(-0.1f * dragonScale - 0.1f * passenger.m_20205_()));
                            matrixStackIn.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
                        }
                    } else {
                        matrixStackIn.m_85837_(0.0, (double)(0.555f * dragonScale), (double)(-0.5f * dragonScale));
                    }
                } else {
                    matrixStackIn.m_85837_(0.0, (double)(-0.01f * dragonScale), (double)(-0.035f * dragonScale));
                }
                matrixStackIn.m_85836_();
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(riderRot + 180.0f));
                matrixStackIn.m_85841_(1.0f / dragonScale, 1.0f / dragonScale, 1.0f / dragonScale);
                matrixStackIn.m_85837_(0.0, -0.25, 0.0);
                this.renderEntity(passenger, 0, 0, 0, 0.0f, partialTicks, matrixStackIn, bufferIn, packedLightIn);
                matrixStackIn.m_85849_();
                ClientProxy.currentDragonRiders.add(passenger.m_20148_());
            }
        }
        matrixStackIn.m_85849_();
    }

    protected void translateToBody(PoseStack stack) {
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("BodyUpper"), stack, 0.0625f);
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Neck1"), stack, 0.0625f);
    }

    protected void translateToHead(PoseStack stack) {
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Neck2"), stack, 0.0625f);
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Neck3"), stack, 0.0625f);
        this.postRender(((TabulaModel)this.render.m_7200_()).getCube("Head"), stack, 0.0625f);
    }

    protected void postRender(AdvancedModelBox renderer, PoseStack matrixStackIn, float scale) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f || renderer.rotationPointZ != 0.0f) {
                matrixStackIn.m_85837_((double)(renderer.rotationPointX * scale), (double)(renderer.rotationPointY * scale), (double)(renderer.rotationPointZ * scale));
            }
        } else {
            matrixStackIn.m_85837_((double)(renderer.rotationPointX * scale), (double)(renderer.rotationPointY * scale), (double)(renderer.rotationPointZ * scale));
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.m_85845_(Vector3f.f_122227_.m_122270_(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122270_(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.m_85845_(Vector3f.f_122223_.m_122270_(renderer.rotateAngleX));
            }
        }
    }

    private void offsetPerDragonType(DragonType dragonType, PoseStack stackIn) {
        if (dragonType == DragonType.LIGHTNING) {
            stackIn.m_85837_((double)0.1f, (double)-0.2f, (double)-0.1f);
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, int x, int y, int z, float yaw, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        block4: {
            EntityRenderer render = null;
            EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
            try {
                render = manager.m_114382_(entityIn);
                if (render == null) break block4;
                try {
                    render.m_7392_(entityIn, 0.0f, partialTicks, matrixStack, bufferIn, packedLight);
                }
                catch (Throwable throwable1) {
                    throw new ReportedException(CrashReport.m_127521_((Throwable)throwable1, (String)"Rendering entity in world"));
                }
            }
            catch (Throwable throwable3) {
                CrashReport crashreport = CrashReport.m_127521_((Throwable)throwable3, (String)"Rendering entity in world");
                CrashReportCategory crashreportcategory = crashreport.m_127514_("Entity being rendered");
                entityIn.m_7976_(crashreportcategory);
                CrashReportCategory crashreportcategory1 = crashreport.m_127514_("Renderer details");
                crashreportcategory1.m_128159_("Assigned renderer", (Object)render);
                crashreportcategory1.m_128159_("Location", (Object)new BlockPos(x, y, z));
                crashreportcategory1.m_128159_("Rotation", (Object)Float.valueOf(yaw));
                crashreportcategory1.m_128159_("Delta", (Object)Float.valueOf(partialTicks));
                throw new ReportedException(crashreport);
            }
        }
    }

    public boolean shouldCombineTextures() {
        return false;
    }
}

