/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RenderHippogryph
extends MobRenderer<EntityHippogryph, ModelHippogryph> {
    public RenderHippogryph(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new ModelHippogryph(), 0.8f);
        this.f_115291_.add(new LayerHippogriffSaddle(this));
    }

    protected void scale(@NotNull EntityHippogryph entity, PoseStack matrix, float partialTickTime) {
        matrix.m_85841_(1.2f, 1.2f, 1.2f);
    }

    @Nullable
    public ResourceLocation getTextureLocation(EntityHippogryph entity) {
        return entity.isBlinking() ? entity.getEnumVariant().TEXTURE_BLINK : entity.getEnumVariant().TEXTURE;
    }

    private class LayerHippogriffSaddle
    extends RenderLayer<EntityHippogryph, ModelHippogryph> {
        private final RenderHippogryph renderer;
        private final RenderType SADDLE_TEXTURE;
        private final RenderType BRIDLE;
        private final RenderType CHEST;
        private final RenderType TEXTURE_DIAMOND;
        private final RenderType TEXTURE_GOLD;
        private final RenderType TEXTURE_IRON;

        public LayerHippogriffSaddle(RenderHippogryph renderer) {
            super((RenderLayerParent)renderer);
            this.SADDLE_TEXTURE = RenderType.m_110482_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/saddle.png"));
            this.BRIDLE = RenderType.m_110482_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/bridle.png"));
            this.CHEST = RenderType.m_110473_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/chest.png"));
            this.TEXTURE_DIAMOND = RenderType.m_110482_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/armor_diamond.png"));
            this.TEXTURE_GOLD = RenderType.m_110482_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/armor_gold.png"));
            this.TEXTURE_IRON = RenderType.m_110482_((ResourceLocation)new ResourceLocation("iceandfire:textures/models/hippogryph/armor_iron.png"));
            this.renderer = renderer;
        }

        public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, EntityHippogryph hippo, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            VertexConsumer ivertexbuilder;
            if (hippo.getArmor() != 0) {
                RenderType type = null;
                switch (hippo.getArmor()) {
                    case 1: {
                        type = this.TEXTURE_IRON;
                        break;
                    }
                    case 2: {
                        type = this.TEXTURE_GOLD;
                        break;
                    }
                    case 3: {
                        type = this.TEXTURE_DIAMOND;
                    }
                }
                VertexConsumer ivertexbuilder2 = bufferIn.m_6299_(type);
                ((ModelHippogryph)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder2, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isSaddled()) {
                ivertexbuilder = bufferIn.m_6299_(this.SADDLE_TEXTURE);
                ((ModelHippogryph)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isSaddled() && hippo.getControllingPassenger() != null) {
                ivertexbuilder = bufferIn.m_6299_(this.BRIDLE);
                ((ModelHippogryph)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (hippo.isChested()) {
                ivertexbuilder = bufferIn.m_6299_(this.CHEST);
                ((ModelHippogryph)this.m_117386_()).m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }
}

