/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.citadel.client.model.TabulaModel;
import com.github.alexthe666.citadel.client.model.basic.BasicModelPart;
import com.github.alexthe666.iceandfire.entity.EntityDragonSkull;
import com.github.alexthe666.iceandfire.enums.EnumDragonTextures;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class RenderDragonSkull
extends EntityRenderer<EntityDragonSkull> {
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    private final TabulaModel fireDragonModel;
    private final TabulaModel lightningDragonModel;
    private final TabulaModel iceDragonModel;
    public float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};

    public RenderDragonSkull(EntityRendererProvider.Context context, TabulaModel fireDragonModel, TabulaModel iceDragonModel, TabulaModel lightningDragonModel) {
        super(context);
        this.fireDragonModel = fireDragonModel;
        this.iceDragonModel = iceDragonModel;
        this.lightningDragonModel = lightningDragonModel;
    }

    private static void setRotationAngles(BasicModelPart cube, float rotX, float rotY, float rotZ) {
        cube.rotateAngleX = rotX;
        cube.rotateAngleY = rotY;
        cube.rotateAngleZ = rotZ;
    }

    public void render(EntityDragonSkull entity, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        TabulaModel model = entity.getDragonType() == 2 ? this.lightningDragonModel : (entity.getDragonType() == 1 ? this.iceDragonModel : this.fireDragonModel);
        VertexConsumer ivertexbuilder = bufferIn.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
        matrixStackIn.m_85836_();
        matrixStackIn.m_85845_(Vector3f.f_122223_.m_122240_(-180.0f));
        matrixStackIn.m_85845_(Vector3f.f_122224_.m_122240_(-180.0f - entity.getYaw()));
        float f = 0.0625f;
        matrixStackIn.m_85841_(1.0f, 1.0f, 1.0f);
        float size = this.getRenderSize(entity) / 3.0f;
        matrixStackIn.m_85841_(size, size, size);
        matrixStackIn.m_85837_(0.0, entity.isOnWall() ? (double)-0.24f : (double)-0.12f, entity.isOnWall() ? (double)0.4f : 0.5);
        model.resetToDefaultPose();
        RenderDragonSkull.setRotationAngles((BasicModelPart)model.getCube("Head"), entity.isOnWall() ? (float)Math.toRadians(50.0) : 0.0f, 0.0f, 0.0f);
        model.getCube("Head").render(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        matrixStackIn.m_85849_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(EntityDragonSkull entity) {
        if (entity.getDragonType() == 2) {
            return EnumDragonTextures.getLightningDragonSkullTextures(entity);
        }
        if (entity.getDragonType() == 1) {
            return EnumDragonTextures.getIceDragonSkullTextures(entity);
        }
        return EnumDragonTextures.getFireDragonSkullTextures(entity);
    }

    public float getRenderSize(EntityDragonSkull skull) {
        float step = (this.growth_stages[skull.getDragonStage() - 1][1] - this.growth_stages[skull.getDragonStage() - 1][0]) / 25.0f;
        if (skull.getDragonAge() > 125) {
            return this.growth_stages[skull.getDragonStage() - 1][0] + step * 25.0f;
        }
        return this.growth_stages[skull.getDragonStage() - 1][0] + step * (float)this.getAgeFactor(skull);
    }

    private int getAgeFactor(EntityDragonSkull skull) {
        return skull.getDragonStage() > 1 ? skull.getDragonAge() - 25 * (skull.getDragonStage() - 1) : skull.getDragonAge();
    }
}

