/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.block;

import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.block.IDreadBlock;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class BlockDreadWoodLock
extends Block
implements IDragonProof,
IDreadBlock {
    public static final BooleanProperty PLAYER_PLACED = BooleanProperty.m_61465_((String)"player_placed");

    public BlockDreadWoodLock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(-1.0f, 1000000.0f).m_60918_(SoundType.f_56736_));
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.FALSE));
    }

    public float m_5880_(BlockState state, @NotNull Player player, @NotNull BlockGetter worldIn, @NotNull BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)PLAYER_PLACED)).booleanValue()) {
            float f = 8.0f;
            return player.getDigSpeed(state, pos) / f / 30.0f;
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, Player player, @NotNull InteractionHand handIn, @NotNull BlockHitResult resultIn) {
        ItemStack stack = player.m_21120_(handIn);
        if (stack.m_41720_() == IafItemRegistry.DREAD_KEY.get()) {
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.deleteNearbyWood(worldIn, pos, pos);
            worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12600_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            worldIn.m_7785_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11749_, SoundSource.BLOCKS, 1.0f, 2.0f, false);
        }
        return InteractionResult.SUCCESS;
    }

    private void deleteNearbyWood(Level worldIn, BlockPos pos, BlockPos startPos) {
        if (pos.m_123331_((Vec3i)startPos) < 32.0 && (worldIn.m_8055_(pos).m_60734_() == IafBlockRegistry.DREADWOOD_PLANKS.get() || worldIn.m_8055_(pos).m_60734_() == IafBlockRegistry.DREADWOOD_PLANKS_LOCK.get())) {
            worldIn.m_46961_(pos, false);
            for (Direction facing : Direction.values()) {
                this.deleteNearbyWood(worldIn, pos.m_121945_(facing), startPos);
            }
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PLAYER_PLACED});
    }

    public BlockState getStateForPlacement(Level worldIn, BlockPos pos, Direction facing, float hitX, float hitY, float hitZ, int meta, LivingEntity placer) {
        return (BlockState)this.m_49966_().m_61124_((Property)PLAYER_PLACED, (Comparable)Boolean.valueOf(true));
    }
}

