/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.util.damage;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.util.damage.DamageInfo;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class DamageAdaptation {
    private final int adaptDamageTypesCount;
    private final int resetCountdown;
    private final float singleAdaptFactor;
    private final float maxAdaptFactor;
    private final boolean adaptsSameTypeMobs;
    private final Map<String, DamageInfo> adaptMap = new ConcurrentHashMap<String, DamageInfo>();
    private boolean adaptBypassesDamage;

    public DamageAdaptation(int adaptDamageTypesCount, int resetCountdown, float singleAdaptFactor, float maxAdaptFactor, boolean adaptsSameTypeMobs) {
        this.adaptDamageTypesCount = adaptDamageTypesCount;
        this.resetCountdown = resetCountdown;
        this.singleAdaptFactor = singleAdaptFactor;
        this.maxAdaptFactor = maxAdaptFactor;
        this.adaptsSameTypeMobs = adaptsSameTypeMobs;
    }

    public DamageAdaptation(EMConfigHandler.DamageSourceAdaptConfig config) {
        this.adaptDamageTypesCount = (Integer)config.maxDamageSourceAdaptCount.get();
        this.resetCountdown = (Integer)config.resetCountdown.get() * 20;
        this.singleAdaptFactor = ((Double)config.singleAdaptFactor.get()).floatValue();
        this.maxAdaptFactor = ((Double)config.maxAdaptFactor.get()).floatValue();
        this.adaptBypassesDamage = (Boolean)config.adaptBypassesDamage.get();
        this.adaptsSameTypeMobs = config.adaptsSameTypeMobs;
    }

    public DamageAdaptation setAdaptBypassesDamage(boolean adaptBypassesDamage) {
        this.adaptBypassesDamage = adaptBypassesDamage;
        return this;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public float damageAfterAdaptingOnce(LivingEntity entity, @Nullable DamageSource source, float amount) {
        if (this.maxAdaptFactor <= 0.0f) return amount;
        if (this.singleAdaptFactor <= 0.0f) {
            return amount;
        }
        try {
            String key = DamageAdaptation.getKey(source, this.adaptsSameTypeMobs, this.adaptBypassesDamage);
            if (key == null) {
                return amount;
            }
            DamageInfo info = this.adaptMap.getOrDefault(key, null);
            long tickStamp = entity.f_19797_;
            if (info != null) {
                if (tickStamp <= info.getTimestamp() + (long)this.resetCountdown) {
                    float newAdaptFactor = Math.min(info.getAdaptFactor() + this.singleAdaptFactor, this.maxAdaptFactor);
                    float adaptedAmount = amount * (1.0f - newAdaptFactor);
                    info.setAdaptFactor(newAdaptFactor);
                    info.setTimestamp(tickStamp);
                    this.adaptMap.put(key, info);
                    return Math.max(adaptedAmount, 0.0f);
                }
                this.adaptMap.remove(key);
            } else if (this.adaptMap.size() >= this.adaptDamageTypesCount) {
                this.updateCache(entity);
                return amount;
            }
            this.adaptMap.put(key, new DamageInfo(tickStamp, 0.0f));
            return amount;
        }
        catch (Exception e) {
            EEEABMobs.LOGGER.error("An unexpected exception occurred when calculating damage: {}", (Object)e.getMessage());
        }
        return amount;
    }

    public float getAdaptFactorTotalBySource(LivingEntity entity, @Nullable DamageSource source) {
        String key = DamageAdaptation.getKey(source, this.adaptsSameTypeMobs, this.adaptBypassesDamage);
        if (key == null) {
            return -1.0f;
        }
        DamageInfo damageInfo = this.adaptMap.get(key);
        if (damageInfo != null) {
            return (long)entity.f_19797_ > damageInfo.getTimestamp() + (long)this.resetCountdown ? -1.0f : damageInfo.getAdaptFactor();
        }
        return -1.0f;
    }

    public boolean isFullyAdapted(LivingEntity entity, @Nullable DamageSource source) {
        return this.maxAdaptFactor > 0.0f && this.getAdaptFactorTotalBySource(entity, source) >= this.maxAdaptFactor;
    }

    public void updateCache(LivingEntity entity) {
        this.adaptMap.entrySet().removeIf(entry -> (long)entity.f_19797_ > ((DamageInfo)entry.getValue()).getTimestamp() + (long)this.resetCountdown);
    }

    public void clearCache() {
        this.adaptMap.clear();
    }

    @Nullable
    private static String getKey(@Nullable DamageSource source, boolean adaptsSameTypeMobs, boolean adaptBypassesDamage) {
        if (source == null) {
            return "unknown_source";
        }
        if (source.m_7639_() == null && source != DamageSource.f_19317_ && source != DamageSource.f_19318_) {
            return DamageAdaptation.spliceCharacters(source.f_19326_, "unknown_entity");
        }
        if (source.m_7639_() != null) {
            String id;
            EntityDamageSource entityDamageSource;
            if (source instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)source).m_19403_()) {
                return null;
            }
            Entity entity = source.m_7639_();
            String key = id = adaptsSameTypeMobs ? entity.m_6095_().m_20675_() : entity.m_20149_();
            if (entity instanceof Player) {
                Player player = (Player)entity;
                InteractionHand hand = player.m_7655_();
                key = DamageAdaptation.spliceCharacters(id, player.m_21120_(hand).m_41720_().m_5524_());
            }
            return key;
        }
        return adaptBypassesDamage ? DamageAdaptation.spliceCharacters(source.f_19326_, "bypasses_source") : null;
    }

    private static String spliceCharacters(String str1, String str2) {
        return str1 + ":" + str2;
    }
}

