/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.util;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;

public class EMMathUtils {
    public static Axis XN = new Axis(-1.0f, 0.0f, 0.0f);
    public static Axis XP = new Axis(1.0f, 0.0f, 0.0f);
    public static Axis YN = new Axis(0.0f, -1.0f, 0.0f);
    public static Axis YP = new Axis(0.0f, 1.0f, 0.0f);
    public static Axis ZN = new Axis(0.0f, 0.0f, -1.0f);
    public static Axis ZP = new Axis(0.0f, 0.0f, 1.0f);

    public static float clamp(float value, float min, float max) {
        return value < min ? min : Math.min(value, max);
    }

    public static float getTickFactor(float tick, float duration, boolean inversion) {
        float v = EMMathUtils.clamp(tick / duration, 0.0f, 1.0f);
        return inversion ? 1.0f - v : v;
    }

    public static float calculateSpeedMultiplier(float tickFactor, float distanceFactor, float exponent, float speedModifier) {
        float speedFactor = (float)Math.pow(tickFactor, exponent) * (float)Math.pow(2.0, -exponent * (1.0f - tickFactor)) * distanceFactor;
        return speedModifier * speedFactor;
    }

    public static Quaternion rotation(Vector3f axis, float angle, boolean degrees) {
        return new Quaternion(axis, angle, degrees);
    }

    public static Quaternion rotationXYZ(float x, float y, float z, boolean degrees) {
        return new Quaternion(x, y, z, degrees);
    }

    public static class Axis {
        private final Vector3f axis;

        public Axis(float x, float y, float z) {
            this.axis = new Vector3f(x, y, z);
        }

        public Quaternion rotation(float angle) {
            return EMMathUtils.rotation(this.axis, angle, false);
        }

        public Quaternion rotationDegrees(float degrees) {
            return EMMathUtils.rotation(this.axis, degrees, true);
        }
    }
}

