/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.handler;

import com.eeeab.eeeabsmobs.sever.capability.AbilityCapability;
import com.eeeab.eeeabsmobs.sever.capability.FrenzyCapability;
import com.eeeab.eeeabsmobs.sever.capability.PlayerCapability;
import com.eeeab.eeeabsmobs.sever.capability.VertigoCapability;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;

public class HandlerCapability {
    public static final Capability<VertigoCapability.IVertigoCapability> MOVING_CONTROLLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<VertigoCapability.IVertigoCapability>(){});
    public static final Capability<AbilityCapability.IAbilityCapability> CUSTOM_ABILITY_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<AbilityCapability.IAbilityCapability>(){});
    public static final Capability<FrenzyCapability.IFrenzyCapability> FRENZY_EFFECT_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<FrenzyCapability.IFrenzyCapability>(){});
    public static final Capability<PlayerCapability.PlayerCapabilityImpl> PLAYER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerCapability.PlayerCapabilityImpl>(){});

    public static void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(VertigoCapability.IVertigoCapability.class);
        event.register(AbilityCapability.IAbilityCapability.class);
        event.register(FrenzyCapability.IFrenzyCapability.class);
    }

    @Nullable
    public static <T> T getCapability(Entity entity, Capability<T> capability) {
        if (entity == null) {
            return null;
        }
        if (!entity.m_6084_()) {
            return null;
        }
        return (T)(entity.getCapability(capability).isPresent() ? entity.getCapability(capability).orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")) : null);
    }

    public static void attachEntityCapability(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof LivingEntity) {
            event.addCapability(VertigoCapability.ID, (ICapabilityProvider)new VertigoCapability.VertigoCapabilityProvider());
            event.addCapability(FrenzyCapability.ID, (ICapabilityProvider)new FrenzyCapability.FrenzyCapabilityProvider());
            if (entity instanceof Player) {
                event.addCapability(AbilityCapability.ID, (ICapabilityProvider)new AbilityCapability.AbilityCapabilityProvider());
                event.addCapability(PlayerCapability.ID, (ICapabilityProvider)new PlayerCapability.PlayerCapabilityProvider());
            }
        }
    }
}

