/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.util;

import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.util.EMMathUtils;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ShockWaveUtils {
    public static List<LivingEntity> doRingShockWave(Level level, Vec3 center, double radius, float baseBouncing, boolean customLife, int defaultLifeTime) {
        Vec3 closestEdge = new Vec3((double)Math.round(center.f_82479_), Math.floor(center.f_82480_), (double)Math.round(center.f_82481_));
        Vec3 centerOfBlock = new Vec3(Math.floor(center.f_82479_) + 0.5, Math.floor(center.f_82480_), Math.floor(center.f_82481_) + 0.5);
        center = closestEdge.m_82557_(center) < centerOfBlock.m_82557_(center) ? closestEdge : centerOfBlock;
        radius = Math.max(0.5, radius);
        int xFrom = (int)Math.floor(center.f_82479_ - radius);
        int xTo = (int)Math.ceil(center.f_82479_ + radius);
        int zFrom = (int)Math.floor(center.f_82481_ - radius);
        int zTo = (int)Math.ceil(center.f_82481_ + radius);
        for (int i = zFrom; i <= zTo; ++i) {
            for (int j = xFrom; j <= xTo; ++j) {
                Vec2 vec2 = new Vec2(j, i);
                double y = center.f_82480_;
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((double)vec2.x(), ShockWaveUtils.checkSpawnY(level, vec2.x(), vec2.z(), y), (double)vec2.z());
                Vec3 blockCenter = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5);
                Vec3 centerToBlock = blockCenter.m_82546_(center);
                double distance = centerToBlock.m_165924_();
                double distanceToMax = radius - distance;
                if (radius < distance) continue;
                double bounceExponent = Math.min(1.0 / (radius * radius), 0.1) * (1.0 + distanceToMax / radius * 2.0);
                if (level.f_46443_) continue;
                Vec3 rotAxis = new Vec3(0.0, -1.0, 0.0).m_82537_(centerToBlock).m_82541_();
                Vector3f axis = new Vector3f((float)rotAxis.f_82479_, (float)rotAxis.f_82480_, (float)rotAxis.f_82481_);
                Quaternion rotator = EMMathUtils.rotation(axis, (float)(distance / radius) * 15.0f + level.f_46441_.m_188501_() * 10.0f - 5.0f, true);
                rotator.m_80148_(EMMathUtils.XP.rotationDegrees(level.f_46441_.m_188501_() * 12.0f - 6.0f));
                rotator.m_80148_(EMMathUtils.YP.rotationDegrees(level.f_46441_.m_188501_() * 40.0f - 20.0f));
                rotator.m_80148_(EMMathUtils.ZP.rotationDegrees(level.f_46441_.m_188501_() * 12.0f - 6.0f));
                float bouncing = (float)((double)baseBouncing + distance * bounceExponent);
                int liftTime = defaultLifeTime;
                if (!customLife) {
                    liftTime = defaultLifeTime + level.f_46441_.m_188503_((int)radius * defaultLifeTime);
                }
                ModEntityUtils.spawnFallingBlockByPos((ServerLevel)level, (BlockPos)pos, rotator, liftTime, bouncing);
            }
        }
        if (level.f_46443_) {
            return new ArrayList<LivingEntity>();
        }
        return level.m_45976_(LivingEntity.class, new AABB((double)xFrom, center.f_82480_ - radius, (double)zFrom, (double)xTo, center.f_82480_ + radius, (double)zTo));
    }

    public static void doAdvShockWave(LivingEntity attacker, int distance, float maxFallingDistance, double spreadArc, double offset, double attackY, boolean randomOffset, boolean continuous, Consumer<Entity> hitProvider, float knockBackStrength) {
        ServerLevel level = (ServerLevel)attacker.f_19853_;
        double perpFacing = (double)attacker.f_20883_ * (Math.PI / 180);
        double facingAngle = perpFacing + 1.5707963267948966;
        double spread = Math.PI * spreadArc;
        int arcLen = Mth.m_14165_((double)((double)distance * spread));
        double minY = attacker.m_20191_().f_82289_ - attackY;
        double maxY = attacker.m_20191_().f_82292_ + attackY;
        int hitY = Mth.m_14107_((double)(attacker.m_20191_().f_82289_ - 0.5));
        for (int i = 0; i < arcLen; ++i) {
            double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
            double vx = Math.cos(theta);
            double vz = Math.sin(theta);
            double px = attacker.m_20185_() + vx * (double)distance + offset * Math.cos((double)(attacker.f_20883_ + 90.0f) * Math.PI / 180.0);
            double pz = attacker.m_20189_() + vz * (double)distance + offset * Math.sin((double)(attacker.f_20883_ + 90.0f) * Math.PI / 180.0);
            AABB aabb = new AABB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
            List entities = attacker.f_19853_.m_6443_(Entity.class, aabb, entity -> entity.m_6097_() && attacker != entity);
            for (Entity entity2 : entities) {
                hitProvider.accept(entity2);
            }
            float factor = 1.0f - ((float)distance / 2.0f - 2.0f) / maxFallingDistance;
            if (!continuous && !(attacker.m_217043_().m_188501_() < 0.6f)) continue;
            int hitX = Mth.m_14107_((double)px);
            int hitZ = Mth.m_14107_((double)pz);
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos((double)hitX, ShockWaveUtils.checkSpawnY((Level)level, hitX, hitZ, hitY), (double)hitZ);
            if (randomOffset) {
                ModEntityUtils.spawnFallingBlockByPos(level, (BlockPos)pos, factor);
                continue;
            }
            double d0 = (double)hitX - attacker.m_20185_();
            double d1 = (double)hitZ - attacker.m_20189_();
            double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
            ModEntityUtils.spawnFallingBlockByPos(level, (BlockPos)pos, d0 / d2 * (double)knockBackStrength, d1 / d2 * (double)knockBackStrength);
        }
    }

    private static double checkSpawnY(Level level, double x, double z, double y) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, (double)Math.round(y), z);
        if (!level.m_8055_((BlockPos)pos).m_60795_()) {
            if (!level.m_8055_(pos.m_7494_()).m_60795_()) {
                return pos.m_123342_() + 1;
            }
            return y;
        }
        for (int offset = 1; offset <= (Integer)EMConfigHandler.COMMON.ENTITY.fallingBlockBelowCheckRange.get(); ++offset) {
            BlockState stateBelow = level.m_8055_(pos.m_6625_(offset));
            if (stateBelow.m_60795_()) continue;
            return pos.m_123342_() - offset;
        }
        return y;
    }

    private record Vec2(float x, float z) {
    }
}

