/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.animate.server.ai.AnimationGroupAI;
import com.eeeab.animate.server.ai.AnimationMeleePlusAI;
import com.eeeab.animate.server.ai.animation.AnimationDie;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.client.particle.ParticleDust;
import com.eeeab.eeeabsmobs.client.particle.base.ParticleOrb;
import com.eeeab.eeeabsmobs.client.particle.base.ParticleRing;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleBase;
import com.eeeab.eeeabsmobs.client.particle.util.AdvancedParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.ParticleComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonComponent;
import com.eeeab.eeeabsmobs.client.particle.util.RibbonParticleData;
import com.eeeab.eeeabsmobs.client.particle.util.anim.AnimData;
import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.client.util.ModParticleUtils;
import com.eeeab.eeeabsmobs.sever.config.EMConfigHandler;
import com.eeeab.eeeabsmobs.sever.entity.IBoss;
import com.eeeab.eeeabsmobs.sever.entity.XpReward;
import com.eeeab.eeeabsmobs.sever.entity.ai.control.EMBodyRotationControl;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalAttractGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalBlockGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalComboGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalMagicGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalPounceGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalShakeGroundGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.animate.ImmortalStunGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.navigate.EMPathNavigateGround;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCameraShake;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityImmortalMagicCircle;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.ImmortalStage;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.entity.util.ModMobType;
import com.eeeab.eeeabsmobs.sever.entity.util.TickBasedProbabilityBooster;
import com.eeeab.eeeabsmobs.sever.init.AttributeInit;
import com.eeeab.eeeabsmobs.sever.init.EffectInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.init.ParticleInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMMathUtils;
import com.eeeab.eeeabsmobs.sever.util.EMStackTraceUtils;
import com.eeeab.eeeabsmobs.sever.util.EMTagKey;
import com.eeeab.eeeabsmobs.sever.util.damage.DamageAdaptation;
import com.eeeab.eeeabsmobs.sever.util.damage.EMDamageSource;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;

public class EntityImmortal
extends EntityAbsImmortal
implements IBoss {
    public final Animation dieAnimation = Animation.create(60);
    public final Animation spawnAnimation = Animation.create(100);
    public final Animation switchStageAnimation = Animation.create(100);
    public final Animation teleportAnimation = Animation.coexist(25);
    public final Animation smashGround1Animation = Animation.coexist(45);
    public final Animation smashGround2Animation = Animation.coexist(80);
    public final Animation smashGround3Animation = Animation.create(50);
    public final Animation punchRightAnimation = Animation.coexist(40);
    public final Animation punchLeftAnimation = Animation.coexist(40);
    public final Animation hardPunchRightAnimation = Animation.create(45);
    public final Animation hardPunchLeftAnimation = Animation.create(45);
    public final Animation pouncePreAnimation = Animation.create(15);
    public final Animation pounceHoldAnimation = Animation.create(42);
    public final Animation pounceEndAnimation = Animation.create(15);
    public final Animation pounceSmashAnimation = Animation.create(50);
    public final Animation pouncePickAnimation = Animation.create(40);
    public final Animation attractAnimation = Animation.create(70);
    public final Animation shoryukenAnimation = Animation.create(80);
    public final Animation trackingShurikenAnimation = Animation.coexist(25);
    public final Animation unleashEnergyAnimation = Animation.create(100);
    public final Animation armBlockAnimation = Animation.create(15);
    public final Animation armBlockHoldAnimation = Animation.create(50);
    public final Animation armBlockEndAnimation = Animation.create(10);
    public final Animation armBlockCounterattackAnimation = Animation.coexist(20);
    public final Animation hurt1Animation = Animation.create(60);
    private final Animation[] animations = new Animation[]{this.dieAnimation, this.spawnAnimation, this.teleportAnimation, this.armBlockAnimation, this.armBlockHoldAnimation, this.armBlockEndAnimation, this.armBlockCounterattackAnimation, this.punchRightAnimation, this.hardPunchRightAnimation, this.punchLeftAnimation, this.hardPunchLeftAnimation, this.smashGround1Animation, this.smashGround2Animation, this.smashGround3Animation, this.pouncePreAnimation, this.pounceHoldAnimation, this.pounceEndAnimation, this.pounceSmashAnimation, this.pouncePickAnimation, this.attractAnimation, this.shoryukenAnimation, this.trackingShurikenAnimation, this.unleashEnergyAnimation, this.hurt1Animation};
    private static final EntityDataAccessor<Byte> DATA_STAGE = SynchedEntityData.m_135353_(EntityImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> DATA_TELEPORT_TYPE = SynchedEntityData.m_135353_(EntityImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DATA_KATANA_HOLD = SynchedEntityData.m_135353_(EntityImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_ALWAYS_ACTIVE = SynchedEntityData.m_135353_(EntityImmortal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID HEALTH_UUID = UUID.fromString("E2F534E6-4A55-4B72-A9D2-3157D084A281");
    private static final UUID ARMOR_UUID = UUID.fromString("FA2FB8E8-FFE8-4D77-B23B-E0110D4A175F");
    private static final UUID ATTACK_UUID = UUID.fromString("F8DBD65D-3C4A-4851-83D3-4CB22964A196");
    private int hurtCount;
    private int timeUntilAttract;
    private int timeUntilBlock;
    private int blockingHurtCount;
    private int timeUntilPounce;
    private int timeUntilSmash;
    private int timeUntilShoryuken;
    private int timeUntilShuriken;
    private int timeUntilTeleport;
    private int timeUntilLaser;
    private int battleTimestamp;
    private int destroyBlocksTick;
    private int closeProximityTickCount;
    private int universalCDTime;
    private int immortalInvulnerableTime;
    private final DamageAdaptation damageAdaptation;
    private final TickBasedProbabilityBooster smashDerivedSkillProb;
    public List<LivingEntity> targets = List.of();
    public final ControlledAnimation coreControllerAnimation = new ControlledAnimation(10);
    public final ControlledAnimation glowControllerAnimation = new ControlledAnimation(20);
    public final ControlledAnimation alphaControllerAnimation = new ControlledAnimation(10);
    public final ControlledAnimation hurtControllerAnimation = new ControlledAnimation(10);
    @OnlyIn(value=Dist.CLIENT)
    public Vec3[] hand;
    public boolean canInterruptsAnimation;
    private boolean LRFlag;
    private Vec3 lPreHandPos = Vec3.f_82478_;
    private Vec3 rPreHandPos = Vec3.f_82478_;
    private static final int TIME_UNTIL_ATTACK = 5;
    private static final int TIME_UNTIL_TELEPORT = 200;
    private static final int MAX_BLOCK_HURT_COUNT = 3;
    private static final float MAX_COUNTERATTACK_DAMAGE_AMOUNT_THRESHOLD = 30.0f;
    private static final UniformInt SMASH_TIME = TimeUtil.m_145020_((int)10, (int)15);
    private static final UniformInt POUNCE_TIME = TimeUtil.m_145020_((int)12, (int)18);
    private static final UniformInt ATTRACT_TIME = TimeUtil.m_145020_((int)15, (int)20);
    private static final UniformInt SHURIKEN_TIME = TimeUtil.m_145020_((int)15, (int)25);
    private static final UniformInt LASER_TIME = TimeUtil.m_145020_((int)20, (int)30);
    private static final Predicate<LivingEntity> TARGET_CONDITIONS = entity -> {
        Player player;
        return entity.m_6084_() && entity.m_6336_() != ModMobType.IMMORTAL && !entity.m_6095_().m_204039_(EMTagKey.IMMORTAL_IGNORE_HUNT_TARGETS) && entity.m_6097_() && (entity instanceof Enemy || entity instanceof NeutralMob || entity instanceof Player && !(player = (Player)entity).m_7500_() && !player.m_5833_());
    };
    private static final float[][] BLOCK_OFFSETS = new float[][]{{-0.75f, -0.75f}, {-0.75f, 0.75f}, {0.75f, 0.75f}, {0.75f, -0.75f}};
    private static final ParticleComponent[] ATTRACT_COMPONENT = new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.RED, AnimData.startAndEnd(0.3f, 0.56f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.GREEN, AnimData.startAndEnd(0.388f, 0.85f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.BLUE, AnimData.startAndEnd(0.55f, 0.98f), false)};

    public EntityImmortal(EntityType<? extends EntityAbsImmortal> type, Level level) {
        super(type, level);
        this.active = false;
        this.m_21441_(BlockPathTypes.LAVA, 0.0f);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_OTHER, 8.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, 8.0f);
        this.m_21441_(BlockPathTypes.DAMAGE_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.DANGER_FIRE, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.smashDerivedSkillProb = new TickBasedProbabilityBooster(0.1f, 0.1f, 0.9f);
        this.damageAdaptation = new DamageAdaptation(EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.adaptConfig);
        if (this.f_19853_.f_46443_) {
            this.hand = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, 0.0, 0.0)};
        }
    }

    @Override
    protected XpReward getEntityReward() {
        return XpReward.XP_REWARD_EPIC_BOSS;
    }

    public float getStepHeight() {
        return 2.5f;
    }

    public boolean m_203441_(FluidState fluidState) {
        return fluidState.m_205070_(FluidTags.f_13132_);
    }

    @Override
    public boolean m_142535_(float fallDistance, float multiplier, DamageSource damageSource) {
        return false;
    }

    @Override
    public boolean m_147207_(MobEffectInstance effectInstance, @org.jetbrains.annotations.Nullable Entity entity) {
        if (!ModEntityUtils.isBeneficial(effectInstance.m_19544_())) {
            this.reflectPotionEffect(effectInstance, entity);
            return false;
        }
        return this.isActive() && super.m_147207_(effectInstance, entity);
    }

    public void m_147215_(MobEffectInstance effectInstance, @org.jetbrains.annotations.Nullable Entity entity) {
        if (!ModEntityUtils.isBeneficial(effectInstance.m_19544_())) {
            this.reflectPotionEffect(effectInstance, entity);
            return;
        }
        if (this.isActive()) {
            super.m_147215_(effectInstance, entity);
        }
    }

    public boolean m_7301_(MobEffectInstance effectInstance) {
        return this.isActive() && ModEntityUtils.isBeneficial(effectInstance.m_19544_()) && super.m_7301_(effectInstance);
    }

    @Override
    public boolean m_6051_() {
        return false;
    }

    @Override
    protected boolean canBePushedByEntity(Entity entity) {
        return false;
    }

    @Override
    public boolean m_6063_() {
        return false;
    }

    public void m_7601_(BlockState state, Vec3 motionMultiplier) {
    }

    @Override
    protected boolean m_8028_() {
        return false;
    }

    protected boolean m_7341_(Entity vehicle) {
        return false;
    }

    public boolean m_21224_() {
        return super.m_21224_();
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new EMBodyRotationControl((Mob)this);
    }

    @NotNull
    protected PathNavigation m_6037_(Level level) {
        return new EMPathNavigateGround(this, level);
    }

    public Map<MobEffect, MobEffectInstance> m_21221_() {
        if (EMStackTraceUtils.isNotMinecraftOrMyModInvoking()) {
            return Map.of();
        }
        return super.m_21221_();
    }

    public boolean m_21219_() {
        if (EMStackTraceUtils.isNotMinecraftOrMyModInvoking()) {
            return false;
        }
        return super.m_21219_();
    }

    public void m_6074_() {
        if (EMStackTraceUtils.isNotMinecraftOrMyModInvoking()) {
            return;
        }
        super.m_6074_();
    }

    @Override
    public boolean m_6673_(DamageSource damageSource) {
        Animation animation = this.getAnimation();
        return this.immortalInvulnerableTime > 0 || !this.isActive() || animation == this.switchStageAnimation || animation == this.teleportAnimation || animation == this.pounceHoldAnimation || animation == this.armBlockCounterattackAnimation || animation == this.smashGround3Animation || super.m_6673_(damageSource);
    }

    public boolean m_20145_() {
        return !this.alphaControllerAnimation.isStop() || super.m_20145_();
    }

    protected boolean m_6129_() {
        return false;
    }

    public boolean canDrownInFluidType(FluidType type) {
        return false;
    }

    public void m_5634_(float healAmount) {
        MinecraftForge.EVENT_BUS.post((Event)new LivingHealEvent((LivingEntity)this, healAmount));
        if (healAmount <= 0.0f) {
            return;
        }
        float f = this.m_21223_();
        if (f > 0.0f) {
            this.m_21153_(f + healAmount);
        }
    }

    @Override
    protected EMConfigHandler.AttributeConfig getAttributeConfig() {
        return EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.combatConfig;
    }

    @Override
    protected boolean showBossBloodBars() {
        return (Boolean)EMConfigHandler.COMMON.OTHER.enableShowBloodBars.get();
    }

    @Override
    protected boolean intervalProtect() {
        return (Boolean)EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.intervalProtect.get();
    }

    @Override
    protected BossEvent.BossBarColor bossBloodBarsColor() {
        return BossEvent.BossBarColor.RED;
    }

    @Override
    protected boolean setDarkenScreen() {
        return this.getAnimation() == this.unleashEnergyAnimation;
    }

    @Override
    protected void onAnimationStart(Animation animation) {
        if (!this.f_19853_.f_46443_) {
            if (animation == this.armBlockCounterattackAnimation) {
                this.blockingHurtCount = 0;
            } else if (animation == this.attractAnimation || animation == this.shoryukenAnimation) {
                if (!this.LRFlag) {
                    this.LRFlag = true;
                }
            } else if (animation == this.unleashEnergyAnimation) {
                this.timeUntilLaser = this.getCoolingTimerUtil(LASER_TIME.m_214085_(this.f_19796_), 10.0f);
            }
        }
    }

    @Override
    protected void onAnimationFinish(Animation animation) {
        if (!this.f_19853_.f_46443_) {
            if (this.isSwitching()) {
                this.m_21153_(this.m_21233_());
            }
            if (animation == this.armBlockEndAnimation) {
                this.blockingHurtCount = 0;
                this.blockEntity = null;
            } else if (animation == this.smashGround3Animation) {
                this.blockEntity = null;
                this.universalCDTime = this.f_19796_.m_188503_(5) + 1;
            } else if (animation == this.unleashEnergyAnimation) {
                if (this.m_5448_() != null && this.targetDistance >= 8.0f) {
                    this.universalCDTime = 20;
                }
            } else if (animation == this.trackingShurikenAnimation) {
                if (this.m_5448_() instanceof Player && this.targets.size() < 2) {
                    this.universalCDTime = 20 + this.f_19796_.m_188503_(10);
                }
            } else if (animation == this.hurt1Animation) {
                this.blockEntity = null;
            }
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{EntityAbsImmortal.class}));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, TARGET_CONDITIONS));
        this.f_21345_.m_25352_(6, (Goal)new WaterAvoidingRandomStrollGoal(this, 0.7){

            public boolean m_8036_() {
                return EntityImmortal.this.isActive() && super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new EMLookAtGoal(this, Mob.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this){

            public boolean m_8036_() {
                return super.m_8036_() && EntityImmortal.this.isActive();
            }
        });
        this.registerCustomGoals();
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(0, (Goal)new ImmortalGroupAI(this, () -> this.switchStageAnimation, () -> this.teleportAnimation, () -> this.spawnAnimation));
        this.f_21345_.m_25352_(1, (Goal)new ImmortalAttractGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ImmortalBlockGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ImmortalComboGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ImmortalMagicGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ImmortalPounceGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new ImmortalShakeGroundGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new ImmortalStunGoal(this));
        this.f_21345_.m_25352_(2, new AnimationDie<EntityImmortal>(this));
        this.f_21345_.m_25352_(2, (Goal)new AnimationMeleePlusAI<EntityImmortal>(this, 1.05, 0, new Supplier[0]){

            @Override
            public void m_8037_() {
                if (((EntityImmortal)this.attacker).universalCDTime > 0) {
                    LivingEntity target = ((EntityImmortal)this.attacker).m_5448_();
                    if (target != null) {
                        ((EntityImmortal)this.attacker).m_21563_().m_148051_((Entity)target);
                    }
                    ((EntityImmortal)this.attacker).m_21573_().m_26573_();
                } else {
                    super.m_8037_();
                }
            }
        });
    }

    @Override
    public void m_8119_() {
        this.m_146922_(this.f_20883_);
        super.m_8119_();
        this.floatImmortal();
        this.alphaControllerAnimation.updatePrevTimer();
        this.glowControllerAnimation.updatePrevTimer();
        this.coreControllerAnimation.updatePrevTimer();
        this.hurtControllerAnimation.updatePrevTimer();
        int tick = this.getAnimationTick();
        Animation animation = this.getAnimation();
        if (this.isNoAnimation() || animation != this.teleportAnimation && animation != this.pounceHoldAnimation && animation != this.shoryukenAnimation && animation != this.smashGround2Animation && animation == this.attractAnimation && tick < 40) {
            this.pushEntitiesAway(1.9f, this.m_20206_(), 1.9f, 1.9f);
        }
        if (!this.isActive()) {
            this.m_20334_(0.0, this.m_20184_().f_82480_, 0.0);
        }
        if (animation == this.spawnAnimation) {
            this.setActive(true);
        } else if (animation == this.punchRightAnimation || animation == this.punchLeftAnimation) {
            boolean right = animation == this.punchRightAnimation;
            this.doSwipeEffect(tick == 11, tick > 11 && tick <= 15, !right);
            if (tick == 12) {
                this.doPuncturedAirFlowEffect(right);
            }
        } else if (animation == this.hardPunchRightAnimation || animation == this.hardPunchLeftAnimation) {
            boolean right = animation == this.hardPunchRightAnimation;
            this.doSwipeEffect(tick == 19, tick > 19 && tick < 24, !right);
            if (tick == 20 || tick == 22) {
                this.doPuncturedAirFlowEffect(right);
            }
        } else if (animation == this.armBlockCounterattackAnimation) {
            if (tick == 2) {
                this.doShakeGroundEffect(15, 0.0f, 0.0f, 0.5f, 0.94f, false, false);
                this.doCollisionEffect(0, 30.0f, 0.5f);
            }
            if (tick == 3) {
                this.shakeGround(0.0f, 20.0f, 0.2f, 3, 0);
            }
            if (tick == 12) {
                this.doImmortalMagicMatrixEffect(EntityImmortalMagicCircle.MagicCircleType.POWER, 7, 1.5f, 0.5f, 9.0f);
            }
        } else if (animation == this.smashGround1Animation) {
            this.doSwipeEffect(tick == 17, tick > 17 && tick <= 21, null);
            if (tick == 20) {
                this.doShakeGroundEffect(12, 2.5f, 0.0f, 0.58f, 0.94f, false, true);
            }
        } else if (animation == this.smashGround2Animation) {
            this.doSwipeEffect(tick == 13, tick > 13 && tick <= 17, null);
            if (tick == 16) {
                this.doShakeGroundEffect(14, 2.5f, 0.0f, 0.55f, 0.95f, false, true);
            }
        } else if (animation == this.smashGround3Animation) {
            this.doSwipeEffect(tick == 10, tick > 10 && tick <= 20, null);
            if (tick == 19) {
                float width = this.m_20205_() / 2.0f;
                this.doShakeGroundEffect(10, 2.4f, width, 0.5f, 0.94f, false, true);
                this.doShakeGroundEffect(10, 2.4f, width, 0.5f, 0.94f, true, true);
            }
        } else if (animation == this.pouncePreAnimation) {
            if (tick == 5) {
                this.doImmortalMagicMatrixEffect(EntityImmortalMagicCircle.MagicCircleType.SPEED, 5, 2.5f, 0.4f, 8.0f);
            }
        } else if (animation == this.pounceSmashAnimation) {
            this.doSwipeEffect(tick == 8, tick > 8 && tick <= 11, true);
            if (tick == 10) {
                this.doShakeGroundEffect(15, 3.7f, 0.0f, 0.58f, 0.92f, false, true);
            }
        } else if (animation == this.pounceHoldAnimation) {
            if (tick == 1) {
                if (!this.m_20067_()) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.IMMORTAL_SUBSONIC.get(), this.m_5720_(), 0.4f, 1.5f, false);
                }
                this.doHitEffect(10, this.f_19796_.m_188503_(10), 60.0f, 0.0f, 0.55f, true);
                ParticleDust.DustData particle = new ParticleDust.DustData((ParticleType<ParticleDust.DustData>)((ParticleType)ParticleInit.DUST.get()), 0.28f, 0.26f, 0.24f, 50.0f, 16, ParticleDust.EnumDustBehavior.SHRINK, 1.0f);
                ModParticleUtils.roundParticleOutburst(this.f_19853_, 10.0, new ParticleOptions[]{particle}, this.m_20185_(), this.m_20227_(0.25), this.m_20189_(), 1.0f);
                for (LivingEntity hit : this.getNearByLivingEntities(5.0)) {
                    double angle = this.getAngleBetweenEntities((Entity)this, (Entity)hit);
                    double x = Math.cos(Math.toRadians(angle - 90.0));
                    double z = Math.sin(Math.toRadians(angle - 90.0));
                    hit.m_20334_(x, 0.25, z);
                    if (!(hit instanceof ServerPlayer)) continue;
                    ServerPlayer serverPlayer = (ServerPlayer)hit;
                    serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)hit));
                }
            } else if (this.f_19853_.f_46443_ && this.m_20184_().m_165925_() > 0.1) {
                ModParticleUtils.generateParticleEffects(this.f_19853_, this.m_20185_(), this.m_20186_() - 0.1, this.m_20189_(), Math.toRadians(this.m_146908_()), 10, BLOCK_OFFSETS, pos -> this.f_19853_.m_8055_(pos), 5.0);
            }
        } else if (animation != this.switchStageAnimation) {
            if (animation == this.attractAnimation) {
                this.doAttractEffect();
                if (tick == 32) {
                    this.doImmortalMagicMatrixEffect(EntityImmortalMagicCircle.MagicCircleType.POWER, 5, 1.5f, 0.45f, 9.0f);
                }
                this.doSwipeEffect(tick == 35, tick > 35 && tick <= 42, false);
            } else if (animation == this.shoryukenAnimation) {
                this.doSwipeEffect(tick == 14, tick > 14 && tick < 20, false);
                this.doSwipeEffect(tick == 44, tick > 44 && tick <= 48, true);
                if (tick == 47) {
                    this.doShakeGroundEffect(12, 4.75f, 0.0f, 0.58f, 0.92f, false, true);
                }
            } else if (animation == this.trackingShurikenAnimation) {
                if (tick == 8) {
                    this.doImmortalMagicMatrixEffect(EntityImmortalMagicCircle.MagicCircleType.HARMFUL, 12, 2.0f, 0.5f, 15.0f);
                }
            } else if (animation == this.unleashEnergyAnimation) {
                if (tick == 1 && !this.m_20067_()) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.IMMORTAL_ACCUMULATING.get(), this.m_5720_(), 1.5f, 1.0f, false);
                }
                if (tick >= 30 && tick < 80) {
                    if (tick > 35) {
                        this.strongKnockBlock();
                    }
                    this.doUnleashEnergyEffect();
                } else if (tick == 80 && !this.m_20067_()) {
                    this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.IMMORTAL_ACCUMULATING_END.get(), this.m_5720_(), 1.5f, 1.0f, false);
                }
            } else if (animation == this.hurt1Animation && tick == 15) {
                this.doShakeGroundEffect(10, 1.0f, this.m_20205_() * 0.6f, 0.55f, 0.91f, true, true);
            }
        }
        this.f_19859_ = this.m_146908_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (!this.f_19853_.f_46443_) {
            boolean canAttack;
            LivingEntity target = this.m_5448_();
            if (target != null && !target.m_6084_()) {
                this.m_6710_(null);
            }
            if (this.isSwitching()) {
                this.m_5634_(this.m_21233_() / (float)this.switchStageAnimation.getDuration());
            }
            boolean bl = canAttack = !this.m_21525_() && target != null && !this.isSwitching() && this.universalCDTime <= 0;
            if (canAttack && ImmortalStage.STAGE1 == this.getStage()) {
                this.targetDistance = this.m_20270_((Entity)target) - target.m_20205_() / 2.0f;
                boolean hasTargetLineOfSight = this.m_21574_().m_148306_((Entity)target);
                boolean targetFacingAway = ModEntityUtils.isTargetFacingAway((Entity)this, (Entity)target, 180.0);
                boolean targetComingCloser = ModEntityUtils.checkTargetComingCloser((LivingEntity)this, target);
                double targetRelativeHeight = Math.abs(this.m_20186_() - target.m_20186_());
                float targetRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, target);
                if (this.battleTimestamp == 0) {
                    this.battleTimestamp = this.f_19797_;
                }
                if (this.timeUntilTeleport <= 0 && (this.isNoAnimation() || this.canInterruptsAnimation) && (this.hurtCount > 30 || this.closeProximityTickCount >= 400 && this.f_19796_.m_188501_() < 0.3f)) {
                    this.hurtCount = 0;
                    this.closeProximityTickCount = 0;
                    this.canInterruptsAnimation = false;
                    this.setTeleportType(targetFacingAway ? TeleportType.FRONT : (this.timeUntilPounce <= 0 || this.f_19796_.m_188501_() < 0.4f ? TeleportType.SNEAK : TeleportType.BEHIND));
                    this.playAnimation(this.teleportAnimation);
                    this.timeUntilTeleport = this.getCoolingTimerUtil(200, 5.0f);
                } else if (this.timeUntilLaser <= 0 && (this.getCumulativeBattleTick() > 2400 || this.getHealthPercentage() < 60.0f) && this.isNoAnimation() && targetRelativeHeight < 10.0 && this.targetDistance >= 12.0f && (double)this.targetDistance < 32.0) {
                    this.playAnimation(this.unleashEnergyAnimation);
                } else if (this.timeUntilShuriken <= 0 && (this.getCumulativeBattleTick() > 1800 || this.getHealthPercentage() < 70.0f) && (this.isNoAnimation() || this.canInterruptsAnimation) && this.targetDistance < 32.0f && (this.targetDistance > 5.0f || this.targets.size() >= 3)) {
                    this.canInterruptsAnimation = false;
                    this.playAnimation(this.trackingShurikenAnimation);
                    this.timeUntilShuriken = this.getCoolingTimerUtil(SHURIKEN_TIME.m_214085_(this.f_19796_), 8.0f);
                } else if (this.timeUntilPounce <= 0 && (this.isNoAnimation() || this.canInterruptsAnimation) && hasTargetLineOfSight && targetRelativeHeight < 6.0 && this.targetDistance > 12.0f && this.targetDistance < 32.0f && this.f_19796_.m_188501_() < 0.5f) {
                    this.canInterruptsAnimation = false;
                    this.playAnimation(this.pouncePreAnimation);
                    this.timeUntilPounce = this.getCoolingTimerUtil(POUNCE_TIME.m_214085_(this.f_19796_), 5.0f);
                } else if (this.timeUntilShoryuken <= 0 && (this.isNoAnimation() || this.canInterruptsAnimation) && hasTargetLineOfSight && (!this.LRFlag || this.f_19796_.m_188503_(10) == 0) && targetRelativeHeight < 5.0 && (double)this.targetDistance > 4.5 && this.targetDistance < 9.0f && targetRelativeAngle <= 30.0f && targetRelativeAngle >= -30.0f) {
                    this.canInterruptsAnimation = false;
                    this.playAnimation(this.shoryukenAnimation);
                    this.smashDerivedSkillProb.onTick();
                    this.timeUntilShoryuken = this.getCoolingTimerUtil(POUNCE_TIME.m_214085_(this.f_19796_), 3.0f);
                } else if (this.timeUntilSmash <= 0 && (this.getCumulativeBattleTick() > 1600 || this.getHealthPercentage() < 80.0f) && (this.isNoAnimation() || this.canInterruptsAnimation && this.getHealthPercentage() <= 50.0f) && this.m_20096_() && targetRelativeHeight < 6.0 && ((double)this.targetDistance < 6.5 || targetComingCloser && (double)this.targetDistance < 7.5) && this.f_19796_.m_188501_() < this.smashDerivedSkillProb.getProbability()) {
                    this.canInterruptsAnimation = false;
                    this.smashDerivedSkillProb.resetProbability();
                    this.playAnimation(this.smashGround2Animation);
                    this.timeUntilSmash = this.getCoolingTimerUtil((int)((double)SMASH_TIME.m_214085_(this.f_19796_) * 1.5), 5.0f);
                } else if (this.timeUntilAttract <= 0 && (this.getCumulativeBattleTick() > 1600 || this.getHealthPercentage() < 85.0f) && (this.isNoAnimation() || this.canInterruptsAnimation) && (!this.LRFlag || this.f_19796_.m_188503_(10) == 0) && targetRelativeHeight < 6.0 && (double)this.targetDistance >= 4.5 && this.targetDistance < 8.0f && (targetFacingAway || this.f_19796_.m_188501_() < 0.15f)) {
                    this.canInterruptsAnimation = false;
                    this.playAnimation(this.attractAnimation);
                    this.timeUntilAttract = this.getCoolingTimerUtil(ATTRACT_TIME.m_214085_(this.f_19796_), 5.0f);
                } else if (this.timeUntilSmash <= 0 && this.canInterruptsAnimation && (this.getCumulativeBattleTick() > 1200 || this.getHealthPercentage() < 90.0f) && targetRelativeHeight <= 5.0 && (double)this.targetDistance < 5.5 && this.f_19796_.m_188501_() < 1.0f - this.smashDerivedSkillProb.getProbability()) {
                    this.canInterruptsAnimation = false;
                    this.playAnimation(this.smashGround1Animation);
                    this.smashDerivedSkillProb.onTick();
                    this.timeUntilSmash = this.getCoolingTimerUtil(SMASH_TIME.m_214085_(this.f_19796_), 5.0f);
                } else if (this.attackTick <= 0 && this.isNoAnimation() && this.targetDistance <= 5.0f && this.f_19796_.m_188501_() < 0.65f) {
                    this.playAnimation(this.getBaseAttackByStage());
                    this.attackTick = 5;
                }
                if (this.targetDistance <= 5.0f) {
                    ++this.closeProximityTickCount;
                    if (this.getCumulativeBattleTick() > 3600 || this.getHealthPercentage() < 50.0f) {
                        ++this.closeProximityTickCount;
                    }
                } else if (this.f_19797_ % 2 == 0 && this.closeProximityTickCount > 0) {
                    --this.closeProximityTickCount;
                }
            }
            if (target == null && this.f_19797_ % 100 == 0 && this.battleTimestamp > 0) {
                this.battleTimestamp = (int)((double)this.battleTimestamp * 0.5);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.universalCDTime > 0) {
                --this.universalCDTime;
            }
            if (this.isNoAnimation() && this.attackTick > 0) {
                --this.attackTick;
            }
            if (!this.inBlocking() && this.timeUntilBlock > 0) {
                --this.timeUntilBlock;
            }
            if (this.timeUntilSmash > 0) {
                --this.timeUntilSmash;
            }
            if (this.timeUntilAttract > 0) {
                --this.timeUntilAttract;
            }
            if (this.timeUntilPounce > 0) {
                --this.timeUntilPounce;
            }
            if (this.timeUntilShoryuken > 0) {
                --this.timeUntilShoryuken;
            }
            if (this.timeUntilShuriken > 0) {
                --this.timeUntilShuriken;
            }
            if (this.timeUntilTeleport > 0) {
                --this.timeUntilTeleport;
            }
            if (this.timeUntilLaser > 0) {
                --this.timeUntilLaser;
            }
            if (!this.inBlocking() && this.f_19797_ % 20 == 0 && this.f_20916_ <= 0) {
                this.hurtCount = 0;
            }
            if (this.immortalInvulnerableTime > 0) {
                --this.immortalInvulnerableTime;
            }
            if (!this.m_21525_() && this.destroyBlocksTick > 0) {
                --this.destroyBlocksTick;
                if (this.destroyBlocksTick == 0 && ModEntityUtils.canMobDestroy((Entity)this)) {
                    ModEntityUtils.advancedBreakBlocks(this.f_19853_, (LivingEntity)this, 50.0f, 2, 5, 2, 0, 0.0f, this.checkCanDropItems(), true);
                }
            }
            if (!this.m_21525_() && this.f_19797_ % 30 == 0 && this.m_5448_() != null) {
                this.targets = this.f_19853_.m_6443_(LivingEntity.class, this.m_20191_().m_82377_(32.0, 6.0, 32.0), e -> this.m_5448_() == e || TARGET_CONDITIONS.test((LivingEntity)e));
            }
        }
        int tick = this.getAnimationTick();
        Animation animation = this.getAnimation();
        this.hurtControllerAnimation.decreaseTimer();
        this.glowControllerAnimation.incrementOrDecreaseTimer(this.isActive() && !this.m_21224_() && (animation != this.spawnAnimation || tick > 25));
        this.coreControllerAnimation.incrementOrDecreaseTimer(!this.isNoAnimation() && animation != this.spawnAnimation && animation != this.unleashEnergyAnimation && !this.inBlocking());
        this.alphaControllerAnimation.incrementOrDecreaseTimer(animation == this.teleportAnimation && tick >= 10 && tick <= 20, 2);
        if (animation == this.teleportAnimation) {
            LivingEntity target = this.m_5448_();
            if (tick == 15) {
                int i;
                boolean teleportFlag = target != null;
                for (i = 0; i < 16; ++i) {
                    if (!this.teleportByType(this.getTeleportType(), target)) continue;
                    teleportFlag = false;
                    break;
                }
                if (teleportFlag) {
                    for (i = 0; i < 16 && !this.teleportByType(TeleportType.SNEAK, target); ++i) {
                    }
                }
            }
        }
    }

    @Override
    public void m_21153_(float health) {
        if (health < this.m_21223_()) {
            float nowHealth = this.m_21223_();
            float damage = nowHealth - this.getNewHealthByCap(health, EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.maximumDamageCap);
            health = nowHealth - this.damageAdaptation.damageAfterAdaptingOnce((LivingEntity)this, this.f_20958_, damage);
            if (this.isSwitching() || this.immortalInvulnerableTime > 0) {
                return;
            }
            this.immortalInvulnerableTime = 2;
            if (this.damageAdaptation.isFullyAdapted((LivingEntity)this, this.f_20958_)) {
                this.f_19853_.m_7605_((Entity)this, (byte)4);
            }
        }
        super.m_21153_(health);
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        if (!this.f_19853_.f_46443_) {
            Mob mob;
            Entity entity = source.m_7639_();
            if (entity instanceof Mob && (mob = (Mob)entity).m_6336_() == ModMobType.IMMORTAL) {
                return false;
            }
            ++this.hurtCount;
            this.f_20958_ = source;
            byte pierceLevel = 0;
            Entity entity2 = source.m_7640_();
            if (entity2 instanceof AbstractArrow) {
                AbstractArrow arrow = (AbstractArrow)entity2;
                pierceLevel = arrow.m_36796_();
            }
            if (entity != null) {
                boolean inBack;
                boolean inUnleash;
                boolean bl = inUnleash = this.getAnimation() == this.unleashEnergyAnimation;
                if ((inUnleash || ModEntityUtils.isProjectileSource(source) || !ModEntityUtils.checkDirectEntityConsistency(source)) && (double)this.m_20270_(entity) >= (Double)EMConfigHandler.COMMON.MOB.IMMORTAL.THE_IMMORTAL.maxDistanceTakeDamage.get()) {
                    return false;
                }
                float attackArc = 100.0f;
                float relativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, entity.m_20182_());
                boolean inFront = relativeAngle <= attackArc / 1.5f && relativeAngle >= -attackArc / 1.5f;
                boolean bl2 = inBack = relativeAngle <= -180.0f + attackArc / 2.0f && relativeAngle >= -180.0f - attackArc / 2.0f || relativeAngle >= 180.0f - attackArc / 2.0f && relativeAngle <= 180.0f + attackArc / 2.0f;
                if (inUnleash || !source.m_19376_() && pierceLevel <= 0 && !inFront && !inBack) {
                    damage *= 0.5f;
                }
                if (!this.m_21525_() && this.timeUntilBlock <= 0 && !source.m_19378_() && (damage > 1.0f && inFront && (this.isNoAnimation() || this.canInterruptsAnimation) || this.inBlocking())) {
                    this.canInterruptsAnimation = false;
                    if (entity instanceof LivingEntity) {
                        LivingEntity living;
                        this.blockEntity = living = (LivingEntity)entity;
                    }
                    float pitch = 0.4f * EMMathUtils.getTickFactor(damage, 3.0f, false);
                    if (damage > 30.0f || ++this.blockingHurtCount >= 3) {
                        this.timeUntilBlock = 100 + (int)Math.min(damage * 3.3333f, 100.0f);
                        this.m_5496_((SoundEvent)SoundInit.IMMORTAL_BLOCKING_COUNTER.get(), 1.5f, 1.3f - pitch);
                        this.playAnimation(this.armBlockCounterattackAnimation);
                        return false;
                    }
                    if (this.isNoAnimation()) {
                        this.playAnimation(this.armBlockAnimation);
                    } else {
                        this.playAnimation(this.armBlockHoldAnimation);
                    }
                    this.m_5496_((SoundEvent)SoundInit.IMMORTAL_BLOCKING.get(), 0.9f, this.m_6100_() + pitch - 0.2f);
                    this.f_19853_.m_7605_((Entity)this, (byte)5);
                    this.f_19802_ /= 2;
                    super.m_6469_(source, damage * 0.1f);
                    return false;
                }
            }
            damage *= 1.0f - Mth.m_14036_((float)((float)(this.targets.size() - 1) * 4.0f), (float)0.0f, (float)20.0f) / 100.0f;
            if (entity != null || source == DamageSource.f_19317_ || source == DamageSource.f_19318_) {
                boolean flag = super.m_6469_(source, damage);
                if (flag) {
                    this.stunCheck(source, damage);
                }
                return flag;
            }
            if (this.destroyBlocksTick <= 0) {
                this.destroyBlocksTick = 20;
            }
        } else if (this.inBlocking()) {
            this.f_20916_ = 0;
        }
        return false;
    }

    @Override
    public void m_7822_(byte id) {
        if (id == 4) {
            this.hurtControllerAnimation.setTimer(10);
        } else if (id == 5) {
            this.doCollisionEffect(6, 15.0f, 0.3f);
        } else if (id == 6) {
            this.doHitEffect(5, 0.0f, 15.0f, 4.9f, 0.45f, false);
        } else if (id == 7) {
            this.doHitEffect(4, 0.0f, 17.0f, 4.5f, 0.5f, true);
        } else if (id == 8) {
            this.doHitEffect(5, -20.0f, 20.0f, 3.0f, 0.6f, false);
        } else if (id == 9) {
            this.doAttractHitEffect();
        } else if (id == 10) {
            this.doHitEffect(5, 0.0f, 20.0f, 4.8f, 0.4f, true);
        } else if (id == 11) {
            Vec3 pos = this.getPosOffset(true, 1.5f, this.m_20205_() * 0.6f, this.m_20206_() * 0.25f);
            ModParticleUtils.roundParticleOutburst(this.f_19853_, 50.0, new ParticleOptions[]{new ParticleOrb.OrbData(0.46f, 0.75f, 0.88f, 3.0f, 30)}, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.8f);
        } else {
            super.m_7822_(id);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_STAGE, (Object)ImmortalStage.STAGE1.id);
        this.f_19804_.m_135372_(DATA_TELEPORT_TYPE, (Object)TeleportType.RANDOM.id);
        this.f_19804_.m_135372_(DATA_KATANA_HOLD, (Object)ImmortalStage.STAGE1.holdKatana);
        this.f_19804_.m_135372_(DATA_ALWAYS_ACTIVE, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.isSwitching()) {
            this.setHoldKatana(this.getStage().holdKatana);
            this.m_21153_(this.m_21233_());
        }
        compound.m_128344_("bossStage", this.getStage().id);
        compound.m_128379_("isActive", this.isActive());
        compound.m_128379_("holdKatana", this.isHoldKatana());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_STAGE, (Object)compound.m_128445_("bossStage"));
        this.setActive(compound.m_128471_("isActive"));
        this.setHoldKatana(compound.m_128471_("holdKatana"));
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(Items.f_41852_)) {
            return InteractionResult.PASS;
        }
        if (this.isActive() || this.m_21525_()) {
            return InteractionResult.PASS;
        }
        if (itemStack.m_150930_((Item)ItemInit.GUARDIAN_CORE.get())) {
            if (!player.m_150110_().f_35937_) {
                itemStack.m_41774_(1);
            }
            this.playAnimation(this.spawnAnimation);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @org.jetbrains.annotations.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        return spawnDataIn;
    }

    public boolean m_214076_(ServerLevel level, LivingEntity entity) {
        float maxHealth = this.m_21233_();
        this.m_5634_(Math.min(entity.m_21233_() * 0.05f + maxHealth * 0.01f, maxHealth * 0.05f));
        return super.m_214076_(level, entity);
    }

    private void stunCheck(DamageSource source, float damage) {
        if (this.getAnimation() == this.attractAnimation && this.getAnimationTick() < 50 && damage >= 5.0f && source.m_19372_() && !this.damageAdaptation.isFullyAdapted((LivingEntity)this, source)) {
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity;
                this.blockEntity = livingEntity = (LivingEntity)entity;
            }
            if (!this.f_19853_.f_46443_) {
                this.f_19853_.m_7605_((Entity)this, (byte)11);
            }
            this.canInterruptsAnimation = false;
            this.playAnimation(this.hurt1Animation);
        }
    }

    public int getCumulativeBattleTick() {
        if (this.battleTimestamp > 0 && this.battleTimestamp < this.f_19797_) {
            return this.f_19797_ - this.battleTimestamp;
        }
        return 0;
    }

    public boolean checkComboRange(double range, double checkRange) {
        LivingEntity target = this.m_5448_();
        if (target == null) {
            return true;
        }
        if (target.m_6084_()) {
            boolean targetComingCloser = ModEntityUtils.checkTargetComingCloser((LivingEntity)this, target);
            return (double)this.targetDistance < range || (double)this.targetDistance < range + checkRange && targetComingCloser;
        }
        return false;
    }

    public boolean doHurtTarget(LivingEntity target, boolean disableShield, boolean addEffect, boolean critHeal, boolean ignoreArmor, float hitEntityMaxHealth, float baseDamageMultiplier, float damageMultiplier) {
        return this.doHurtTarget(EMDamageSource.immortalAttack((Entity)this, critHeal && target.m_21133_((Attribute)AttributeInit.CRIT_CHANCE.get()) > 1.0, ignoreArmor), target, disableShield, addEffect, ignoreArmor, hitEntityMaxHealth, baseDamageMultiplier, damageMultiplier);
    }

    public boolean doHurtTarget(DamageSource source, LivingEntity target, boolean disableShield, boolean addEffect, boolean ignoreArmor, float hitEntityMaxHealth, float baseDamageMultiplier, float damageMultiplier) {
        double baseATK = this.m_21133_(Attributes.f_22281_);
        boolean flag = target.m_6469_(source, (float)((baseATK += (double)Mth.m_14036_((float)((float)(this.targets.size() - 1) * 0.4f), (float)0.0f, (float)2.0f)) * (double)baseDamageMultiplier + (double)(target.m_21233_() * hitEntityMaxHealth)) * damageMultiplier);
        if (flag && addEffect) {
            ModEntityUtils.addEffectStackingAmplifier((Entity)this, target, (MobEffect)EffectInit.ERODE_EFFECT.get(), 300, 5, true, true, true, true, false);
        } else if (disableShield) {
            Difficulty difficulty = this.f_19853_.m_46791_();
            this.disableShield(target, Difficulty.HARD == difficulty ? 110 : 100);
        }
        return flag;
    }

    public void disableShield(LivingEntity defender, int cd) {
        if (defender.m_21254_()) {
            if (defender instanceof Player) {
                Player player = (Player)defender;
                player.m_36335_().m_41524_(player.m_21211_().m_41720_(), cd);
            }
            defender.m_5810_();
            this.f_19853_.m_7605_((Entity)defender, (byte)30);
        }
    }

    public void shakeGround(float shakeStrength, float range, float magnitude, int duration, int fadeDuration) {
        if (shakeStrength > 0.0f) {
            float y = shakeStrength + 0.1f * this.f_19796_.m_188501_();
            for (Entity entity : this.f_19853_.m_6443_(Entity.class, this.m_20191_().m_82377_((double)range, 0.0, (double)range), Entity::m_20096_)) {
                if (entity == this) continue;
                float factor = EMMathUtils.getTickFactor(this.m_20270_(entity), range, false);
                entity.m_5997_(0.0, (double)(y - y / 2.0f * factor), 0.0);
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket(entity));
            }
        }
        EntityCameraShake.cameraShake(this.f_19853_, this.m_20182_(), range, magnitude, duration, fadeDuration);
    }

    public void knockBack(LivingEntity target, double strength, double yStrength, boolean forced, boolean continuous) {
        if (forced) {
            target.f_19864_ = true;
        }
        if (!target.m_20096_() || continuous) {
            strength *= 0.25;
            yStrength *= 0.25;
        }
        double d0 = target.m_20185_() - this.m_20185_();
        double d1 = target.m_20189_() - this.m_20189_();
        double d2 = Math.max(d0 * d0 + d1 * d1, 0.001);
        target.m_5997_(d0 / d2 * strength, yStrength, d1 / d2 * strength);
    }

    public void pursuit(float pursuitDistance, float y, double speedModifier) {
        double f0 = Math.cos(Math.toRadians(this.m_146908_() + 90.0f));
        double f1 = Math.sin(Math.toRadians(this.m_146908_() + 90.0f));
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double f3 = this.m_20270_((Entity)target) - target.m_20205_() / 2.0f;
            f3 = Mth.m_14008_((double)f3, (double)0.0, (double)pursuitDistance);
            if (!this.m_20096_()) {
                speedModifier /= 2.0;
            }
            this.m_5997_(f0 * speedModifier * f3, y, f1 * speedModifier * f3);
        } else {
            this.m_5997_(f0, 0.0, f1);
        }
    }

    public boolean inBlocking() {
        Animation a = this.getAnimation();
        return a == this.armBlockEndAnimation || a == this.armBlockHoldAnimation || a == this.armBlockAnimation;
    }

    private Animation getBaseAttackByStage() {
        block3: {
            Animation animation;
            try {
                if (this.getStage() != ImmortalStage.STAGE1) break block3;
                animation = this.LRFlag ? this.punchLeftAnimation : this.punchRightAnimation;
                this.LRFlag = !this.LRFlag;
            }
            catch (Throwable throwable) {
                this.LRFlag = !this.LRFlag;
                throw throwable;
            }
            return animation;
        }
        Animation animation = null;
        this.LRFlag = !this.LRFlag;
        return animation;
    }

    private void floatImmortal() {
        if (this.m_20077_()) {
            CollisionContext collisioncontext = CollisionContext.m_82750_((Entity)this);
            if (collisioncontext.m_6513_(LiquidBlock.f_54690_, this.m_20183_(), true) && !this.f_19853_.m_6425_(this.m_20183_().m_7494_()).m_205070_(FluidTags.f_13132_)) {
                this.m_6853_(true);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(0.5).m_82520_(0.0, 0.15, 0.0));
            }
        }
    }

    private boolean isSwitching() {
        return this.getAnimation() == this.switchStageAnimation;
    }

    public boolean teleportByType(TeleportType type, LivingEntity target) {
        double z;
        double y;
        double x;
        if (this.f_19853_.f_46443_ || !this.m_6084_()) {
            return false;
        }
        if (target == null) {
            type = TeleportType.RANDOM;
        }
        if (TeleportType.SNEAK == type) {
            float width = this.m_20205_() + target.m_20205_();
            double radians = Math.toRadians(target.m_146908_() + 270.0f);
            x = target.m_20185_() + (double)width * Math.cos(radians);
            y = target.m_20186_();
            z = target.m_20189_() + (double)width * Math.sin(radians);
        } else if (TeleportType.FRONT == type || TeleportType.BEHIND == type) {
            double radian = Math.toRadians(target.m_146908_() + (float)(type == TeleportType.FRONT ? 90 : -90));
            int distance = 16;
            x = this.m_20185_() + (double)(this.f_19796_.m_188503_(distance) + distance) * Math.cos(radian);
            y = this.m_20186_() + (double)(this.f_19796_.m_188503_(32) - 16);
            z = this.m_20189_() + (double)(this.f_19796_.m_188503_(distance) + distance) * Math.sin(radian);
        } else {
            x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
            y = this.m_20186_() + (double)(this.f_19796_.m_188503_(32) - 16);
            z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 32.0;
        }
        return this.teleport(x, y, z);
    }

    private boolean teleport(double x, double y, double z) {
        boolean flag = this.m_20984_(x, y, z, false);
        if (flag) {
            this.f_19853_.m_214171_(GameEvent.f_238175_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this));
            if (!this.m_20067_()) {
                this.f_19853_.m_6263_(null, this.f_19854_, this.f_19855_, this.f_19856_, (SoundEvent)SoundInit.IMMORTAL_TELEPORT.get(), this.m_5720_(), 1.5f, 1.0f);
                this.m_5496_((SoundEvent)SoundInit.IMMORTAL_TELEPORT.get(), 1.0f, 1.0f);
            }
        }
        return flag;
    }

    private int getCoolingTimerUtil(int baseCD, float coolDownReductionPerTarget) {
        int targetCount = this.targets.size() - 1;
        if (targetCount <= 0) {
            return baseCD;
        }
        return (int)((float)baseCD * (1.0f - (float)Math.min(targetCount, 5) * coolDownReductionPerTarget / 100.0f));
    }

    private void reflectPotionEffect(MobEffectInstance effectInstance, Entity entity) {
        if (entity != this && entity instanceof LivingEntity) {
            LivingEntity bouncer = (LivingEntity)entity;
            if (!effectInstance.m_19544_().m_8093_()) {
                bouncer.m_147215_(effectInstance, null);
            }
        }
    }

    private void nextBossStage() {
        if (this.m_21223_() <= 0.0f) {
            this.m_21153_(0.1f);
        }
        ImmortalStage stage = ImmortalStage.STAGE2;
        this.f_19804_.m_135381_(DATA_STAGE, (Object)stage.id);
        String stageStr = this.getStage().toString().toLowerCase();
        EntityImmortal.addImmortalHAAModifier(this.m_21051_(Attributes.f_22276_), HEALTH_UUID, stageStr, stage.addHealth);
        EntityImmortal.addImmortalHAAModifier(this.m_21051_(Attributes.f_22284_), ARMOR_UUID, stageStr, stage.addArmor);
        EntityImmortal.addImmortalHAAModifier(this.m_21051_(Attributes.f_22281_), ATTACK_UUID, stageStr, stage.addAttack);
        this.damageAdaptation.clearCache();
        this.playAnimation(this.switchStageAnimation);
    }

    private static void addImmortalHAAModifier(@org.jetbrains.annotations.Nullable AttributeInstance instance, UUID uuid, String stageStr, float amount) {
        if (instance != null) {
            instance.m_22127_(uuid);
            instance.m_22125_(new AttributeModifier(uuid, "Immortal " + stageStr + " modifier", (double)amount, AttributeModifier.Operation.ADDITION));
        }
    }

    private void strongKnockBlock() {
        List entities = this.f_19853_.m_45971_(LivingEntity.class, TargetingConditions.f_26872_, (LivingEntity)this, this.m_20191_().m_82377_(4.0, 5.0, 4.0));
        for (LivingEntity entity : entities) {
            if (entity == this) continue;
            if (entity instanceof Player) {
                Player player = (Player)entity;
                if (player.m_150110_().f_35934_) continue;
            }
            double angle = Math.toRadians(this.getAngleBetweenEntities((Entity)this, (Entity)entity) + 90.0);
            double distance = this.m_20270_((Entity)entity) - 4.0f;
            double mx = Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.cos(angle);
            double my = Math.min(1.0 / (distance * distance), 1.0) * -1.0 * Math.sin(angle);
            entity.m_20256_(entity.m_20184_().m_82520_(mx, 0.0, my).m_82490_(0.8));
        }
    }

    public Vec3 getPosOffset(boolean right, float frontBack, float leftRight, float height) {
        double yawRadians = Math.toRadians(this.m_146908_() + 90.0f);
        double pitchRadians = Math.toRadians(this.m_146908_() + (float)(right ? 180 : 0));
        double x = this.m_20185_() + (double)frontBack * Math.cos(yawRadians) + (double)leftRight * Math.cos(pitchRadians);
        double y = this.m_20186_() + (double)height;
        double z = this.m_20189_() + (double)frontBack * Math.sin(yawRadians) + (double)leftRight * Math.sin(pitchRadians);
        return new Vec3(x, y, z);
    }

    private void doCollisionEffect(int count, float scale, float sizeModifier) {
        this.doHitEffect(3, 0.0f, scale + (float)this.f_19796_.m_188503_(5), 1.45f, 0.625f, false);
        if (this.f_19853_.f_46443_) {
            double phi = Math.PI * (3.0 - Math.sqrt(5.0));
            if (count > 0) {
                count += this.f_19796_.m_188503_(5);
            }
            float width = this.m_20205_() * sizeModifier;
            for (int i = 0; i < count; ++i) {
                Vec3 pos = this.getPosOffset(this.f_19796_.m_188499_(), 1.45f, (float)this.f_19796_.m_216332_(-10, 10) * 0.1f * width, this.m_20206_() * 0.625f);
                double theta = phi * (double)i;
                double y = 1.0 - (double)i / ((double)count - 1.0) * 2.0;
                double radius = Math.sqrt(1.0 - y * y);
                double x = Math.cos(theta) * radius;
                double z = Math.sin(theta) * radius;
                float sideOffset = (float)(this.f_19796_.m_188583_() * 0.2) * (float)(this.f_19796_.m_188499_() ? 1 : -1);
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, x * (double)(sizeModifier + sideOffset), y * (double)sizeModifier, z * (double)(sizeModifier + sideOffset), true, 0.0, 0.0, 0.0, 0.0, 1.0, 0.9019607901573181, 0.9019607901573181, 0.40784314274787903, 0.8f, 0.9f, 3.0, true, true, false, new ParticleComponent[]{new RibbonComponent((ParticleType<? extends RibbonParticleData>)((ParticleType)ParticleInit.FLAT_RIBBON.get()), 8, 0.0, 0.0, 0.0, 0.01f, 0.7686274647712708, 0.7686274647712708, 0.3372549f, 0.8f, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.5f, 0.0f))}, false)});
            }
        }
    }

    private void doHitEffect(int duration, float xRot, float scale, float xOffset, float yOffset, boolean thump) {
        if (this.f_19853_.f_46443_) {
            Vec3 pos = this.getPosOffset(false, xOffset, 0.0f, this.m_20206_() * yOffset);
            float alpha = 0.4f + 0.2f * this.f_19796_.m_188501_();
            float randomScale = scale + (float)this.f_19796_.m_188503_(5);
            float colorOffset = 0.1f * this.f_19796_.m_188501_();
            ParticleType ringParticle = thump ? (ParticleType)ParticleInit.THUMP_RING.get() : (ParticleType)ParticleInit.CRIT_RING.get();
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)ringParticle, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, false, (float)Math.toRadians(-this.f_20883_), (float)Math.toRadians(xRot), 0.0, 0.0, randomScale, 0.75f + colorOffset, 0.75f + colorOffset, 0.75f + colorOffset, alpha, 1.0, duration, true, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.startAndEnd(alpha * 2.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.startAndEnd(randomScale * 0.1f, randomScale * 1.5f), false)});
        }
    }

    private void doPuncturedAirFlowEffect(boolean right) {
        if (this.f_19853_.f_46443_) {
            double radians = Math.toRadians(this.m_146908_() + 90.0f);
            Vec3 pos = this.getPosOffset(right, 1.5f, 1.5f, this.m_20206_() * 0.6f);
            float alpha = 0.15f + 0.15f * this.f_19796_.m_188501_();
            float scale = 30.0f + (float)this.f_19796_.m_188503_(11);
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.PUNCTURED_AIR_RING.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, -Math.cos(radians) * 0.5, 0.007f, -Math.sin(radians) * 0.5, false, (float)Math.toRadians(-this.f_20883_), (float)Math.toRadians(right ? -10.0 : 10.0), 0.0, 0.0, scale, 0.8f, 0.8f, 0.8f, alpha, 1.0, 14.0, true, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.startAndEnd(alpha, 0.1f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.startAndEnd(scale, 0.0f), false)});
        }
    }

    private void doShakeGroundEffect(int count, float fbOffset, float sideOffset, float yOffset, float airDiffusionSpeed, boolean right, boolean blockEffect) {
        if (this.f_19853_.f_46443_) {
            int z;
            int y;
            int x;
            BlockState state;
            Vec3 pos = this.getPosOffset(right, fbOffset, sideOffset, -0.1f);
            double px = pos.f_82479_;
            double py = pos.f_82480_;
            double pz = pos.f_82481_;
            float colorOffset = this.f_19796_.m_188501_() * 0.04f;
            ParticleRing.RingData particle = new ParticleRing.RingData(0.0f, 1.5707964f, 14, 1.0f, 1.0f, 1.0f, 0.8f, 70.0f, false, ParticleRing.EnumRingBehavior.GROW);
            this.f_19853_.m_7106_((ParticleOptions)particle, px, py + (double)yOffset, pz, 0.0, 0.0, 0.0);
            ParticleDust.DustData particle2 = new ParticleDust.DustData((ParticleType<ParticleDust.DustData>)((ParticleType)ParticleInit.DUST.get()), 0.28f - colorOffset, 0.26f - colorOffset, 0.24f - colorOffset, 50.0f, 36 + this.f_19796_.m_188503_(5), ParticleDust.EnumDustBehavior.GROW, airDiffusionSpeed);
            ModParticleUtils.annularParticleOutburst(this.f_19853_, count, new ParticleOptions[]{particle2}, px, py + (double)0.2f, pz, 0.8f, 0.5, 360.0f, 1.7f);
            if (blockEffect && (state = this.f_19853_.m_8055_(new BlockPos(x = Mth.m_14107_((double)px), y = Mth.m_14107_((double)py), z = Mth.m_14107_((double)pz)))).m_60799_() != RenderShape.INVISIBLE) {
                ParticleOptions[] options = new ParticleOptions[]{new BlockParticleOption(ParticleTypes.f_123794_, state)};
                ModParticleUtils.particleOutburst(this.f_19853_, 50, options, px, py + 0.25, pz, new float[][]{{4.0f, 0.1f, 4.0f}}, 1.0f + 0.5f * this.f_19796_.m_188501_());
            }
        }
    }

    private void doImmortalMagicMatrixEffect(EntityImmortalMagicCircle.MagicCircleType magicType, int duration, float offset, float yOffset, float scale) {
        if (this.f_19853_.f_46443_) {
            Vec3 pos = this.getPosOffset(false, offset, 0.0f, this.m_20206_() * yOffset);
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.BIG_RING.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, false, (float)Math.toRadians(-this.f_20883_), 0.0, 0.0, 0.0, scale, 1.0, 1.0, 1.0, 1.0, 1.0, duration, true, false, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new AnimData.KeyTrack(new float[]{1.0f, 0.5f, 0.1f}, new float[]{0.0f, 0.9f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.startAndEnd(0.0f, scale), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.RED, new AnimData.KeyTrack(new float[]{0.18f, magicType.r}, new float[]{0.4f, 0.8f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.GREEN, new AnimData.KeyTrack(new float[]{0.44f, magicType.g}, new float[]{0.4f, 0.8f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.BLUE, new AnimData.KeyTrack(new float[]{0.6f, magicType.b}, new float[]{0.4f, 0.8f}), false)});
        }
    }

    private void doAttractHitEffect() {
        if (this.f_19853_.f_46443_) {
            double radians = Math.toRadians(this.m_146908_() + 90.0f);
            Vec3 pos = this.getPosOffset(false, 3.0f, 0.0f, this.m_20206_() * 0.5f);
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.THUMP_RING.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, -Math.cos(radians) * (double)0.3f, 0.017, -Math.sin(radians) * (double)0.3f, true, 0.0, 0.0, 0.0, 0.0, 1.0, 0.28f, 0.5, 0.56f, 1.0, 1.0, 5.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new AnimData.KeyTrack(new float[]{0.0f, 40.0f, 80.0f}, new float[]{0.0f, 0.4f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.5f, 0.1f), false)});
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.GLOW.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, -Math.cos(radians) * (double)0.3f, 0.017, -Math.sin(radians) * (double)0.3f, true, 0.0, 0.0, 0.0, 0.0, 70.0, 0.46f, 0.75, 0.88f, 1.0, 1.0, 3.0, true, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.5f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(70.0f, 0.0f), false)});
        }
    }

    private void doAttractEffect() {
        int tick = this.getAnimationTick();
        if (tick < 40) {
            if (tick == 1 && !this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundInit.IMMORTAL_ATTRACT.get(), this.m_5720_(), 0.8f, 1.0f, false);
            }
            List<LivingEntity> entities = this.getNearByEntities(LivingEntity.class, 10.0, 10.0, 10.0, 10.0);
            for (LivingEntity inRangeEntity : entities) {
                if (inRangeEntity instanceof Player) {
                    Player player = (Player)inRangeEntity;
                    if (player.m_150110_().f_35934_) continue;
                }
                float attackArc = 180.0f;
                float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, inRangeEntity);
                if (!(entityRelativeAngle >= -attackArc / 2.0f && entityRelativeAngle <= attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f || entityRelativeAngle <= -360.0f + attackArc / 2.0f)) continue;
                double radians = Math.toRadians(this.f_20883_ + 90.0f);
                Vec3 diff = inRangeEntity.m_20182_().m_82546_(this.m_20182_().m_82520_(Math.cos(radians) * 1.5, 0.0, Math.sin(radians * 1.5)));
                diff = diff.m_82541_().m_82490_((double)(0.05f + EMMathUtils.getTickFactor(tick, 40.0f, true) * 0.1f));
                inRangeEntity.m_20256_(inRangeEntity.m_20184_().m_82546_(diff));
                if (!(inRangeEntity.m_20186_() > this.m_20186_() + 10.0)) continue;
                inRangeEntity.m_20256_(inRangeEntity.m_20184_().m_82492_(0.0, 0.06, 0.0));
            }
        }
        if (this.f_19853_.f_46443_) {
            double zRadians = Math.toRadians(this.m_146908_() + 90.0f);
            double frontX = Math.cos(zRadians);
            double frontZ = Math.sin(zRadians);
            double xRadians = Math.toRadians(this.m_146908_() + 180.0f);
            double sideX = Math.cos(xRadians);
            double sideZ = Math.sin(xRadians);
            float tickFactor = EMMathUtils.getTickFactor(tick, 35.0f, true);
            if (tick == 4 || tick == 18 || tick == 30) {
                this.spawnBigRingParticle(tickFactor, sideX, sideZ, frontX, frontZ);
            }
            if (tick > 5 && tick < 35) {
                if (this.f_19796_.m_188501_() < 0.75f && tick % 5 == 1) {
                    this.spawnPuncturedAirFlowParticle(tickFactor, sideX, sideZ, frontX, frontZ);
                }
                if (tick < 30) {
                    tickFactor = EMMathUtils.getTickFactor(tick, 30.0f, false);
                    double factorOffset = 6.0f - tickFactor;
                    double randomOffsetX = ((double)this.f_19796_.m_188501_() - 0.5) * 2.0 * factorOffset;
                    double randomOffsetZ = ((double)this.f_19796_.m_188501_() - 0.5) * 2.0 * factorOffset;
                    double x = this.m_20185_() + randomOffsetX + frontX * factorOffset;
                    double y = this.m_20227_(this.f_19796_.m_188501_());
                    double z = this.m_20189_() + randomOffsetZ + frontZ * factorOffset;
                    if (tick % 2 == 1 && this.f_19796_.m_188501_() < 0.75f) {
                        this.spawnOrbParticle(x, y, z, tickFactor, sideX, frontX, sideZ, frontZ, false);
                    }
                    if (tick % 3 == 1 && this.f_19796_.m_188501_() < 0.65f) {
                        this.spawnOrbParticle(x, y, z, tickFactor, sideX, frontX, sideZ, frontZ, true);
                    }
                }
            }
        }
    }

    private void spawnBigRingParticle(float tickFactor, double sideX, double sideZ, double frontX, double frontZ) {
        if (this.f_19853_.f_46443_) {
            double factorOffset = 4.0f + 2.0f * tickFactor;
            double x = this.m_20185_() + sideX + frontX * factorOffset;
            double y = this.m_20227_(0.45);
            double z = this.m_20189_() + sideZ + frontZ * factorOffset;
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.BIG_RING.get()), x, y, z, 0.0, 0.007, 0.0, false, Math.toRadians(-this.m_146908_()), (float)Math.toRadians(this.f_19796_.m_188499_() ? -5.0 : 5.0), 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 1.0, 1.0, 10.0, true, false, false, new ParticleComponent[]{new ParticleComponent.Attractor(new Vec3[]{this.m_20182_().m_82520_(sideX + frontX, (double)this.m_20206_() * 0.5, sideZ + frontZ)}, 1.5f + (1.0f - tickFactor), 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new AnimData.KeyTrack(new float[]{40.0f + 10.0f * tickFactor, 0.1f}, new float[]{0.0f, 1.0f}), false), new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.6f, 0.0f)), ATTRACT_COMPONENT[0], ATTRACT_COMPONENT[1], ATTRACT_COMPONENT[2]});
        }
    }

    private void spawnPuncturedAirFlowParticle(float tickFactor, double sideX, double sideZ, double frontX, double frontZ) {
        if (this.f_19853_.f_46443_) {
            double factorOffset = 2.0f + 3.0f * tickFactor;
            double x = this.m_20185_() + sideX + frontX * factorOffset;
            double y = this.m_20227_(0.45);
            double z = this.m_20189_() + sideZ + frontZ * factorOffset;
            double yaw = Math.toRadians(-this.m_146908_());
            float pitch = (float)Math.toRadians(this.f_19796_.m_188499_() ? 180.0 : 0.0);
            float roll = (float)Math.toRadians(this.f_19796_.m_188499_() ? -5.0 : 5.0);
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.PUNCTURED_AIR_RING.get()), x, y, z, 0.0, 0.007, 0.0, false, yaw, pitch, roll, 0.0, 1.0, 1.0, 1.0, 1.0, 0.5, 1.0, 10.0f + 5.0f * tickFactor, true, false, true, new ParticleComponent[]{new ParticleComponent.Attractor(new Vec3[]{this.m_20182_().m_82520_(sideX + frontX, (double)this.m_20206_() * 0.5, sideZ + frontZ)}, 2.0f - tickFactor, 0.1f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.startAndEnd(30.0f, 5.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.startAndEnd(0.5f, 0.0f), false), ATTRACT_COMPONENT[0], ATTRACT_COMPONENT[1], ATTRACT_COMPONENT[2]});
        }
    }

    private void spawnOrbParticle(double x, double y, double z, float tickFactor, double sideX, double frontX, double sideZ, double frontZ, boolean ribbon) {
        if (this.f_19853_.f_46443_) {
            ParticleComponent component = ribbon ? new RibbonComponent((ParticleType<? extends RibbonParticleData>)((ParticleType)ParticleInit.FLAT_RIBBON.get()), 8, 0.0, 0.0, 0.0, 0.12f, 1.0, 1.0, 1.0, 0.8f, true, true, new ParticleComponent[]{new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.5f, 0.0f)), new RibbonComponent.PropertyOverLength(RibbonComponent.PropertyOverLength.EnumRibbonProperty.SCALE, AnimData.KeyTrack.startAndEnd(1.0f, 0.0f)), ATTRACT_COMPONENT[0], ATTRACT_COMPONENT[1], ATTRACT_COMPONENT[2]}, false) : new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.AIR_DIFFUSION_SPEED, AnimData.constant(1.0f), false);
            AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_ORB.get()), x, y, z, 0.0, 0.007, 0.0, true, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 0.5, 1.0, 15.0f - 5.0f * tickFactor, true, false, false, new ParticleComponent[]{new ParticleComponent.Attractor(new Vec3[]{this.m_20182_().m_82520_(sideX + frontX, (double)this.m_20206_() * 0.5, sideZ + frontZ)}, 1.0f + tickFactor, 0.25f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(0.5f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(10.0f, 3.0f), false), ATTRACT_COMPONENT[0], ATTRACT_COMPONENT[1], ATTRACT_COMPONENT[2], component});
        }
    }

    private void doUnleashEnergyEffect() {
        if (this.f_19853_.f_46443_) {
            int tick = this.getAnimationTick();
            if (tick % 6 == 0) {
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_RING.get()), this.m_20185_(), this.m_20227_(0.2), this.m_20189_(), 0.0, -0.1f, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 1.5, 0.6, 0.85f, 0.95f, 1.0, 1.0, 10.0, true, true, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(15.0f, 50.0f), false)});
            }
            Vec3 pos = this.getPosOffset(false, 2.0f, 0.0f, this.m_20206_() * 1.4f);
            if (tick % 3 == 0 && tick < 78) {
                AdvancedParticleBase.spawnEmptyComponentParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.GLOW.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 15 + this.f_19796_.m_188503_(3), 0.6, 0.85f, 1.0, 0.4f, 1.0, 2.0, true, false, false);
                AdvancedParticleBase.spawnParticle(this.f_19853_, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleInit.ADV_RING.get()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 1.5, 0.6, 0.85f, 0.95f, 1.0, 1.0, 7.0, true, false, false, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, AnimData.KeyTrack.startAndEnd(1.0f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, AnimData.KeyTrack.startAndEnd(0.0f, 15.0f), false)});
            }
        }
    }

    private void doSwipeEffect(boolean startFlag, boolean holdFlag, @org.jetbrains.annotations.Nullable Boolean left) {
        if (this.f_19853_.f_46443_ && this.hand != null && this.hand.length > 1) {
            if (startFlag) {
                this.lPreHandPos = this.hand[0];
                this.rPreHandPos = this.hand[1];
            } else if (holdFlag) {
                this.doSwipeEffect(left);
            }
        }
    }

    private void doSwipeEffect(@org.jetbrains.annotations.Nullable Boolean left) {
        Vec3 leftPos = this.hand[0];
        double lLength = this.lPreHandPos.m_82546_(leftPos).m_82553_();
        int lNumDusts = (int)Math.floor(2.0 * lLength);
        if (left != null && !left.booleanValue()) {
            lNumDusts = 0;
        }
        Vec3 rightPos = this.hand[1];
        double rLength = this.rPreHandPos.m_82546_(rightPos).m_82553_();
        int rNumDusts = (int)Math.floor(2.0 * rLength);
        if (left != null && left.booleanValue()) {
            rNumDusts = 0;
        }
        if (this.lPreHandPos.m_82553_() == 0.0 || this.rPreHandPos.m_82553_() == 0.0 || leftPos.m_82553_() == 0.0 || rightPos.m_82553_() == 0.0) {
            return;
        }
        Animation animation = this.getAnimation();
        if (animation == this.shoryukenAnimation || animation == this.pounceSmashAnimation) {
            if (animation == this.shoryukenAnimation) {
                ModParticleUtils.generateParticleEffects(this.f_19853_, rightPos.f_82479_, rightPos.f_82480_ - 2.0, rightPos.f_82481_, Math.toRadians(this.m_146908_()), 15, BLOCK_OFFSETS, pos -> this.f_19853_.m_8055_(pos), 2.0);
            }
            this.spawnSwipeParticle(this.lPreHandPos, leftPos, lNumDusts, 0.25f, lNumDusts, 10, 0.5f, 0.18f, 0.3f, 0.36f);
            this.spawnSwipeParticle(this.rPreHandPos, rightPos, rNumDusts, 0.25f, rNumDusts, 10, 0.5f, 0.18f, 0.3f, 0.36f);
        } else if (animation == this.attractAnimation || animation == this.hardPunchRightAnimation || animation == this.hardPunchLeftAnimation) {
            this.spawnSwipeParticle(this.lPreHandPos, leftPos, lNumDusts, 0.12f, lNumDusts, 2, 0.6f, 0.18f, 0.3f, 0.36f);
            this.spawnSwipeParticle(this.rPreHandPos, rightPos, rNumDusts, 0.12f, rNumDusts, 2, 0.6f, 0.18f, 0.3f, 0.36f);
        } else if (animation == this.punchRightAnimation || animation == this.punchLeftAnimation) {
            this.spawnSwipeParticle(this.lPreHandPos, leftPos, lNumDusts, 0.75f, lNumDusts, 2, 0.65f, 0.1f, 0.188f, 0.25f);
            this.spawnSwipeParticle(this.rPreHandPos, rightPos, rNumDusts, 0.75f, rNumDusts, 2, 0.65f, 0.1f, 0.188f, 0.25f);
        } else if (animation == this.smashGround1Animation || animation == this.smashGround2Animation || animation == this.smashGround3Animation) {
            this.spawnSwipeParticle(this.lPreHandPos, leftPos, lNumDusts, 0.1f, lNumDusts, 3, 0.65f, 0.1f, 0.188f, 0.25f);
            this.spawnSwipeParticle(this.rPreHandPos, rightPos, rNumDusts, 0.1f, rNumDusts, 3, 0.65f, 0.1f, 0.188f, 0.25f);
        }
        this.lPreHandPos = leftPos;
        this.rPreHandPos = rightPos;
    }

    private void spawnSwipeParticle(Vec3 start, Vec3 end, int numDusts, float speedMultiplier, int lifetimeModifier, int baseDuration, float randomness, float r, float g, float b) {
        for (int i = 0; i < numDusts; ++i) {
            double radians = Math.toRadians(this.f_20883_ + 90.0f);
            double xSpeed = Math.cos(radians);
            double zSpeed = Math.sin(radians);
            double x = start.f_82479_ + (double)i * (end.f_82479_ - start.f_82479_) / (double)numDusts;
            double y = start.f_82480_ + (double)i * (end.f_82480_ - start.f_82480_) / (double)numDusts;
            double z = start.f_82481_ + (double)i * (end.f_82481_ - start.f_82481_) / (double)numDusts;
            for (int j = 0; j < 2; ++j) {
                float xOffset = randomness * (2.0f * this.f_19796_.m_188501_() - 1.0f);
                float yOffset = randomness * (2.0f * this.f_19796_.m_188501_() - 1.0f);
                float zOffset = randomness * (2.0f * this.f_19796_.m_188501_() - 1.0f);
                float colorOffset = this.f_19796_.m_188501_() * 0.04f;
                this.f_19853_.m_7106_((ParticleOptions)new ParticleDust.DustData((ParticleType<ParticleDust.DustData>)((ParticleType)ParticleInit.DUST.get()), r + colorOffset, g + colorOffset, b + colorOffset, (float)(10.0 + this.f_19796_.m_188500_() * 10.0), baseDuration + lifetimeModifier, ParticleDust.EnumDustBehavior.SHRINK, 1.0f, true), x + (double)xOffset, y + (double)yOffset, z + (double)zOffset, xSpeed * (double)speedMultiplier, (double)0.007f, zSpeed * (double)speedMultiplier);
            }
        }
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 400.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 4.0).m_22268_(Attributes.f_22279_, 0.36).m_22268_(Attributes.f_22277_, 64.0).m_22268_(Attributes.f_22281_, 12.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.09);
    }

    public int getTimeUntilLaser() {
        return this.timeUntilLaser;
    }

    public boolean isAlwaysActive() {
        return (Boolean)this.f_19804_.m_135370_(DATA_ALWAYS_ACTIVE);
    }

    public void setAlwaysActive(boolean alwaysActive) {
        this.f_19804_.m_135381_(DATA_ALWAYS_ACTIVE, (Object)alwaysActive);
    }

    public ImmortalStage getStage() {
        return ImmortalStage.byStage(((Byte)this.f_19804_.m_135370_(DATA_STAGE)).byteValue());
    }

    public TeleportType getTeleportType() {
        return TeleportType.byType(((Byte)this.f_19804_.m_135370_(DATA_TELEPORT_TYPE)).byteValue());
    }

    public void setTeleportType(@NotNull TeleportType type) {
        this.f_19804_.m_135381_(DATA_TELEPORT_TYPE, (Object)type.id);
    }

    public boolean isHoldKatana() {
        return (Boolean)this.f_19804_.m_135370_(DATA_KATANA_HOLD);
    }

    public void setHoldKatana(boolean held) {
        this.f_19804_.m_135381_(DATA_KATANA_HOLD, (Object)held);
    }

    @Override
    public boolean isGlow() {
        return !this.glowControllerAnimation.isStop();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        if (this.damageAdaptation.isFullyAdapted((LivingEntity)this, damageSource)) {
            this.m_5496_((SoundEvent)SoundInit.IMMORTAL_ADAPT.get(), 1.0f, this.m_6100_() + 0.1f);
        } else {
            this.m_5496_((SoundEvent)SoundInit.IMMORTAL_HURT.get(), 1.5f, this.m_6100_());
        }
        return null;
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.IMMORTAL_DEATH.get();
    }

    @org.jetbrains.annotations.Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundInit.IMMORTAL_IDLE.get();
    }

    public void m_8032_() {
        if (this.m_5448_() == null && this.isActive() && this.getAnimation() != this.spawnAnimation) {
            super.m_8032_();
        }
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
    }

    public void anchorToGround() {
        this.m_20334_(0.0, !this.m_20096_() && this.m_20184_().f_82480_ > 0.0 ? -0.005 : this.m_20184_().f_82480_, 0.0);
    }

    @Override
    protected boolean canPlayMusic() {
        return this.isActive() && super.canPlayMusic();
    }

    @Override
    public SoundEvent getBossMusic() {
        return (SoundEvent)SoundInit.THE_ARMY_OF_MINOTAUR.get();
    }

    @Override
    public void setOwner(@org.jetbrains.annotations.Nullable EntityAbsImmortal owner) {
    }

    @Override
    public void setOwnerUUID(UUID uuid) {
    }

    @Override
    public void setSpawnParticle(int amount) {
    }

    @Override
    public boolean isSummon() {
        return false;
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    @Override
    public int getIllegalityCount() {
        return 0;
    }

    @Override
    public void setIllegalityCount(int count) {
    }

    static class ImmortalGroupAI
    extends AnimationGroupAI<EntityImmortal> {
        @SafeVarargs
        public ImmortalGroupAI(EntityImmortal entity, Supplier<Animation> ... animations) {
            super(entity, animations);
        }

        public void m_8037_() {
            Animation animation = ((EntityImmortal)this.entity).getAnimation();
            if (animation == ((EntityImmortal)this.entity).teleportAnimation) {
                LivingEntity target = ((EntityImmortal)this.entity).m_5448_();
                if (target != null) {
                    ((EntityImmortal)this.entity).m_21391_((Entity)target, 90.0f, 30.0f);
                    ((EntityImmortal)this.entity).m_21563_().m_24960_((Entity)target, 90.0f, 30.0f);
                }
            } else if (animation == ((EntityImmortal)this.entity).spawnAnimation || animation == ((EntityImmortal)this.entity).switchStageAnimation) {
                // empty if block
            }
        }
    }

    public static enum TeleportType {
        RANDOM(0),
        FRONT(1),
        BEHIND(2),
        SNEAK(3);

        private final byte id;
        private static final TeleportType[] BY_ID;

        private TeleportType(int id) {
            this.id = (byte)id;
        }

        public int getId() {
            return this.id;
        }

        public static TeleportType byType(int id) {
            return BY_ID[id % BY_ID.length];
        }

        static {
            BY_ID = (TeleportType[])Arrays.stream(TeleportType.values()).sorted(Comparator.comparingInt(TeleportType::getId)).toArray(TeleportType[]::new);
        }
    }
}

