/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.immortal;

import com.eeeab.animate.server.ai.AnimationAI;
import com.eeeab.animate.server.ai.AnimationMeleeAI;
import com.eeeab.animate.server.ai.AnimationRangeAI;
import com.eeeab.animate.server.ai.animation.AnimationActivate;
import com.eeeab.animate.server.ai.animation.AnimationAreaMelee;
import com.eeeab.animate.server.ai.animation.AnimationBlock;
import com.eeeab.animate.server.ai.animation.AnimationDie;
import com.eeeab.animate.server.ai.animation.AnimationMelee;
import com.eeeab.animate.server.ai.animation.AnimationRange;
import com.eeeab.animate.server.animation.Animation;
import com.eeeab.animate.server.handler.EMAnimationHandler;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.EMLookAtGoal;
import com.eeeab.eeeabsmobs.sever.entity.ai.goal.owner.CopyOwnerTargetGoal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityAbsImmortal;
import com.eeeab.eeeabsmobs.sever.entity.immortal.EntityImmortalGolem;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.ItemInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import java.util.Arrays;
import java.util.Comparator;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public abstract class EntityAbsImmortalSkeleton
extends EntityAbsImmortal
implements RangedAttackMob {
    public final Animation swingArmAnimation = Animation.create(15);
    public final Animation meleeAnimation1 = Animation.create(15);
    public final Animation meleeAnimation2 = Animation.create(15);
    public final Animation bowAnimation = Animation.create(30);
    public final Animation crossBowChangeAnimation = Animation.create(30);
    public final Animation crossBowHoldAnimation = Animation.create(10);
    public final Animation castAnimation = Animation.create(30);
    public final Animation blockAnimation = Animation.create(10);
    public final Animation spawnAnimation = Animation.create(20);
    public final Animation roarAnimation = Animation.create(45);
    public final Animation dieAnimation = Animation.create(30);
    private final Animation[] animations = new Animation[]{this.swingArmAnimation, this.meleeAnimation1, this.meleeAnimation2, this.bowAnimation, this.crossBowChangeAnimation, this.crossBowHoldAnimation, this.castAnimation, this.blockAnimation, this.spawnAnimation, this.roarAnimation, this.dieAnimation};
    private static final EntityDataAccessor<Integer> DATA_CAREER_TYPE = SynchedEntityData.m_135353_(EntityAbsImmortalSkeleton.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final UUID ATTACK_UUID = UUID.fromString("2D305FA6-B041-4300-80F0-D04F95A65BA8");
    private static final UUID HEALTH_UUID = UUID.fromString("6C41A484-299F-4DB7-A8DF-75713D68D2DE");
    private static final UUID ARMOR_UUID = UUID.fromString("CF54F152-37B6-4A40-A7E5-5D0715B98423");
    private static final UUID SPEED_UUID = UUID.fromString("69163DAB-E9E5-7769-C147-31A405D27167");
    private int blockCoolTick;

    public EntityAbsImmortalSkeleton(EntityType<? extends EntityAbsImmortal> type, Level level) {
        super(type, level);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.9f;
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 0, true, false, null));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(7, (Goal)new EMLookAtGoal(this, Player.class, 6.0f));
    }

    @Override
    protected void registerCustomGoals() {
        this.f_21345_.m_25352_(1, new AnimationActivate<EntityAbsImmortalSkeleton>(this, () -> this.spawnAnimation));
        this.f_21345_.m_25352_(1, (Goal)new AnimationAI<EntityAbsImmortalSkeleton>(this){

            @Override
            protected boolean test(Animation animation) {
                return animation == ((EntityAbsImmortalSkeleton)this.entity).crossBowChangeAnimation || animation == ((EntityAbsImmortalSkeleton)this.entity).crossBowHoldAnimation;
            }

            @Override
            public void m_8056_() {
                super.m_8056_();
                ((EntityAbsImmortalSkeleton)this.entity).m_6672_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this.entity, item -> item instanceof CrossbowItem));
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                ((EntityAbsImmortalSkeleton)this.entity).m_5810_();
            }

            public void m_8037_() {
                super.m_8037_();
                LivingEntity target = ((EntityAbsImmortalSkeleton)this.entity).m_5448_();
                int tick = ((EntityAbsImmortalSkeleton)this.entity).getAnimationTick();
                Animation animation = ((EntityAbsImmortalSkeleton)this.entity).getAnimation();
                if (target != null) {
                    ((EntityAbsImmortalSkeleton)this.entity).m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
                    if (animation == ((EntityAbsImmortalSkeleton)this.entity).crossBowChangeAnimation) {
                        boolean isLoaded = ((EntityAbsImmortalSkeleton)this.entity).m_21093_(is -> is.m_41720_() instanceof CrossbowItem && CrossbowItem.m_40932_((ItemStack)is));
                        if (tick == animation.getDuration() - 1 || isLoaded) {
                            if (!isLoaded && ((EntityAbsImmortalSkeleton)this.entity).m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
                                CrossbowItem.m_40884_((ItemStack)((EntityAbsImmortalSkeleton)this.entity).m_21211_(), (boolean)true);
                            }
                            ((EntityAbsImmortalSkeleton)this.entity).playAnimation(((EntityAbsImmortalSkeleton)this.entity).crossBowHoldAnimation);
                        }
                    } else if (animation == ((EntityAbsImmortalSkeleton)this.entity).crossBowHoldAnimation && tick == 9) {
                        ((EntityAbsImmortalSkeleton)this.entity).m_6504_(target, 0.0f);
                        if (((EntityAbsImmortalSkeleton)this.entity).m_21093_(is -> is.m_41720_() instanceof CrossbowItem)) {
                            CrossbowItem.m_40884_((ItemStack)((EntityAbsImmortalSkeleton)this.entity).m_21211_(), (boolean)false);
                        }
                    }
                }
            }
        });
        this.f_21345_.m_25352_(1, (Goal)new AnimationAI<EntityAbsImmortalSkeleton>(this, true, true){

            @Override
            protected boolean test(Animation animation) {
                return animation == ((EntityAbsImmortalSkeleton)this.entity).castAnimation;
            }

            public void m_8037_() {
                int tick = ((EntityAbsImmortalSkeleton)this.entity).getAnimationTick();
                if (tick == 20 && ((EntityAbsImmortalSkeleton)this.entity).m_5448_() != null) {
                    LivingEntity livingEntity = ((EntityAbsImmortalSkeleton)this.entity).m_5448_();
                    double minY = Math.min(livingEntity.m_20186_(), ((EntityAbsImmortalSkeleton)this.entity).m_20186_());
                    double maxY = Math.max(livingEntity.m_20186_(), ((EntityAbsImmortalSkeleton)this.entity).m_20186_()) + 1.0;
                    Vec3 point1 = ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.entity, ((EntityAbsImmortalSkeleton)this.entity).m_20185_() - 1.0, ((EntityAbsImmortalSkeleton)this.entity).m_20189_(), minY, maxY);
                    this.summonEntity(point1);
                    Vec3 point2 = ModEntityUtils.checkSummonEntityPoint((LivingEntity)this.entity, ((EntityAbsImmortalSkeleton)this.entity).m_20185_() + 1.0, ((EntityAbsImmortalSkeleton)this.entity).m_20189_(), minY, maxY);
                    this.summonEntity(point2);
                }
            }

            private void summonEntity(Vec3 vec3) {
                EntityImmortalGolem entity = (EntityImmortalGolem)((EntityType)EntityInit.IMMORTAL_GOLEM.get()).m_20615_(((EntityAbsImmortalSkeleton)this.entity).f_19853_);
                if (!((EntityAbsImmortalSkeleton)this.entity).f_19853_.f_46443_ && entity != null && vec3 != null) {
                    entity.setInitSpawn();
                    entity.m_6518_((ServerLevelAccessor)((ServerLevel)((EntityAbsImmortalSkeleton)this.entity).f_19853_), ((EntityAbsImmortalSkeleton)this.entity).f_19853_.m_6436_(new BlockPos(vec3)), MobSpawnType.MOB_SUMMONED, null, null);
                    entity.setOwner((EntityAbsImmortal)this.entity);
                    entity.setSummonAliveTime(20 * (15 + ((EntityAbsImmortalSkeleton)this.entity).f_19796_.m_188503_(15)));
                    Difficulty difficulty = ((EntityAbsImmortalSkeleton)this.entity).f_19853_.m_46791_();
                    entity.setDangerous(((EntityAbsImmortalSkeleton)this.entity).f_19796_.m_188503_(10 - difficulty.m_19028_()) == 0);
                    entity.m_146884_(vec3);
                    EntityAbsImmortalSkeleton.this.f_19853_.m_7967_((Entity)entity);
                }
            }
        });
        this.f_21345_.m_25352_(1, new AnimationRange<EntityAbsImmortalSkeleton>(this, () -> this.bowAnimation, 25, null));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityAbsImmortalSkeleton>(this, () -> this.swingArmAnimation, 6, 2.5f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationMelee<EntityAbsImmortalSkeleton>(this, () -> this.meleeAnimation1, 8, 2.8f, 1.0f, 1.0f));
        this.f_21345_.m_25352_(1, new AnimationAreaMelee<EntityAbsImmortalSkeleton>(this, () -> this.meleeAnimation2, 6, 2.8f, 1.0f, 1.0f, 90.0f, 2.8f, true));
        this.f_21345_.m_25352_(1, new AnimationBlock<EntityAbsImmortalSkeleton>(this, () -> this.blockAnimation));
        this.f_21345_.m_25352_(2, new AnimationDie<EntityAbsImmortalSkeleton>(this));
        this.f_21346_.m_25352_(2, new CopyOwnerTargetGoal<EntityAbsImmortalSkeleton>(this));
        Predicate<EntityAbsImmortalSkeleton> AKPredicate = e -> e.checkHoldItemIsCareerWeapon(CareerType.ARCHER, CareerType.KNIGHT);
        int randomInterval = this.f_19796_.m_188503_(10);
        this.f_21345_.m_25352_(3, new AnimationRangeAI<EntityAbsImmortalSkeleton>(this, 1.0, 20 + randomInterval, 10.0f, Items.f_42717_, AKPredicate, () -> this.crossBowChangeAnimation));
        this.f_21345_.m_25352_(3, new AnimationRangeAI<EntityAbsImmortalSkeleton>(this, 1.0, 25 + randomInterval, 12.0f, Items.f_42411_, AKPredicate, () -> this.bowAnimation));
        this.f_21345_.m_25352_(3, new AnimationRangeAI<EntityAbsImmortalSkeleton>(this, 1.0, 300 + this.f_19796_.m_188503_(100), 16.0f, null, e -> e.checkHoldItemIsCareerWeapon(CareerType.MAGE), () -> this.castAnimation));
        this.f_21345_.m_25352_(4, new AnimationMeleeAI<EntityAbsImmortalSkeleton>(this, 1.0, 10 + randomInterval, e -> e.checkHoldItemIsCareerWeapon(CareerType.WARRIOR, CareerType.KNIGHT), () -> this.meleeAnimation1, () -> this.meleeAnimation2));
        this.f_21345_.m_25352_(5, new AnimationMeleeAI<EntityAbsImmortalSkeleton>(this, 1.05, 10 + randomInterval, EntityAbsImmortalSkeleton::checkConformCareerWeapon, () -> this.swingArmAnimation));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        EMAnimationHandler.INSTANCE.updateAnimations(this);
        if (this.getVariant() == CareerType.ARCHER) {
            if (this.m_5448_() != null && !this.m_21525_() && this.isActive()) {
                LivingEntity target = this.m_5448_();
                if (this.attackTick == 0 && this.m_21574_().m_148306_((Entity)target)) {
                    this.attacking = true;
                }
                if (this.attacking && this.m_21574_().m_148306_((Entity)target) && this.m_6779_(target) && ((double)this.targetDistance < 1.5 || (double)this.targetDistance < 2.5 && ModEntityUtils.checkTargetComingCloser((LivingEntity)this, target))) {
                    this.m_5810_();
                    this.playAnimation(this.meleeAnimation1);
                    this.attackTick = 20;
                    this.attacking = false;
                }
            } else {
                this.attacking = false;
            }
        }
        if (this.getAnimation() != NO_ANIMATION) {
            this.m_21573_().m_26573_();
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        if (this.attackTick > 0) {
            --this.attackTick;
        }
        if (this.blockCoolTick > 0) {
            --this.blockCoolTick;
        }
    }

    @Override
    public boolean m_6469_(DamageSource source, float damage) {
        Entity entity;
        Entity entity2 = source.m_7639_();
        boolean hitFlag = true;
        byte pierceLevel = 0;
        float attackArc = 220.0f;
        if (entity2 != null) {
            float entityRelativeAngle = ModEntityUtils.getTargetRelativeAngle((LivingEntity)this, entity2.m_20182_());
            boolean bl = hitFlag = entityRelativeAngle <= attackArc / 2.0f && entityRelativeAngle >= -attackArc / 2.0f || entityRelativeAngle >= 360.0f - attackArc / 2.0f || entityRelativeAngle <= -attackArc + 45.0f;
        }
        if ((entity = source.m_7640_()) instanceof AbstractArrow) {
            AbstractArrow arrow = (AbstractArrow)entity;
            pierceLevel = arrow.m_36796_();
        }
        if (hitFlag && this.checkHoldItemCanBlock() && entity2 instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity2;
            if (!source.m_19376_() && (this.isNoAnimation() || this.getAnimation() == this.blockAnimation)) {
                this.blockEntity = livingEntity;
                if (livingEntity.m_213824_() || damage >= this.m_21233_()) {
                    this.m_216990_(SoundEvents.f_12347_);
                    this.blockCoolTick = 100;
                } else if (pierceLevel == 0) {
                    this.m_216990_(SoundEvents.f_12346_);
                }
                if (this.getAnimation() != this.blockAnimation) {
                    this.playAnimation(this.blockAnimation);
                }
                if (pierceLevel > 0) {
                    return super.m_6469_(source, damage *= 0.6f + Math.min((float)pierceLevel * 0.1f, 0.4f));
                }
                return false;
            }
        }
        return super.m_6469_(source, damage);
    }

    public void m_6504_(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = this.m_6298_(this.m_21120_(ProjectileUtil.getWeaponHoldingHand((LivingEntity)this, item -> item instanceof ProjectileWeaponItem)));
        AbstractArrow abstractarrow = this.getArrow(itemstack, BowItem.m_40661_((int)20));
        if (this.m_21205_().m_41720_() instanceof BowItem) {
            abstractarrow = ((BowItem)this.m_21205_().m_41720_()).customArrow(abstractarrow);
        }
        double x = target.m_20185_() - this.m_20185_();
        double y = target.m_20227_(0.3333333333333333) - abstractarrow.m_20186_();
        double z = target.m_20189_() - this.m_20189_();
        double d0 = Math.sqrt(x * x + z * z) * (double)0.2f;
        abstractarrow.m_6686_(x, y + d0, z, 1.6f, (float)(14 - this.f_19853_.m_46791_().m_19028_() * 4));
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.f_19853_.m_7967_((Entity)abstractarrow);
    }

    protected AbstractArrow getArrow(ItemStack arrowStack, float distanceFactor) {
        return ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)arrowStack, (float)distanceFactor);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CAREER_TYPE, (Object)CareerType.NONE.id);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        RandomSource inRandom = worldIn.m_213780_();
        int id = this.getCareerId(inRandom);
        this.f_19804_.m_135381_(DATA_CAREER_TYPE, (Object)id);
        AttributeInstance attack = this.m_21051_(Attributes.f_22281_);
        AttributeInstance health = this.m_21051_(Attributes.f_22276_);
        AttributeInstance armor = this.m_21051_(Attributes.f_22284_);
        AttributeInstance speed = this.m_21051_(Attributes.f_22279_);
        CareerType careerType = CareerType.byId(id);
        if (attack == null || health == null || armor == null || speed == null) {
            return spawnDataIn;
        }
        attack.m_22120_(ATTACK_UUID);
        health.m_22120_(HEALTH_UUID);
        armor.m_22120_(ARMOR_UUID);
        speed.m_22120_(SPEED_UUID);
        attack.m_22125_(new AttributeModifier(ATTACK_UUID, "Add career attack", (double)careerType.attack, AttributeModifier.Operation.ADDITION));
        health.m_22125_(new AttributeModifier(HEALTH_UUID, "Add career health", (double)careerType.health, AttributeModifier.Operation.ADDITION));
        armor.m_22125_(new AttributeModifier(ARMOR_UUID, "Add career armor", (double)careerType.armor, AttributeModifier.Operation.ADDITION));
        speed.m_22125_(new AttributeModifier(SPEED_UUID, "Add career speed", (double)careerType.speed, AttributeModifier.Operation.ADDITION));
        this.m_21153_(this.m_21233_());
        this.m_213945_(inRandom, difficultyIn);
        this.m_213946_(inRandom, difficultyIn);
        return spawnDataIn;
    }

    protected abstract int getCareerId(RandomSource var1);

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)SoundInit.IMMORTAL_SKELETON_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundInit.IMMORTAL_SKELETON_DEATH.get();
    }

    @Override
    public Animation getDeathAnimation() {
        return this.dieAnimation;
    }

    @Override
    public Animation[] getAnimations() {
        return this.animations;
    }

    @Override
    public Animation getSpawnAnimation() {
        return this.spawnAnimation;
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("careerType", this.getVariant().id);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.f_19804_.m_135381_(DATA_CAREER_TYPE, (Object)compound.m_128451_("careerType"));
    }

    protected void m_213945_(RandomSource randomSource, DifficultyInstance difficultyIn) {
        CareerType careerType = this.getVariant();
        this.m_8061_(EquipmentSlot.MAINHAND, careerType.holdItems[randomSource.m_188503_(careerType.holdItems.length)].m_7968_());
    }

    public static AttributeSupplier.Builder setAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.28).m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22278_, 0.0);
    }

    @NotNull
    public CareerType getVariant() {
        return CareerType.byId((Integer)this.f_19804_.m_135370_(DATA_CAREER_TYPE));
    }

    public void setVariant(CareerType careerType) {
        this.f_19804_.m_135381_(DATA_CAREER_TYPE, (Object)careerType.id);
    }

    public boolean checkHoldItemCanBlock() {
        if (this.m_21206_().m_41720_() instanceof ShieldItem || this.m_21205_().m_41720_() instanceof ShieldItem) {
            return this.blockCoolTick <= 0;
        }
        return false;
    }

    public boolean checkHoldItemIsCareerWeapon(CareerType ... careerType) {
        for (CareerType type : careerType) {
            if (this.getVariant() != type) continue;
            for (Item holdItem : type.holdItems) {
                if (!this.m_21205_().m_150930_(holdItem)) continue;
                return this.active;
            }
        }
        return false;
    }

    public boolean checkConformCareerWeapon() {
        return this.getVariant() == CareerType.NONE || !this.checkHoldItemIsCareerWeapon(this.getVariant());
    }

    public boolean isWarrior() {
        return CareerType.WARRIOR == this.getVariant();
    }

    public boolean isArcher() {
        return CareerType.ARCHER == this.getVariant();
    }

    public boolean isMage() {
        return CareerType.MAGE == this.getVariant();
    }

    public boolean isKnight() {
        return CareerType.KNIGHT == this.getVariant();
    }

    public static enum CareerType implements StringRepresentable
    {
        NONE(0, "none", 5.0f, 4.0f, 0.0f, 0.01f, 1.05f, Items.f_41852_, (Item)ItemInit.IMMORTAL_BONE.get()),
        MAGE(1, "mage", 20.0f, 0.0f, 2.0f, 0.03f, 1.05f, Items.f_41852_),
        ARCHER(2, "archer", 10.0f, 6.0f, 4.0f, 0.025f, 1.1f, Items.f_42411_, Items.f_42717_),
        WARRIOR(3, "warrior", 15.0f, 5.0f, 6.0f, 0.02f, 1.1f, Items.f_42425_),
        KNIGHT(4, "knight", 25.0f, 6.0f, 8.0f, 0.0f, 1.2f, (Item)ItemInit.IMMORTAL_AXE.get(), (Item)ItemInit.IMMORTAL_SWORD.get(), Items.f_42411_, Items.f_42717_);

        public final int id;
        public final String name;
        public final float health;
        public final float attack;
        public final float armor;
        public final float speed;
        public final float scale;
        public final Item[] holdItems;
        private static final CareerType[] BY_ID;

        private CareerType(int id, String name, float health, float attack, float armor, float speed, float scale, Item ... holdItems) {
            this.id = id;
            this.name = name;
            this.health = health;
            this.attack = attack;
            this.armor = armor;
            this.speed = speed;
            this.scale = scale;
            this.holdItems = holdItems;
        }

        public int getId() {
            return this.id;
        }

        public static CareerType byId(int id) {
            return BY_ID[id % BY_ID.length];
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            BY_ID = (CareerType[])Arrays.stream(CareerType.values()).sorted(Comparator.comparingInt(CareerType::getId)).toArray(CareerType[]::new);
        }
    }
}

