/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.sever.entity.effects;

import com.eeeab.eeeabsmobs.client.particle.base.ParticleOrb;
import com.eeeab.eeeabsmobs.client.util.ControlledAnimation;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityMagicEffects;
import com.eeeab.eeeabsmobs.sever.entity.util.ModEntityUtils;
import com.eeeab.eeeabsmobs.sever.init.EntityInit;
import com.eeeab.eeeabsmobs.sever.init.SoundInit;
import com.eeeab.eeeabsmobs.sever.util.EMMathUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityImmortalMagicCircle
extends EntityMagicEffects {
    private static final EntityDataAccessor<Float> DATA_SCALE = SynchedEntityData.m_135353_(EntityImmortalMagicCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_SPEED = SynchedEntityData.m_135353_(EntityImmortalMagicCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_YAW = SynchedEntityData.m_135353_(EntityImmortalMagicCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_DURATION = SynchedEntityData.m_135353_(EntityImmortalMagicCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<String> DATA_TYPE = SynchedEntityData.m_135353_(EntityImmortalMagicCircle.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public final ControlledAnimation processController = new ControlledAnimation(5);
    private boolean canFollow;
    public boolean NO = true;

    public EntityImmortalMagicCircle(EntityType<EntityImmortalMagicCircle> type, Level level) {
        super(type, level);
    }

    public EntityImmortalMagicCircle(Level level) {
        super((EntityType)EntityInit.MAGIC_CIRCLE.get(), level);
    }

    public boolean m_6060_() {
        return false;
    }

    public boolean m_20068_() {
        return true;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.processController.updatePrevTimer();
        if (!this.f_19853_.f_46443_ && this.canFollow && this.caster != null && !this.caster.m_213877_() && this.m_20270_((Entity)this.caster) < this.getScale() * 2.0f && this.m_20186_() - 0.25 > this.caster.m_20186_()) {
            this.m_6034_(this.m_20185_(), this.caster.m_20186_() + 0.25, this.m_20189_());
        }
        if (this.NO && this.processController.increaseTimerChain().isEnd()) {
            this.NO = false;
        }
        if (!this.NO) {
            if (this.f_19797_ > this.getDuration()) {
                if (this.processController.decreaseTimerChain().isStop()) {
                    this.m_146870_();
                }
            } else {
                MobEffect[] effects;
                if (!this.f_19853_.f_46443_ && (effects = this.getMagicCircleType().effect).length > 0) {
                    for (LivingEntity inRange : this.f_19853_.m_6443_(LivingEntity.class, ModEntityUtils.makeAABBWithSize(this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, this.getScale(), 1.0, this.getScale()), LivingEntity::m_6084_)) {
                        for (MobEffect effect : effects) {
                            MobEffectInstance instance;
                            if (inRange.m_21023_(effect) && (instance = inRange.m_21124_(effect)) != null && instance.m_19564_() >= 1) continue;
                            ModEntityUtils.addEffectStackingAmplifier(null, inRange, effect, this.getDuration(), 2, true, true, true, false, false);
                        }
                    }
                }
                if (this.f_19853_.f_46443_ && this.f_19796_.m_188503_(4) == 0) {
                    float factor = EMMathUtils.getTickFactor(this.f_19797_, this.getDuration(), true);
                    for (float i = 0.0f; i < 10.0f * factor; i += 1.0f) {
                        double x = this.m_20185_() + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)(-this.getScale()), (float)this.getScale());
                        double z = this.m_20189_() + (double)Mth.m_216283_((RandomSource)this.f_19796_, (float)(-this.getScale()), (float)this.getScale());
                        MagicCircleType type = this.getMagicCircleType();
                        ParticleOrb.OrbData orbData = new ParticleOrb.OrbData(type.r, type.g, type.b, 2.0f, (int)(15.0f + 5.0f * this.f_19796_.m_188501_()));
                        this.f_19853_.m_7106_((ParticleOptions)orbData, x, this.m_20186_() + 0.1, z, 0.0, 0.2 + this.f_19796_.m_188583_() * 0.02, 0.0);
                    }
                }
            }
        }
    }

    public void m_20256_(@NotNull Vec3 deltaMovement) {
    }

    public void m_20334_(double x, double y, double z) {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_SCALE, (Object)Float.valueOf(2.0f));
        this.f_19804_.m_135372_(DATA_SPEED, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_DURATION, (Object)20);
        this.f_19804_.m_135372_(DATA_TYPE, (Object)MagicCircleType.NONE.toString());
    }

    @Override
    protected void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128350_("scale", this.getScale());
        compoundTag.m_128350_("speed", this.getSpeed());
        compoundTag.m_128350_("yaw", this.getYaw());
        compoundTag.m_128405_("duration", this.getDuration());
        compoundTag.m_128359_("magicType", this.getMagicCircleType().toString());
    }

    @Override
    protected void m_7378_(CompoundTag compoundTag) {
        this.setScale(compoundTag.m_128457_("scale"));
        this.setSpeed(compoundTag.m_128457_("speed"));
        this.setYaw(compoundTag.m_128457_("yaw"));
        this.setDuration(compoundTag.m_128451_("duration"));
        try {
            this.setMagicCircleType(MagicCircleType.valueOf(compoundTag.m_128461_("magicType")));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public float getScale() {
        return ((Float)this.f_19804_.m_135370_(DATA_SCALE)).floatValue();
    }

    public void setScale(float scale) {
        this.f_19804_.m_135381_(DATA_SCALE, (Object)Float.valueOf(scale));
    }

    public float getSpeed() {
        return ((Float)this.f_19804_.m_135370_(DATA_SPEED)).floatValue();
    }

    public void setSpeed(float speed) {
        this.f_19804_.m_135381_(DATA_SPEED, (Object)Float.valueOf(speed));
    }

    public float getYaw() {
        return ((Float)this.f_19804_.m_135370_(DATA_YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.f_19804_.m_135381_(DATA_YAW, (Object)Float.valueOf(yaw));
    }

    public int getDuration() {
        return (Integer)this.f_19804_.m_135370_(DATA_DURATION);
    }

    public void setDuration(int duration) {
        this.f_19804_.m_135381_(DATA_DURATION, (Object)duration);
    }

    public MagicCircleType getMagicCircleType() {
        String type = (String)this.f_19804_.m_135370_(DATA_TYPE);
        if (type.isEmpty()) {
            return MagicCircleType.NONE;
        }
        return MagicCircleType.valueOf(type);
    }

    public void setMagicCircleType(MagicCircleType type) {
        this.f_19804_.m_135381_(DATA_TYPE, (Object)type.toString());
    }

    public static void spawn(Level level, LivingEntity caster, Vec3 pos, float scale, float speed, int duration, float yaw, MagicCircleType type, boolean canFollow) {
        if (!level.f_46443_) {
            EntityImmortalMagicCircle entity = new EntityImmortalMagicCircle(level);
            entity.caster = caster;
            entity.canFollow = canFollow;
            entity.setScale(scale);
            entity.setSpeed(speed);
            entity.setDuration(10 + duration);
            entity.setMagicCircleType(type);
            entity.m_146884_(pos);
            entity.setYaw(yaw);
            level.m_5594_(null, new BlockPos(pos), (SoundEvent)SoundInit.MAGIC_MATRIX_OPEN.get(), caster.m_5720_(), 1.0f, caster.m_6100_());
            level.m_7967_((Entity)entity);
        }
    }

    public static enum MagicCircleType {
        NONE,
        SPEED(0.22f, 0.76f, 0.87f, MobEffects.f_19596_, MobEffects.f_19598_),
        POWER(0.92f, 0.7f, 0.02f, MobEffects.f_19600_),
        HARMFUL(0.52f, 0.16f, 0.88f, MobEffects.f_19597_, MobEffects.f_19613_),
        BENEFICIAL(0.0f, 0.72f, 0.47f, MobEffects.f_19605_, MobEffects.f_19617_);

        public final float r;
        public final float g;
        public final float b;
        public final MobEffect[] effect;

        private MagicCircleType() {
            this.b = 1.0f;
            this.g = 1.0f;
            this.r = 1.0f;
            this.effect = new MobEffect[0];
        }

        private MagicCircleType(float r, float g, float b, MobEffect ... effect) {
            this.r = r;
            this.g = g;
            this.b = b;
            this.effect = effect;
        }
    }
}

