/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.render.effects;

import com.eeeab.eeeabsmobs.client.render.EMRenderType;
import com.eeeab.eeeabsmobs.client.render.FlatTextureRenderer;
import com.eeeab.eeeabsmobs.client.render.effects.RenderAbsBeam;
import com.eeeab.eeeabsmobs.sever.entity.effects.EntityCrimsonRay;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;

public class RenderCrimsonRay
extends RenderAbsBeam<EntityCrimsonRay> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/crimson_ray.png");
    private static final float TEXTURE_WIDTH = 256.0f;
    private static final float TEXTURE_HEIGHT = 32.0f;
    private static final float START_RADIUS = 1.2f;
    private static final float BEAM_RADIUS = 0.8f;

    public RenderCrimsonRay(EntityRendererProvider.Context mgr) {
        super(mgr, 1.2f, 0.8f);
    }

    @Override
    public ResourceLocation getTextureLocation(EntityCrimsonRay entity) {
        return TEXTURE;
    }

    @Override
    protected void renderFlatQuad(int frame, PoseStack matrixStackIn, VertexConsumer builder, int packedLightIn, boolean faceCamera) {
        float minU = 0.0f + 0.0625f * (float)frame;
        float minV = 0.0f;
        float maxU = minU + 0.0625f;
        float maxV = minV + 0.5f;
        float SIZE = 1.2f;
        PoseStack.Pose matrix$stack$entry = matrixStackIn.m_85850_();
        Matrix4f matrix4f = matrix$stack$entry.m_85861_();
        Matrix3f matrix3f = matrix$stack$entry.m_85864_();
        if (faceCamera) {
            this.drawVertex(matrix4f, matrix3f, builder, -SIZE, -SIZE, 0.0f, minU, minV, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, builder, -SIZE, SIZE, 0.0f, minU, maxV, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, builder, SIZE, SIZE, 0.0f, maxU, maxV, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, builder, SIZE, -SIZE, 0.0f, maxU, minV, packedLightIn);
        } else {
            this.drawVertex(matrix4f, matrix3f, builder, -SIZE, 0.0f, -SIZE, minU, minV, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, builder, -SIZE, 0.0f, SIZE, minU, maxV, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, builder, SIZE, 0.0f, SIZE, maxU, maxV, packedLightIn);
            this.drawVertex(matrix4f, matrix3f, builder, SIZE, 0.0f, -SIZE, maxU, minV, packedLightIn);
        }
    }

    @Override
    protected void renderStart(EntityCrimsonRay ray, int frame, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.m_85836_();
        float speed = ((float)ray.f_19797_ + delta) * 3.0f;
        matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f - ray.m_146908_() + speed));
        matrixStackIn.m_85837_(0.0, (double)0.001f, 0.0);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, false);
        matrixStackIn.m_85849_();
    }

    @Override
    protected void renderEnd(EntityCrimsonRay ray, int frame, Direction side, PoseStack matrixStackIn, VertexConsumer builder, float delta, int packedLightIn) {
        matrixStackIn.m_85836_();
        Quaternion quat = this.f_114476_.m_114470_();
        matrixStackIn.m_85845_(quat);
        matrixStackIn.m_85837_(0.0, (double)0.1f, 0.0);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.m_85849_();
        if (side == null) {
            return;
        }
        matrixStackIn.m_85836_();
        Quaternion rotation = side.m_122406_();
        rotation.m_80148_(Vector3f.f_122223_.m_122240_(90.0f));
        matrixStackIn.m_85845_(rotation);
        matrixStackIn.m_85837_(0.0, 0.0, (double)-0.01f);
        this.renderFlatQuad(frame, matrixStackIn, builder, packedLightIn, true);
        matrixStackIn.m_85849_();
    }

    @Override
    protected void drawVertex(Matrix4f matrix, Matrix3f normals, VertexConsumer vertexBuilder, float offsetX, float offsetY, float offsetZ, float textureX, float textureY, int packedLightIn) {
        vertexBuilder.m_85982_(matrix, offsetX, offsetY, offsetZ).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(textureX, textureY).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLightIn).m_85977_(normals, 1.0f, 0.0f, 1.0f).m_5752_();
    }

    public static class RenderPreAttack
    extends FlatTextureRenderer<EntityCrimsonRay.PreAttack> {
        private static final ResourceLocation TEXTURE = new ResourceLocation("eeeabsmobs", "textures/effects/crimson_ray_pre.png");
        private static final float TEXTURE_WIDTH = 256.0f;
        private static final float TEXTURE_HEIGHT = 32.0f;
        private static final float SIZE = 1.2f;

        public RenderPreAttack(EntityRendererProvider.Context context) {
            super(context);
        }

        public ResourceLocation getTextureLocation(EntityCrimsonRay.PreAttack entity) {
            return TEXTURE;
        }

        public void render(EntityCrimsonRay.PreAttack entity, float entityYaw, float delta, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
            VertexConsumer consumer = bufferIn.m_6299_(EMRenderType.getGlowingEffect(TEXTURE));
            matrixStackIn.m_85836_();
            matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(90.0f - entity.m_146908_()));
            matrixStackIn.m_85837_(0.0, (double)0.001f, 0.0);
            matrixStackIn.m_85841_(-1.2f, -1.2f, -1.2f);
            float minU = 0.0f + 0.125f * (float)entity.getPhase();
            float minV = 0.0f;
            float maxU = minU + 0.125f;
            float maxV = minV + 1.0f;
            this.renderFlatQuad(matrixStackIn, consumer, packedLightIn, 1.0f, minU, minV, maxU, maxV, 1.2f, FlatTextureRenderer.Quad.XZ);
            matrixStackIn.m_85849_();
        }
    }
}

