/*
 * Decompiled with CFR 0.152.
 */
package com.eeeab.eeeabsmobs.client.model.util;

import com.eeeab.eeeabsmobs.EEEABMobs;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

@OnlyIn(value=Dist.CLIENT)
public class EMItemModels {
    public static final String[] HAND_MODEL_ITEMS = new String[]{"guardian_axe", "immortal_staff", "netherworld_katana"};

    @SubscribeEvent
    public static void onModifyBakingResultEvent(ModelEvent.BakingCompleted event) {
        Map map = event.getModels();
        for (String item : HAND_MODEL_ITEMS) {
            ModelResourceLocation modelInventory = new ModelResourceLocation(new ResourceLocation("eeeabsmobs", item), "inventory");
            ModelResourceLocation modelHand = new ModelResourceLocation(new ResourceLocation("eeeabsmobs", item + "_in_hand"), "inventory");
            if (!map.containsKey(modelInventory) || !map.containsKey(modelHand)) {
                EEEABMobs.LOGGER.error("Registration failed! Cause: resource key is not containsKey from models...");
                return;
            }
            final BakedModel bakedModelDefault = (BakedModel)map.get(modelInventory);
            final BakedModel bakedModelHand = (BakedModel)map.get(modelHand);
            BakedModel modelWrapper = new BakedModel(){

                public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
                    return bakedModelDefault.m_213637_(state, side, rand);
                }

                public boolean m_7541_() {
                    return bakedModelDefault.m_7541_();
                }

                public boolean m_7539_() {
                    return bakedModelDefault.m_7539_();
                }

                public boolean m_7547_() {
                    return false;
                }

                public boolean m_7521_() {
                    return bakedModelDefault.m_7521_();
                }

                public TextureAtlasSprite m_6160_() {
                    return bakedModelDefault.m_6160_();
                }

                public ItemOverrides m_7343_() {
                    return bakedModelDefault.m_7343_();
                }

                public BakedModel applyTransform(ItemTransforms.TransformType cameraTransformType, PoseStack mat, boolean applyLeftHandTransform) {
                    BakedModel modelToUse = bakedModelDefault;
                    if (cameraTransformType == ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND || cameraTransformType == ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_LEFT_HAND || cameraTransformType == ItemTransforms.TransformType.THIRD_PERSON_RIGHT_HAND) {
                        modelToUse = bakedModelHand;
                    }
                    return ForgeHooksClient.handleCameraTransforms((PoseStack)mat, (BakedModel)modelToUse, (ItemTransforms.TransformType)cameraTransformType, (boolean)applyLeftHandTransform);
                }
            };
            map.put(modelInventory, modelWrapper);
        }
    }
}

