/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.raids;

import com.calculusmaster.difficultraids.data.raiderentries.RaiderEntriesHolder;
import com.calculusmaster.difficultraids.entity.DifficultRaidsEntityTypes;
import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.raids.RaidDifficultyEnemyManager;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.util.Compat;
import com.infamous.dungeons_mobs.mod.ModEntityTypes;
import com.mojang.logging.LogUtils;
import com.teamabnormals.savage_and_ravage.core.registry.SREntityTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import org.slf4j.Logger;

public class RaidEnemyRegistry {
    public static final Map<RaidDifficulty, RaidDifficultyEnemyManager> DEFAULT_WAVES = new HashMap<RaidDifficulty, RaidDifficultyEnemyManager>();
    public static final Map<RaidDifficulty, RaidDifficultyEnemyManager> CURRENT_WAVES = new HashMap<RaidDifficulty, RaidDifficultyEnemyManager>();
    public static final Set<String> REGISTERED_RAIDER_TYPES = new HashSet<String>();
    public static final String VINDICATOR = "VINDICATOR";
    public static final String EVOKER = "EVOKER";
    public static final String PILLAGER = "PILLAGER";
    public static final String WITCH = "WITCH";
    public static final String RAVAGER = "RAVAGER";
    public static final String ILLUSIONER = "ILLUSIONER";
    public static final String WARRIOR = "WARRIOR_ILLAGER";
    public static final String DART = "DART_ILLAGER";
    public static final String CONDUCTOR = "ELECTRO_ILLAGER";
    public static final String NECROMANCER = "NECROMANCER_ILLAGER";
    public static final String SHAMAN = "SHAMAN_ILLAGER";
    public static final String TANK = "TANK_ILLAGER";
    public static final String ASSASSIN = "ASSASSIN_ILLAGER";
    public static final String FROSTMAGE = "FROST_ILLAGER";
    public static final String ASHENMANCER = "ASHENMANCER_ILLAGER";
    public static final String NUAOS = "NUAOS_ELITE";
    public static final String XYDRAX = "XYDRAX_ELITE";
    public static final String MODUR = "MODUR_ELITE";
    public static final String VOLDON = "VOLDON_ELITE";
    public static final String HUNTER = "hunterillager";
    public static final String ENCHANTER = "enchanter";
    public static final String ARCHER = "ARCHER";
    public static final String SKIRMISHER = "SKIRMISHER";
    public static final String LEGIONER = "LEGIONER";
    public static final String IGNITER = "entity.illageandspillage.igniter";
    public static final String TWITTOLLAGER = "entity.illageandspillage.twittollager";
    public static final String PRESERVER = "entity.illageandspillage.preserver";
    public static final String ABSORBER = "entity.illageandspillage.absorber";
    public static final String CROCOFANG = "entity.illageandspillage.crocofang";
    public static final String MAGISPELLER = "entity.illageandspillage.magispeller";
    public static final String SPIRITCALLER = "entity.illageandspillage.spiritcaller";
    public static final String FREAKAGER = "entity.illageandspillage.freakager";
    public static final String BOSS_RANDOMIZER = "entity.illageandspillage.boss_randomizer";
    public static final String GRIEFER = "GRIEFER";
    public static final String EXECUTIONER = "EXECUTIONER";
    public static final String TRICKSTER = "TRICKSTER";
    public static final String ICEOLOGER_SR = "SR_ICEOLOGER";
    public static final String MOUNTAINEER = "mountaineer";
    public static final String ROYAL_GUARD = "royal_guard";
    public static final String GEOMANCER = "geomancer";
    public static final String ILLUSIONER_DM = "DM_ILLUSIONER";
    public static final String MAGE = "mage";
    public static final String ICEOLOGER_DM = "iceologer";
    public static final String WINDCALLER = "windcaller";
    public static final String SQUALL_GOLEM = "squall_golem";
    public static final String REDSTONE_GOLEM = "redstone_golem";
    public static final String BLADE_KNIGHT = "blade_knight";
    public static final String BEAST_TAMER = "illager_beast_tamer";
    public static final String SCAVENGER = "illager_scavenger";
    public static final String LIGHTNINGCALLER = "entity.leosillagers.lightning_caller";
    public static final String CLOWNAGER = "entity.leosillagers.clownager";
    public static final String CONFUSER = "entity.leosillagers.confuser";
    public static final String SHIELD_VINDICATOR = "entity.leosillagers.vindicator_with_shield";
    public static final String METEORITE_CALLER = "entity.leosillagers.meteorite_caller";
    public static final String SNOWOLAGER = "entity.leosillagers.snowolager";
    public static final String NECROMANCER_LEO = "entity.leosillagers.necromancer";
    public static final String SUMMONER = "entity.leosillagers.summoner";
    public static final String TROUBLEMAKER = "entity.leosillagers.troublemaker";
    private static final int[] BLANK = new int[]{0, 0, 0, 0, 0, 0, 0, 0};

    public static boolean isRaiderTypeEnabled(String raiderType) {
        return DifficultRaidsConfig.ENABLED_RAIDERS.containsKey(raiderType) && (Boolean)DifficultRaidsConfig.ENABLED_RAIDERS.get(raiderType).get() != false;
    }

    public static boolean isRaiderTypeRegistered(String raiderType) {
        return REGISTERED_RAIDER_TYPES.contains(raiderType);
    }

    public static void registerRaiders() {
        RaidEnemyRegistry.createRaiderType(ILLUSIONER, (EntityType<? extends Raider>)EntityType.f_20459_);
        RaidEnemyRegistry.createRaiderType(WARRIOR, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.WARRIOR_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(DART, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.DART_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(CONDUCTOR, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.ELECTRO_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(NECROMANCER, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.NECROMANCER_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(SHAMAN, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.SHAMAN_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(TANK, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.TANK_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(ASSASSIN, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.ASSASSIN_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(FROSTMAGE, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.FROST_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(ASHENMANCER, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.ASHENMANCER_ILLAGER.get()));
        RaidEnemyRegistry.createRaiderType(NUAOS, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get()));
        RaidEnemyRegistry.createRaiderType(XYDRAX, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get()));
        RaidEnemyRegistry.createRaiderType(MODUR, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()));
        RaidEnemyRegistry.createRaiderType(VOLDON, (EntityType<? extends Raider>)((EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get()));
        if (Compat.SAVAGE_AND_RAVAGE.isLoaded()) {
            RaidEnemyRegistry.createRaiderType(ICEOLOGER_SR, (EntityType<? extends Raider>)((EntityType)SREntityTypes.ICEOLOGER.get()));
        }
        if (Compat.DUNGEONS_MOBS.isLoaded()) {
            RaidEnemyRegistry.createRaiderType(ILLUSIONER_DM, (EntityType<? extends Raider>)((EntityType)ModEntityTypes.ILLUSIONER.get()));
        }
    }

    public static void compileWaveData(Map<ResourceLocation, RaiderEntriesHolder> data) {
        CURRENT_WAVES.clear();
        for (RaidDifficulty d : RaidDifficulty.values()) {
            if (d == RaidDifficulty.DEFAULT) continue;
            CURRENT_WAVES.put(d, new RaidDifficultyEnemyManager(DEFAULT_WAVES.get((Object)d)));
        }
        ArrayList<RaiderEntriesHolder> replaceEntries = new ArrayList<RaiderEntriesHolder>();
        ArrayList modifyEntries = new ArrayList();
        for (Map.Entry<ResourceLocation, RaiderEntriesHolder> entry : data.entrySet()) {
            boolean replace = entry.getKey().m_135827_().equals("difficultraids");
            LogUtils.getLogger().info("DifficultRaids: Organizing Raid Data for ResourceLocation{%s}, replace=%s.".formatted(entry.getKey().toString(), replace));
            RaiderEntriesHolder holder = entry.getValue();
            holder.setReplace(replace);
            (replace ? replaceEntries : modifyEntries).add(holder);
        }
        ArrayList<RaiderEntriesHolder> sequentialHolders = new ArrayList<RaiderEntriesHolder>();
        sequentialHolders.addAll(replaceEntries);
        sequentialHolders.addAll(modifyEntries);
        for (RaiderEntriesHolder holder : sequentialHolders) {
            for (Map.Entry<RaidDifficulty, Map<String, List<Integer>>> holderEntry : holder.getWaves().entrySet()) {
                RaidDifficultyEnemyManager manager = CURRENT_WAVES.get((Object)holderEntry.getKey());
                for (String raiderType : holderEntry.getValue().keySet()) {
                    manager.add(raiderType, holderEntry.getValue().get(raiderType), holder.isReplace());
                }
            }
        }
    }

    public static void printWaveData(Logger logger) {
        for (RaidDifficultyEnemyManager d : CURRENT_WAVES.values()) {
            logger.info("Raid Data: " + d.toString());
        }
    }

    private static void createRaiderType(String typeName, EntityType<? extends Raider> type) {
        Raid.RaiderType.create((String)typeName, type, (int[])BLANK);
    }

    public static void registerWaves() {
        RaidEnemyRegistry.createDefaultWavesFor(RaidDifficulty.HERO).withRaider(PILLAGER, 0, 4, 3, 3, 4, 5, 5, 3).withRaider(VINDICATOR, 0, 2, 1, 1, 2, 3, 1, 2).withRaider(WARRIOR, 0, 2, 1, 1, 2, 1, 3, 2).withRaider(SKIRMISHER, 0, 1, 1, 2, 1, 1, 1, 3).withRaider(TANK, 0, 0, 2, 0, 2, 0, 2, 1).withRaider(LEGIONER, 0, 0, 0, 1, 2, 1, 3, 3).withRaider(DART, 0, 0, 0, 1, 1, 1, 0, 0).withRaider(HUNTER, 0, 1, 2, 2, 2, 2, 2, 3).withRaider(ARCHER, 0, 2, 1, 2, 3, 3, 3, 5).withRaider(WITCH, 0, 0, 1, 0, 3, 1, 0, 2).withRaider(RAVAGER, 0, 0, 0, 1, 0, 2, 1, 2).withRaider(ILLUSIONER, 0, 0, 1, 0, 0, 0, 1, 0).withRaider(ASSASSIN, 0, 0, 0, 0, 0, 1, 0, 0).withRaider(EVOKER, 0, 0, 0, 0, 1, 0, 2, 2).withRaider(CONDUCTOR, 0, 0, 0, 0, 0, 0, 0, 1).withRaider(NECROMANCER, 0, 0, 0, 0, 1, 0, 0, 0).withRaider(FROSTMAGE, 0, 0, 0, 0, 0, 1, 0, 0).withRaider(ASHENMANCER, 0, 0, 0, 0, 0, 0, 0, 1).withRaider(SHAMAN, 0, 0, 0, 1, 0, 0, 1, 1).withRaider(ENCHANTER, 0, 0, 1, 1, 1, 1, 0, 1).withRaider(IGNITER, 0, 0, 1, 2, 2, 2, 2, 4).withRaider(TWITTOLLAGER, 0, 0, 1, 1, 2, 0, 2, 2).withRaider(PRESERVER, 0, 1, 0, 1, 2, 1, 3, 4).withRaider(ABSORBER, 0, 0, 1, 0, 1, 0, 0, 2).withRaider(CROCOFANG, 0, 0, 1, 1, 2, 3, 1, 3).withRaider(MAGISPELLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(SPIRITCALLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(FREAKAGER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(BOSS_RANDOMIZER, 0, 0, 0, 1, 0, 1, 0, 1).withRaider(GRIEFER, 0, 1, 1, 2, 2, 2, 3, 3).withRaider(EXECUTIONER, 0, 1, 1, 1, 0, 1, 2, 2).withRaider(TRICKSTER, 0, 0, 1, 0, 1, 1, 1, 2).withRaider(ICEOLOGER_SR, 0, 0, 0, 1, 0, 1, 0, 1).withRaider(MOUNTAINEER, 0, 1, 3, 1, 1, 4, 2, 5).withRaider(ROYAL_GUARD, 0, 1, 1, 1, 1, 2, 1, 2).withRaider(GEOMANCER, 0, 0, 1, 1, 0, 2, 1, 2).withRaider(ILLUSIONER_DM, 0, 0, 1, 0, 1, 1, 1, 2).withRaider(MAGE, 0, 0, 1, 1, 0, 2, 0, 2).withRaider(ICEOLOGER_DM, 0, 0, 0, 1, 0, 1, 0, 1).withRaider(WINDCALLER, 0, 0, 1, 1, 0, 2, 1, 2).withRaider(SQUALL_GOLEM, 0, 0, 1, 1, 1, 1, 0, 2).withRaider(REDSTONE_GOLEM, 0, 0, 0, 1, 0, 1, 0, 1).withRaider(BLADE_KNIGHT, 0, 0, 1, 0, 1, 0, 0, 2).withRaider(BEAST_TAMER, 0, 0, 1, 0, 1, 0, 0, 1).withRaider(SCAVENGER, 0, 1, 1, 1, 0, 1, 2, 2).withRaider(LIGHTNINGCALLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(CLOWNAGER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(CONFUSER, 0, 0, 1, 0, 1, 1, 1, 2).withRaider(SHIELD_VINDICATOR, 0, 1, 0, 1, 1, 1, 0, 1).withRaider(METEORITE_CALLER, 0, 0, 0, 0, 0, 0, 0, 1).withRaider(SNOWOLAGER, 0, 0, 0, 1, 0, 1, 0, 1).withRaider(NECROMANCER_LEO, 0, 0, 0, 0, 0, 1, 0, 1).withRaider(SUMMONER, 0, 0, 0, 0, 0, 1, 0, 1).withRaider(TROUBLEMAKER, 0, 1, 0, 1, 1, 1, 0, 1).withEliteWave(5, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get()).withEliteWave(7, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get()).registerDefault();
        RaidEnemyRegistry.createDefaultWavesFor(RaidDifficulty.LEGEND).withRaider(PILLAGER, 0, 4, 3, 3, 4, 5, 5, 3).withRaider(VINDICATOR, 0, 2, 3, 1, 3, 4, 2, 3).withRaider(WARRIOR, 0, 2, 2, 3, 3, 1, 4, 4).withRaider(SKIRMISHER, 0, 2, 2, 2, 3, 2, 2, 3).withRaider(TANK, 0, 0, 2, 1, 2, 1, 2, 1).withRaider(LEGIONER, 0, 1, 1, 2, 2, 3, 3, 4).withRaider(DART, 0, 0, 2, 1, 2, 1, 3, 0).withRaider(HUNTER, 0, 1, 3, 2, 3, 2, 3, 4).withRaider(ARCHER, 0, 2, 2, 4, 3, 4, 3, 6).withRaider(WITCH, 0, 1, 1, 2, 3, 1, 2, 2).withRaider(RAVAGER, 0, 0, 1, 1, 0, 2, 1, 2).withRaider(ILLUSIONER, 0, 0, 1, 1, 1, 0, 1, 0).withRaider(ASSASSIN, 0, 1, 1, 1, 1, 1, 1, 1).withRaider(EVOKER, 0, 0, 2, 2, 1, 2, 2, 2).withRaider(CONDUCTOR, 0, 0, 1, 0, 0, 0, 1, 1).withRaider(NECROMANCER, 0, 0, 0, 2, 0, 1, 2, 1).withRaider(FROSTMAGE, 0, 0, 0, 0, 2, 2, 0, 1).withRaider(ASHENMANCER, 0, 0, 0, 1, 0, 1, 0, 1).withRaider(SHAMAN, 0, 0, 1, 1, 1, 2, 2, 3).withRaider(ENCHANTER, 0, 1, 2, 0, 0, 2, 0, 2).withRaider(IGNITER, 0, 2, 2, 3, 2, 3, 2, 5).withRaider(TWITTOLLAGER, 0, 1, 2, 1, 2, 1, 2, 3).withRaider(PRESERVER, 0, 1, 1, 2, 2, 2, 4, 4).withRaider(ABSORBER, 0, 0, 1, 1, 2, 0, 1, 2).withRaider(CROCOFANG, 0, 1, 2, 1, 2, 3, 2, 4).withRaider(MAGISPELLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(SPIRITCALLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(FREAKAGER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(BOSS_RANDOMIZER, 0, 0, 1, 0, 0, 1, 1, 1).withRaider(GRIEFER, 0, 1, 2, 2, 3, 2, 3, 3).withRaider(EXECUTIONER, 0, 1, 2, 1, 1, 2, 2, 3).withRaider(TRICKSTER, 0, 0, 1, 0, 1, 2, 2, 3).withRaider(ICEOLOGER_SR, 0, 0, 1, 2, 0, 2, 0, 2).withRaider(MOUNTAINEER, 0, 2, 3, 2, 2, 5, 2, 6).withRaider(ROYAL_GUARD, 0, 1, 2, 2, 1, 4, 1, 4).withRaider(GEOMANCER, 0, 1, 1, 2, 1, 2, 1, 3).withRaider(ILLUSIONER_DM, 0, 0, 1, 2, 1, 3, 1, 3).withRaider(MAGE, 0, 1, 1, 1, 0, 2, 1, 3).withRaider(ICEOLOGER_DM, 0, 0, 1, 2, 0, 2, 0, 2).withRaider(WINDCALLER, 0, 1, 1, 2, 1, 2, 1, 3).withRaider(SQUALL_GOLEM, 0, 1, 1, 2, 1, 2, 1, 2).withRaider(REDSTONE_GOLEM, 0, 1, 1, 1, 1, 1, 1, 1).withRaider(BLADE_KNIGHT, 0, 0, 1, 1, 1, 0, 1, 2).withRaider(BEAST_TAMER, 0, 0, 1, 0, 1, 1, 1, 1).withRaider(SCAVENGER, 0, 1, 2, 1, 1, 2, 2, 3).withRaider(LIGHTNINGCALLER, 0, 0, 0, 0, 0, 0, 0, 1).withRaider(CLOWNAGER, 0, 0, 0, 0, 0, 1, 0, 0).withRaider(CONFUSER, 0, 0, 1, 2, 1, 3, 1, 3).withRaider(SHIELD_VINDICATOR, 0, 1, 1, 2, 2, 2, 2, 3).withRaider(METEORITE_CALLER, 0, 0, 1, 0, 0, 1, 0, 1).withRaider(SNOWOLAGER, 0, 0, 1, 2, 0, 2, 0, 2).withRaider(NECROMANCER_LEO, 0, 0, 1, 1, 0, 1, 0, 2).withRaider(SUMMONER, 0, 0, 0, 1, 1, 1, 2, 1).withRaider(TROUBLEMAKER, 0, 1, 1, 2, 2, 1, 1, 1).withEliteWave(3, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get()).withEliteWave(5, (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(7, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).registerDefault();
        RaidEnemyRegistry.createDefaultWavesFor(RaidDifficulty.MASTER).withRaider(PILLAGER, 0, 5, 6, 5, 6, 6, 5, 5).withRaider(VINDICATOR, 0, 3, 2, 3, 3, 2, 3, 4).withRaider(WARRIOR, 0, 3, 1, 3, 3, 2, 4, 4).withRaider(SKIRMISHER, 0, 2, 2, 4, 3, 5, 2, 5).withRaider(TANK, 0, 2, 2, 2, 3, 3, 3, 3).withRaider(LEGIONER, 0, 1, 2, 3, 2, 4, 3, 5).withRaider(DART, 0, 0, 2, 2, 2, 2, 3, 4).withRaider(HUNTER, 0, 3, 4, 4, 4, 5, 3, 4).withRaider(ARCHER, 0, 3, 3, 5, 4, 5, 5, 7).withRaider(WITCH, 0, 1, 3, 5, 4, 5, 3, 3).withRaider(RAVAGER, 0, 1, 1, 1, 0, 3, 1, 3).withRaider(ILLUSIONER, 0, 1, 1, 2, 1, 1, 2, 3).withRaider(ASSASSIN, 0, 2, 2, 2, 2, 2, 2, 2).withRaider(EVOKER, 0, 1, 2, 3, 4, 1, 1, 3).withRaider(CONDUCTOR, 0, 1, 2, 0, 1, 2, 2, 3).withRaider(NECROMANCER, 0, 1, 0, 3, 1, 2, 0, 3).withRaider(ASHENMANCER, 0, 1, 0, 2, 1, 2, 0, 2).withRaider(FROSTMAGE, 0, 1, 0, 0, 1, 2, 4, 3).withRaider(SHAMAN, 0, 2, 2, 2, 2, 3, 3, 3).withRaider(ENCHANTER, 0, 1, 1, 1, 1, 1, 1, 3).withRaider(IGNITER, 0, 3, 2, 4, 3, 4, 3, 6).withRaider(TWITTOLLAGER, 0, 1, 3, 1, 3, 2, 2, 3).withRaider(PRESERVER, 0, 2, 2, 2, 2, 2, 4, 4).withRaider(ABSORBER, 0, 1, 1, 1, 2, 1, 1, 3).withRaider(CROCOFANG, 0, 2, 2, 3, 2, 4, 2, 5).withRaider(MAGISPELLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(SPIRITCALLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(FREAKAGER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(BOSS_RANDOMIZER, 0, 0, 1, 1, 0, 1, 1, 1).withRaider(GRIEFER, 0, 2, 3, 2, 3, 3, 3, 4).withRaider(EXECUTIONER, 0, 2, 2, 2, 3, 2, 3, 4).withRaider(TRICKSTER, 0, 1, 2, 1, 2, 2, 2, 3).withRaider(ICEOLOGER_SR, 0, 1, 2, 3, 1, 3, 1, 3).withRaider(MOUNTAINEER, 0, 3, 4, 5, 2, 7, 4, 7).withRaider(ROYAL_GUARD, 0, 2, 2, 3, 2, 4, 3, 5).withRaider(GEOMANCER, 0, 2, 1, 3, 2, 3, 1, 3).withRaider(ILLUSIONER_DM, 0, 1, 2, 2, 2, 3, 2, 3).withRaider(MAGE, 0, 1, 2, 2, 1, 3, 1, 3).withRaider(ICEOLOGER_DM, 0, 1, 2, 3, 1, 3, 1, 3).withRaider(WINDCALLER, 0, 1, 2, 3, 2, 3, 2, 3).withRaider(SQUALL_GOLEM, 0, 1, 2, 2, 2, 3, 2, 3).withRaider(REDSTONE_GOLEM, 0, 1, 1, 2, 1, 2, 1, 2).withRaider(BLADE_KNIGHT, 0, 1, 1, 1, 1, 1, 1, 2).withRaider(BEAST_TAMER, 0, 1, 2, 0, 2, 1, 2, 1).withRaider(SCAVENGER, 0, 2, 2, 2, 3, 2, 3, 4).withRaider(LIGHTNINGCALLER, 0, 0, 0, 1, 0, 0, 0, 1).withRaider(CLOWNAGER, 0, 0, 1, 0, 0, 1, 0, 0).withRaider(CONFUSER, 0, 1, 1, 2, 1, 3, 1, 3).withRaider(SHIELD_VINDICATOR, 0, 2, 2, 2, 2, 3, 2, 3).withRaider(METEORITE_CALLER, 0, 0, 1, 1, 1, 2, 0, 2).withRaider(SNOWOLAGER, 0, 1, 2, 3, 1, 3, 1, 3).withRaider(NECROMANCER_LEO, 0, 1, 1, 1, 1, 1, 1, 2).withRaider(SUMMONER, 0, 1, 1, 1, 2, 2, 2, 2).withRaider(TROUBLEMAKER, 0, 3, 2, 3, 2, 3, 2, 3).withEliteWave(1, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get()).withEliteWave(3, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(5, (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(6, (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(7, (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).registerDefault();
        RaidEnemyRegistry.createDefaultWavesFor(RaidDifficulty.GRANDMASTER).withRaider(PILLAGER, 0, 6, 7, 6, 7, 7, 6, 6).withRaider(VINDICATOR, 0, 4, 3, 4, 4, 3, 4, 5).withRaider(WARRIOR, 0, 4, 2, 4, 4, 3, 5, 5).withRaider(SKIRMISHER, 0, 2, 2, 4, 3, 5, 2, 5).withRaider(TANK, 0, 2, 2, 3, 4, 4, 4, 4).withRaider(LEGIONER, 0, 1, 2, 3, 2, 4, 3, 5).withRaider(DART, 0, 0, 2, 2, 2, 2, 3, 4).withRaider(HUNTER, 0, 3, 4, 4, 4, 5, 3, 4).withRaider(ARCHER, 0, 3, 3, 5, 4, 5, 5, 7).withRaider(WITCH, 0, 1, 3, 5, 4, 5, 3, 3).withRaider(RAVAGER, 0, 1, 1, 1, 0, 3, 1, 3).withRaider(ILLUSIONER, 0, 0, 1, 2, 1, 1, 2, 3).withRaider(ASSASSIN, 0, 2, 2, 2, 2, 2, 2, 2).withRaider(EVOKER, 0, 1, 2, 3, 4, 1, 1, 3).withRaider(CONDUCTOR, 0, 1, 2, 0, 1, 2, 2, 3).withRaider(NECROMANCER, 0, 1, 0, 3, 1, 2, 0, 3).withRaider(ASHENMANCER, 0, 1, 1, 3, 1, 3, 1, 3).withRaider(FROSTMAGE, 0, 1, 0, 0, 1, 2, 4, 3).withRaider(SHAMAN, 0, 2, 2, 2, 2, 3, 3, 3).withRaider(ENCHANTER, 0, 1, 1, 1, 1, 1, 1, 3).withRaider(IGNITER, 0, 3, 2, 4, 3, 4, 3, 6).withRaider(TWITTOLLAGER, 0, 1, 3, 1, 3, 2, 2, 3).withRaider(PRESERVER, 0, 2, 2, 2, 2, 2, 4, 4).withRaider(ABSORBER, 0, 1, 1, 1, 2, 1, 1, 3).withRaider(CROCOFANG, 0, 2, 2, 3, 2, 4, 2, 5).withRaider(MAGISPELLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(SPIRITCALLER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(FREAKAGER, 0, 0, 0, 0, 0, 0, 0, 0).withRaider(BOSS_RANDOMIZER, 0, 1, 1, 1, 1, 1, 1, 1).withRaider(GRIEFER, 0, 2, 3, 2, 3, 3, 3, 4).withRaider(EXECUTIONER, 0, 2, 2, 2, 3, 2, 3, 4).withRaider(TRICKSTER, 0, 1, 2, 1, 2, 2, 2, 3).withRaider(ICEOLOGER_SR, 0, 1, 2, 3, 1, 3, 1, 3).withRaider(MOUNTAINEER, 0, 3, 4, 5, 2, 7, 4, 7).withRaider(ROYAL_GUARD, 0, 2, 2, 3, 2, 4, 3, 5).withRaider(GEOMANCER, 0, 2, 1, 3, 2, 3, 1, 3).withRaider(ILLUSIONER_DM, 0, 1, 2, 2, 2, 3, 2, 3).withRaider(MAGE, 0, 1, 2, 2, 1, 3, 1, 3).withRaider(ICEOLOGER_DM, 0, 1, 2, 3, 1, 3, 1, 3).withRaider(WINDCALLER, 0, 1, 2, 3, 2, 3, 2, 3).withRaider(SQUALL_GOLEM, 0, 1, 2, 2, 2, 3, 2, 3).withRaider(REDSTONE_GOLEM, 0, 1, 1, 3, 1, 3, 1, 3).withRaider(BLADE_KNIGHT, 0, 1, 1, 1, 1, 1, 1, 2).withRaider(BEAST_TAMER, 0, 1, 2, 0, 2, 1, 2, 1).withRaider(SCAVENGER, 0, 2, 2, 2, 3, 2, 3, 4).withRaider(LIGHTNINGCALLER, 0, 0, 0, 1, 1, 0, 0, 1).withRaider(CLOWNAGER, 0, 0, 1, 0, 0, 1, 1, 0).withRaider(CONFUSER, 0, 1, 1, 2, 1, 3, 1, 3).withRaider(SHIELD_VINDICATOR, 0, 2, 2, 2, 2, 3, 2, 3).withRaider(METEORITE_CALLER, 0, 0, 1, 1, 1, 2, 0, 2).withRaider(SNOWOLAGER, 0, 1, 2, 3, 1, 3, 1, 3).withRaider(NECROMANCER_LEO, 0, 1, 1, 1, 1, 1, 1, 2).withRaider(SUMMONER, 0, 1, 1, 1, 2, 3, 2, 2).withRaider(TROUBLEMAKER, 0, 3, 2, 3, 2, 3, 2, 3).withEliteWave(1, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(2, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(3, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(4, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(5, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(6, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).withEliteWave(7, (EntityType)DifficultRaidsEntityTypes.NUAOS_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.VOLDON_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.XYDRAX_ELITE.get(), (EntityType)DifficultRaidsEntityTypes.MODUR_ELITE.get()).registerDefault();
    }

    public static boolean isEliteWave(RaidDifficulty raidDifficulty, int wave) {
        return CURRENT_WAVES.get((Object)raidDifficulty).isEliteWave(wave);
    }

    public static EntityType<?> getRandomElite(RaidDifficulty raidDifficulty, int wave) {
        List<EntityType<?>> pool = CURRENT_WAVES.get((Object)raidDifficulty).getElites(wave);
        if (pool.isEmpty()) {
            return null;
        }
        if (pool.size() == 1) {
            return pool.get(0);
        }
        return pool.get(new Random().nextInt(pool.size()));
    }

    public static List<Integer> getWaves(RaidDifficulty raidDifficulty, String raiderType) {
        return CURRENT_WAVES.get((Object)raidDifficulty).getWaves().getOrDefault(raiderType, Arrays.stream(BLANK).boxed().collect(Collectors.toList()));
    }

    public static RaidDifficultyEnemyManager createDefaultWavesFor(RaidDifficulty raidDifficulty) {
        return new RaidDifficultyEnemyManager(raidDifficulty);
    }
}

