/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.mixins;

import com.calculusmaster.difficultraids.raids.RaidDifficulty;
import com.calculusmaster.difficultraids.raids.RaidEnemyRegistry;
import com.calculusmaster.difficultraids.raids.RaidLoot;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.util.DifficultRaidsUtil;
import com.mojang.logging.LogUtils;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Raid.class})
public abstract class RaidMixin {
    private int players;
    private AABB validRaidArea;
    @Mutable
    @Shadow
    @Final
    private int f_37686_;
    @Shadow
    private int f_37681_;
    @Shadow
    @Final
    private ServerLevel f_37675_;
    @Shadow
    @Final
    private RandomSource f_37685_;
    @Shadow
    private BlockPos f_37674_;
    @Shadow
    @Final
    private Set<UUID> f_37672_;
    @Shadow
    private long f_37673_;
    @Shadow
    @Final
    private ServerBossEvent f_37682_;
    @Shadow
    private int f_37688_;
    private static final Logger LOGGER = LogUtils.getLogger();

    @Shadow
    public abstract boolean m_37767_();

    @Shadow
    public abstract boolean m_37768_();

    @Shadow
    public abstract void m_37713_(int var1, Raider var2, @Nullable BlockPos var3, boolean var4);

    @Shadow
    public abstract int m_37771_();

    @Shadow
    public abstract int m_37773_();

    @Shadow
    public abstract int m_37778_();

    @Shadow
    public abstract Set<Raider> m_150221_();

    @Shadow
    public abstract boolean m_37706_();

    @Shadow
    public abstract int m_37724_(Difficulty var1);

    @Unique
    private void difficultRaids$initializeValidRaidArea() {
        this.validRaidArea = new AABB(this.f_37674_).m_82400_(Math.sqrt(9216.0));
        this.players = this.f_37675_.m_45976_(Player.class, this.validRaidArea).size();
    }

    @Inject(at={@At(value="TAIL")}, method={"absorbBadOmen"})
    private void difficultraids_raidStart(Player p_37729_, CallbackInfo callbackInfo) {
        this.difficultRaids$initializeValidRaidArea();
        this.f_37686_ = this.m_37724_(this.f_37675_.m_46791_());
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void difficultraids_highlightRemainingRaiders(CallbackInfo callback) {
        if (this.f_37673_ % 20L * 2L == 0L && this.m_37778_() <= (Integer)DifficultRaidsConfig.HIGHLIGHT_THRESHOLD.get()) {
            this.m_150221_().stream().filter(LivingEntity::m_6084_).filter(r -> !r.m_21023_(MobEffects.f_19619_)).forEach(r -> r.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 60, 1, false, false)));
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    private void difficultraids_addDifficultyToEventBar(CallbackInfo callback) {
        RaidDifficulty raidDifficulty = this.difficultraids$getRaidDifficulty();
        String title = this.f_37682_.m_18861_().getString();
        if (this.f_37673_ % 20L == 0L && title.toLowerCase().contains("raid") && !title.toLowerCase().contains(raidDifficulty.getFormattedName().toLowerCase())) {
            MutableComponent current = Component.m_237113_((String)this.f_37682_.m_18861_().getString());
            MutableComponent additions = Component.m_237119_();
            if (((Boolean)DifficultRaidsConfig.INSANITY_MODE.get()).booleanValue()) {
                additions.m_7220_((Component)Component.m_237113_((String)"Insane ").m_130940_(ChatFormatting.RED));
            }
            additions.m_130946_(raidDifficulty.getFormattedName() + " ");
            MutableComponent wave = (Boolean)DifficultRaidsConfig.SHOW_WAVE_INFORMATION.get() != false ? Component.m_237113_((String)(" (Wave " + this.m_37771_() + " of " + this.f_37686_ + ")")).m_130940_(ChatFormatting.GRAY) : Component.m_237119_();
            this.f_37682_.m_6456_((Component)additions.m_7220_((Component)current).m_7220_((Component)wave));
        }
        if (this.m_37706_() && this.f_37688_ % 20 == 0 && title.startsWith(Component.m_237115_((String)"event.minecraft.raid").m_130946_(" - ").getString())) {
            this.f_37682_.m_6456_((Component)Component.m_237113_((String)(raidDifficulty.getFormattedName() + " ")).m_130946_(title));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnGroup"})
    private void difficultraids_spawnGroup(BlockPos pos, CallbackInfo callbackInfo) {
        if (this.validRaidArea == null) {
            this.difficultRaids$initializeValidRaidArea();
        }
        List participants = this.f_37675_.m_45976_(Player.class, this.validRaidArea);
        this.players = participants.size();
    }

    @Inject(at={@At(value="TAIL")}, method={"spawnGroup"})
    private void difficultraids_spawnElite(BlockPos spawnPos, CallbackInfo callback) {
        RaidDifficulty raidDifficulty = this.difficultraids$getRaidDifficulty();
        int wave = this.m_37771_();
        if (!raidDifficulty.isDefault() && ((Boolean)raidDifficulty.config().elitesEnabled.get()).booleanValue() && RaidEnemyRegistry.isEliteWave(raidDifficulty, wave)) {
            Entity elite;
            EntityType<?> eliteType = RaidEnemyRegistry.getRandomElite(raidDifficulty, wave);
            Entity entity = elite = eliteType == null ? null : eliteType.m_20615_((Level)this.f_37675_);
            if (elite instanceof Raider) {
                Raider raider = (Raider)elite;
                this.m_37713_(wave, raider, spawnPos, false);
            } else {
                LOGGER.error("Failed to spawn Raid Elite! {EntityType: " + (eliteType == null ? "null" : eliteType.m_147048_()) + "}, Wave {" + wave + "}, Difficulty {" + this.f_37675_.m_46791_() + "}");
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getDefaultNumSpawns"}, cancellable=true)
    private void difficultraids_getDefaultNumSpawns(Raid.RaiderType raiderType, int groupsSpawned, boolean spawnBonusGroup, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        RaidDifficulty raidDifficulty = this.difficultraids$getRaidDifficulty();
        if (!raidDifficulty.isDefault()) {
            boolean isRegistered = RaidEnemyRegistry.isRaiderTypeRegistered(raiderType.toString());
            boolean isEnabled = RaidEnemyRegistry.isRaiderTypeEnabled(raiderType.toString());
            if (raiderType.toString().equalsIgnoreCase("thebluemengroup")) {
                callbackInfoReturnable.setReturnValue((Object)0);
            } else if (raiderType.toString().equals("illusioner")) {
                callbackInfoReturnable.setReturnValue((Object)0);
            } else if (isRegistered && !isEnabled) {
                callbackInfoReturnable.setReturnValue((Object)0);
            } else if (isRegistered) {
                int waveIndex;
                List<Integer> spawnsPerWave = RaidEnemyRegistry.getWaves(raidDifficulty, raiderType.toString());
                int n = waveIndex = spawnBonusGroup ? this.f_37686_ : groupsSpawned;
                int count = waveIndex >= spawnsPerWave.size() ? (DifficultRaidsConfig.OVERFLOW_MODE.get() == DifficultRaidsUtil.OverflowHandlingMode.ZERO ? 0 : spawnsPerWave.get(spawnsPerWave.size() - 1)) : spawnsPerWave.get(waveIndex);
                if (((Boolean)DifficultRaidsConfig.INSANITY_MODE.get()).booleanValue()) {
                    count = (int)((double)count * (Double)DifficultRaidsConfig.INSANITY_COUNT_MULTIPLIER.get());
                }
                callbackInfoReturnable.setReturnValue((Object)count);
            } else if (((Boolean)DifficultRaidsConfig.RESTRICTIVE_MODE.get()).booleanValue()) {
                callbackInfoReturnable.setReturnValue((Object)0);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getPotentialBonusSpawns"}, cancellable=true)
    private void difficultraids_getPotentialBonusSpawns(Raid.RaiderType raiderType, RandomSource random, int groupsSpawned, DifficultyInstance difficultyInstance, boolean shouldSpawnBonusGroup, CallbackInfoReturnable<Integer> callbackInfoReturnable) {
        if (!this.difficultraids$getRaidDifficulty().isDefault()) {
            callbackInfoReturnable.setReturnValue((Object)0);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getNumGroups"}, cancellable=true)
    private void difficultraids_getWaveCounts(Difficulty pDifficulty, CallbackInfoReturnable<Integer> cir) {
        RaidDifficulty rd = this.difficultraids$getRaidDifficulty();
        if (!rd.isDefault()) {
            cir.setReturnValue((Object)(switch (pDifficulty) {
                default -> throw new IncompatibleClassChangeError();
                case Difficulty.PEACEFUL -> 0;
                case Difficulty.EASY -> (Integer)DifficultRaidsConfig.WAVE_COUNT_EASY.get();
                case Difficulty.NORMAL -> (Integer)DifficultRaidsConfig.WAVE_COUNT_NORMAL.get();
                case Difficulty.HARD -> (Integer)DifficultRaidsConfig.WAVE_COUNT_HARD.get();
            }));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"stop"})
    public void difficultraids_grantRewards(CallbackInfo callbackInfo) {
        RaidDifficulty raidDifficulty = this.difficultraids$getRaidDifficulty();
        if (this.m_37767_() && !raidDifficulty.isDefault()) {
            LOGGER.info("DifficultRaids: Generating " + raidDifficulty.getFormattedName() + " Raid Loot!");
            LootTables lootTables = this.f_37675_.m_7654_().m_129898_();
            LootTable valuablesLT = lootTables.m_79217_(switch (raidDifficulty) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> RaidLoot.HERO_VALUABLES;
                case RaidDifficulty.LEGEND -> RaidLoot.LEGEND_VALUABLES;
                case RaidDifficulty.MASTER -> RaidLoot.MASTER_VALUABLES;
                case RaidDifficulty.GRANDMASTER -> RaidLoot.GRANDMASTER_VALUABLES;
            });
            LootTables lootTables2 = this.f_37675_.m_7654_().m_129898_();
            LootTable magicLT = lootTables2.m_79217_(switch (raidDifficulty) {
                default -> throw new IncompatibleClassChangeError();
                case RaidDifficulty.DEFAULT, RaidDifficulty.HERO -> RaidLoot.HERO_MAGIC;
                case RaidDifficulty.LEGEND -> RaidLoot.LEGEND_MAGIC;
                case RaidDifficulty.MASTER -> RaidLoot.MASTER_MAGIC;
                case RaidDifficulty.GRANDMASTER -> RaidLoot.GRANDMASTER_MAGIC;
            });
            BlockPos valuablesPos = this.difficultRaids$spawnLootChest("Valuables", valuablesLT);
            BlockPos magicPos = this.difficultRaids$spawnLootChest("Magic", magicLT);
            if (((Boolean)DifficultRaidsConfig.INSANITY_MODE.get()).booleanValue()) {
                int i = 0;
                while ((double)i < (Double)DifficultRaidsConfig.INSANITY_COUNT_MULTIPLIER.get() - 1.0) {
                    this.difficultRaids$spawnLootChest("Valuables", valuablesLT);
                    this.difficultRaids$spawnLootChest("Magic", magicLT);
                    ++i;
                }
            }
            int vX = valuablesPos.m_123341_();
            int vY = valuablesPos.m_123342_();
            int vZ = valuablesPos.m_123343_();
            int mX = magicPos.m_123341_();
            int mY = magicPos.m_123342_();
            int mZ = magicPos.m_123343_();
            this.f_37672_.stream().map(uuid -> this.f_37675_.m_46003_(uuid)).filter(Objects::nonNull).forEach(p -> p.m_213846_((Component)Component.m_237113_((String)"The Villagers have granted you gifts at (%s, %s, %s) and (%s, %s, %s)!%s".formatted(vX, vY, vZ, mX, mY, mZ, (Boolean)DifficultRaidsConfig.INSANITY_MODE.get() != false ? " Your insanity has granted you additional gifts!" : ""))));
            LOGGER.info("DifficultRaids: Spawned " + raidDifficulty.getFormattedName() + " Raid Loot (V: %s, %s, %s | M: %s, %s, %s)!".formatted(vX, vY, vZ, mX, mY, mZ));
        }
    }

    @Unique
    private BlockPos difficultRaids$spawnLootChest(String type, LootTable table) {
        Function<Integer, Integer> randomizer = s -> s + (3 - this.f_37685_.m_188503_(7));
        BlockPos pos = new BlockPos(randomizer.apply(this.f_37674_.m_123341_()).intValue(), this.f_37674_.m_123342_() + 5, randomizer.apply(this.f_37674_.m_123343_()).intValue());
        while (!this.f_37675_.m_8055_(pos).m_60795_()) {
            pos = pos.m_7918_(randomizer.apply(pos.m_123341_()).intValue(), 1, randomizer.apply(pos.m_123343_()).intValue());
        }
        this.f_37675_.m_7731_(pos, Blocks.f_50087_.m_49966_(), 2);
        BlockEntity blockEntity = this.f_37675_.getExistingBlockEntity(pos);
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            LootContext context = new LootContext.Builder(this.f_37675_).m_78963_(this.f_37675_.m_46791_() == Difficulty.HARD ? 1.0f : 0.0f).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78975_(LootContextParamSets.f_81411_);
            table.m_79123_(container, context);
            container.m_6596_();
        } else {
            LOGGER.warn("Could not find container for " + type + " Raid Loot at {" + pos.m_123341_() + ", " + pos.m_123342_() + ", " + pos.m_123343_() + "}!");
        }
        return pos;
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"joinRaid"}, ordinal=0, argsOnly=true)
    private BlockPos difficultraids_randomizeSpawnPos(BlockPos spawnPos) {
        if (spawnPos != null) {
            BlockPos spawnOffset;
            int tries = 0;
            while (!this.f_37675_.m_8055_(spawnOffset = spawnPos.m_7918_(this.f_37685_.m_188503_(7) - 3, 0, this.f_37685_.m_188503_(7) - 3)).m_60795_() && ++tries < 3) {
            }
            return spawnOffset;
        }
        return spawnPos;
    }

    @ModifyVariable(at=@At(value="HEAD"), method={"joinRaid"}, ordinal=0, argsOnly=true)
    private Raider difficultraids_boostRaiderFromPlayerCount(Raider defaultRaider) {
        float perPlayerHealthBoost = ((Double)this.difficultraids$getRaidDifficulty().config().playerHealthBoostAmount.get()).floatValue();
        float healthBoost = perPlayerHealthBoost * (float)(this.players - 1);
        AttributeModifier healthBoostModifier = new AttributeModifier("RAID_PLAYER_COUNT_HEALTH_BOOST", (double)healthBoost, AttributeModifier.Operation.ADDITION);
        AttributeInstance health = defaultRaider.m_21051_(Attributes.f_22276_);
        if (health != null) {
            health.m_22125_(healthBoostModifier);
        }
        return defaultRaider;
    }

    @Unique
    public RaidDifficulty difficultraids$getRaidDifficulty() {
        return RaidDifficulty.get(this.m_37773_());
    }
}

