/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.events;

import com.calculusmaster.difficultraids.commands.AdvanceRaidWaveCommand;
import com.calculusmaster.difficultraids.commands.DumpRaidWavesCommand;
import com.calculusmaster.difficultraids.commands.FreezeRaidersCommand;
import com.calculusmaster.difficultraids.commands.PrintRaidersCommand;
import com.calculusmaster.difficultraids.commands.SetRaidDifficultyCommand;
import com.calculusmaster.difficultraids.commands.ToggleInsanityModeCommand;
import com.calculusmaster.difficultraids.entity.entities.component.VoldonFamiliarEntity;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractIllagerVariant;
import com.calculusmaster.difficultraids.entity.entities.elite.ModurEliteEntity;
import com.calculusmaster.difficultraids.entity.entities.elite.NuaosEliteEntity;
import com.calculusmaster.difficultraids.entity.entities.elite.VoldonEliteEntity;
import com.calculusmaster.difficultraids.entity.entities.elite.XydraxEliteEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.AshenmancerIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.AssassinIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.DartIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.ElectroIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.FrostIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.NecromancerIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.ShamanIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.TankIllagerEntity;
import com.calculusmaster.difficultraids.entity.entities.raider.WarriorIllagerEntity;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEffects;
import com.calculusmaster.difficultraids.setup.DifficultRaidsEnchantments;
import com.calculusmaster.difficultraids.util.Compat;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.PlayLevelSoundEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.EntityMobGriefingEvent;
import net.minecraftforge.event.entity.EntityStruckByLightningEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.MobEffectEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import tallestegg.guardvillagers.entities.Guard;

@Mod.EventBusSubscriber(modid="difficultraids")
public class DRForgeBusEvents {
    private static final TargetingConditions NECROMANCER_MINION_CHARGE_TARGETING = TargetingConditions.m_148353_().m_26893_().m_148355_().m_26883_(50.0);

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        SetRaidDifficultyCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PrintRaidersCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        AdvanceRaidWaveCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ToggleInsanityModeCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DumpRaidWavesCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        FreezeRaidersCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onSoundPlayedAtPosition(PlayLevelSoundEvent.AtPosition event) {
        ServerLevel sl;
        Level level;
        BlockPos pos = new BlockPos(event.getPosition().m_7096_(), event.getPosition().m_7098_(), event.getPosition().m_7094_());
        if (event.getSource().equals((Object)SoundSource.WEATHER) && (level = event.getLevel()) instanceof ServerLevel && (sl = (ServerLevel)level).m_8832_(pos) != null) {
            if (event.getSound().equals(SoundEvents.f_12090_)) {
                event.setNewVolume(event.getOriginalVolume() / 100.0f);
            } else if (event.getSound().equals(SoundEvents.f_12089_)) {
                event.setNewVolume(event.getOriginalVolume() / 2.0f);
            }
        }
    }

    @SubscribeEvent
    public static void addSpawn(EntityJoinLevelEvent event) {
        float defaultMaxDistance = 16.0f;
        float defaultWalkSpeedModifier = 0.8f;
        float defaultSprintSpeedModifier = 0.85f;
        Entity entity = event.getEntity();
        if (entity instanceof AbstractVillager) {
            AbstractVillager villager = (AbstractVillager)entity;
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, WarriorIllagerEntity.class, 16.0f, (double)0.8f, (double)0.85f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, DartIllagerEntity.class, 18.0f, (double)0.8f, (double)0.85f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, ElectroIllagerEntity.class, 16.0f, (double)0.6f, 0.75));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, NecromancerIllagerEntity.class, 12.0f, 0.5, 0.6500000357627869));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, ShamanIllagerEntity.class, 6.0f, 0.5, 0.6500000357627869));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, TankIllagerEntity.class, 16.0f, 0.9000000357627869, (double)0.85f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, AssassinIllagerEntity.class, 2.5f, 0.9000000357627869, 0.9500000476837158));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, FrostIllagerEntity.class, 16.0f, (double)0.6f, 0.75));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, NuaosEliteEntity.class, 16.0f, (double)0.4f, (double)0.425f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, XydraxEliteEntity.class, 16.0f, (double)0.4f, (double)0.425f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, ModurEliteEntity.class, 16.0f, (double)0.4f, (double)0.425f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, VoldonEliteEntity.class, 16.0f, (double)0.4f, (double)0.425f));
            villager.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)villager, VoldonFamiliarEntity.class, 8.0f, (double)0.6f, 0.6500000357627869));
        }
        if (Compat.GUARD_VILLAGERS.isLoaded() && (entity = event.getEntity()) instanceof AbstractIllagerVariant) {
            AbstractIllagerVariant illager = (AbstractIllagerVariant)entity;
            int priority = 3;
            if (illager instanceof AssassinIllagerEntity || illager instanceof DartIllagerEntity) {
                priority = 2;
            }
            if (illager instanceof AbstractEvokerVariant) {
                AbstractEvokerVariant spellcaster = (AbstractEvokerVariant)illager;
                spellcaster.f_21346_.m_25352_(priority, (Goal)new NearestAttackableTargetGoal((Mob)illager, Guard.class, true).m_26146_(300));
            } else {
                illager.f_21346_.m_25352_(priority, (Goal)new NearestAttackableTargetGoal((Mob)illager, Guard.class, true));
            }
        }
    }

    @SubscribeEvent
    public static void onMobEffectApplicable(MobEffectEvent.Applicable event) {
        MobEffect effect = event.getEffectInstance().m_19544_();
        EntityType target = event.getEntity().m_6095_();
        if (effect.equals(DifficultRaidsEffects.WIND_CURSE_EFFECT.get()) && ForgeRegistries.ENTITY_TYPES.tags().getTag(DifficultRaidsConfig.WINDS_CURSE_IMMUNE).contains((Object)target)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityHitByLightning(EntityStruckByLightningEvent event) {
        Entity entity;
        boolean isElectroIllagerBolt;
        LightningBolt lightning = event.getLightning();
        boolean bl = isElectroIllagerBolt = lightning.m_7770_() != null && lightning.m_7770_().getString().equals("DifficultRaids_Electro_Bolt");
        if (isElectroIllagerBolt && event.getEntity() instanceof Raider) {
            event.setCanceled(true);
        }
        if ((entity = event.getEntity()) instanceof LivingEntity) {
            float damageMultiplier;
            LivingEntity living = (LivingEntity)entity;
            ItemStack stack = living.m_6844_(EquipmentSlot.HEAD);
            int level = stack.getEnchantmentLevel((Enchantment)DifficultRaidsEnchantments.LIGHTNING_RESISTANCE.get());
            switch (level) {
                case 1: {
                    float f = 0.95f;
                    break;
                }
                case 2: {
                    float f = 0.8f;
                    break;
                }
                case 3: {
                    float f = 0.7f;
                    break;
                }
                case 4: {
                    float f = 0.5f;
                    break;
                }
                case 5: {
                    float f = 0.25f;
                    break;
                }
                default: {
                    float f = damageMultiplier = 1.0f;
                }
            }
            if (isElectroIllagerBolt) {
                damageMultiplier -= 0.05f;
            }
            lightning.setDamage(lightning.getDamage() * damageMultiplier);
        }
    }

    @SubscribeEvent
    public static void onLivingDeath(LivingDeathEvent event) {
        Raider raider;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Raider && (livingEntity = (raider = (Raider)livingEntity).m_9236_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)livingEntity;
            Optional.ofNullable((NecromancerIllagerEntity)serverLevel.m_45963_(NecromancerIllagerEntity.class, NECROMANCER_MINION_CHARGE_TARGETING, (LivingEntity)raider, raider.m_20185_(), raider.m_20186_(), raider.m_20189_(), raider.m_20191_().m_82400_(50.0))).ifPresent(necro -> {
                necro.addMinionCharge();
                necro.m_5496_(SoundEvents.f_12551_, 12.0f, 0.7f);
            });
        }
    }

    @SubscribeEvent
    public static void onMobGriefing(EntityMobGriefingEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof AshenmancerIllagerEntity) {
            AshenmancerIllagerEntity ashenmancer = (AshenmancerIllagerEntity)entity;
            if (!ashenmancer.config().ashenmancer.allowMobGriefing) {
                event.setResult(Event.Result.DENY);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        AshenmancerIllagerEntity ashenmancer;
        Entity entity;
        if (event.getSource().equals(DamageSource.f_19320_) && (entity = event.getSource().m_7639_()) instanceof AshenmancerIllagerEntity && (ashenmancer = (AshenmancerIllagerEntity)entity).isInDifficultRaid()) {
            event.setAmount(ashenmancer.config().ashenmancer.witherSkullWitherTickDamage);
        }
    }
}

