/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.entity.entities.elite;

import com.calculusmaster.difficultraids.entity.entities.component.VoldonFamiliarEntity;
import com.calculusmaster.difficultraids.entity.entities.core.AbstractEvokerVariant;
import com.calculusmaster.difficultraids.setup.DifficultRaidsConfig;
import com.calculusmaster.difficultraids.util.Compat;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.Nullable;
import tallestegg.guardvillagers.entities.Guard;

public class VoldonEliteEntity
extends AbstractEvokerVariant
implements RangedAttackMob {
    private final Component ELITE_NAME = Component.m_237115_((String)"com.calculusmaster.difficultraids.elite_event.voldon");
    private final ServerBossEvent ELITE_EVENT = new ServerBossEvent(this.ELITE_NAME, BossEvent.BossBarColor.WHITE, BossEvent.BossBarOverlay.PROGRESS);
    private static final double FAMILIAR_CHECK_RADIUS = 50.0;
    private int totalFamiliars = 0;
    private List<LivingEntity> familiars = new ArrayList<LivingEntity>();
    private int familiarCooldown = 0;
    private boolean checkFamiliars = false;
    private String familiarTag = IntStream.generate(() -> this.m_217043_().m_188503_(10)).limit(6L).mapToObj(String::valueOf).collect(Collectors.joining());

    public VoldonEliteEntity(EntityType<? extends AbstractEvokerVariant> p_33724_, Level p_33725_) {
        super(p_33724_, p_33725_);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new VoldonCastSpellGoal());
        this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 4.0f, 0.6, 0.75));
        this.f_21345_.m_25352_(3, (Goal)new VoldonSummonFamiliarsSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new VoldonTeleportFamiliarSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new VoldonSacrificeFamiliarSpellGoal());
        this.f_21345_.m_25352_(5, (Goal)new RangedAttackGoal((RangedAttackMob)this, 0.5, 120, 9.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{Raider.class}).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true).m_26146_(300));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        if (Compat.GUARD_VILLAGERS.isLoaded()) {
            this.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Guard.class, 8.0f, 0.7, 1.0));
        }
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        for (int ID : pCompound.m_128465_("FamiliarIDs")) {
            Entity entity = this.f_19853_.m_6815_(ID);
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity familiar = (LivingEntity)entity;
            this.familiars.add(familiar);
        }
        this.checkFamiliars = pCompound.m_128471_("CheckFamiliars");
        this.familiarTag = pCompound.m_128461_("FamiliarTag");
        this.totalFamiliars = pCompound.m_128451_("TotalFamiliarCount");
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("CheckFamiliars", !this.familiars.isEmpty());
        pCompound.m_128359_("FamiliarTag", this.familiarTag);
        pCompound.m_128405_("TotalFamiliarCount", this.totalFamiliars);
    }

    public void m_7895_(int p_37844_, boolean p_37845_) {
    }

    public boolean areFamiliarsDead() {
        return this.familiars.isEmpty();
    }

    public void removeFamiliar(VoldonFamiliarEntity familiar) {
        this.familiars.remove((Object)familiar);
        if (this.areFamiliarsDead()) {
            this.familiarCooldown = this.config().voldon.familiarSummonCooldown;
        }
    }

    @Override
    protected void m_8024_() {
        super.m_8024_();
        this.ELITE_EVENT.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.familiarCooldown > 0) {
            --this.familiarCooldown;
        }
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (pSource.m_7639_() instanceof IronGolem || Compat.GUARD_VILLAGERS.isLoaded() && pSource.m_7639_() instanceof Guard) {
            pAmount *= this.config().voldon.friendlyDamageReduction;
        }
        if (!this.areFamiliarsDead()) {
            pAmount *= 0.025f;
            this.familiars.stream().filter(e -> !e.m_21023_(MobEffects.f_19619_)).forEach(e -> e.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10000, 1, false, false)));
        }
        return super.m_6469_(pSource, pAmount);
    }

    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        BlockPos pos = this.m_20183_();
        int randomSpawnCount = this.f_19796_.m_216339_(3, 6);
        for (int i = 0; i < randomSpawnCount; ++i) {
            Entity entity;
            BlockPos spawnPos = pos.m_7918_(5 - this.f_19796_.m_216339_(1, 10), 1, 5 - this.f_19796_.m_216339_(1, 10));
            Monster zombie = (Monster)EntityType.f_20501_.m_20615_(this.f_19853_);
            zombie.m_20035_(spawnPos, this.m_6080_(), this.m_146909_());
            zombie.f_21346_.m_148096_();
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Villager.class, true));
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Player.class, true));
            zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, IronGolem.class, true));
            if (Compat.GUARD_VILLAGERS.isLoaded()) {
                zombie.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Guard.class, true));
            }
            if ((entity = pCause.m_7639_()) instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                zombie.m_6710_(living);
            }
            this.f_19853_.m_7967_((Entity)zombie);
        }
    }

    @Override
    public void m_8119_() {
        Level level;
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            this.familiars.removeIf(LivingEntity::m_21224_);
        }
        if (this.checkFamiliars && (level = this.f_19853_) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.familiars.addAll(serverLevel.m_6443_(VoldonFamiliarEntity.class, this.m_20191_().m_82400_(50.0), e -> e.m_19880_().contains(this.familiarTag)));
            this.checkFamiliars = this.f_19797_ <= 100 && this.familiars.isEmpty();
        }
    }

    protected void m_7472_(DamageSource pSource, int pLooting, boolean pRecentlyHit) {
    }

    public void m_6504_(LivingEntity pTarget, float pDistanceFactor) {
        double d0 = this.m_20280_((Entity)pTarget);
        double d1 = pTarget.m_20185_() - this.m_20185_();
        double d2 = pTarget.m_20227_(0.5) - this.m_20227_(0.5);
        double d3 = pTarget.m_20189_() - this.m_20189_();
        double d4 = Math.sqrt(Math.sqrt(d0)) * 0.5;
        int count = this.config().voldon.fireballCount;
        for (int i = 0; i < count; ++i) {
            SmallFireball fireball = new SmallFireball(this.f_19853_, (LivingEntity)this, this.f_19796_.m_216328_(d1, 2.297 * d4), d2, this.f_19796_.m_216328_(d3, 2.297 * d4)){

                protected void m_5790_(EntityHitResult pResult) {
                    if (pResult.m_82443_() instanceof Raider) {
                        this.m_146870_();
                    } else {
                        super.m_5790_(pResult);
                    }
                }
            };
            fireball.m_6034_(fireball.m_20185_(), this.m_20227_(0.5) + 0.5, fireball.m_20189_());
            this.f_19853_.m_7967_((Entity)fireball);
        }
        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_175834_, this.m_20185_(), this.m_20188_() + 0.4, this.m_20189_(), 0.2, 0.0, 0.3);
    }

    public void m_6457_(ServerPlayer pPlayer) {
        super.m_6457_(pPlayer);
        if (((Boolean)DifficultRaidsConfig.BOSS_BARS.get()).booleanValue()) {
            this.ELITE_EVENT.m_6543_(pPlayer);
        }
    }

    public void m_6452_(ServerPlayer pPlayer) {
        super.m_6452_(pPlayer);
        this.ELITE_EVENT.m_6539_(pPlayer);
    }

    private class VoldonCastSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerCastSpellGoal {
        private VoldonCastSpellGoal() {
        }

        @Override
        public void m_8037_() {
            if (VoldonEliteEntity.this.m_5448_() != null) {
                VoldonEliteEntity.this.m_21563_().m_24960_((Entity)VoldonEliteEntity.this.m_5448_(), (float)VoldonEliteEntity.this.m_8085_(), (float)VoldonEliteEntity.this.m_8132_());
            }
        }
    }

    private class VoldonSummonFamiliarsSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private VoldonSummonFamiliarsSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            int familiarCount;
            VoldonEliteEntity.this.totalFamiliars = familiarCount = VoldonEliteEntity.this.config().voldon.familiarSummonCount;
            BlockPos sourcePos = VoldonEliteEntity.this.m_20183_();
            Supplier<BlockPos> familiarPos = () -> sourcePos.m_7918_(VoldonEliteEntity.this.f_19796_.m_216339_(2, 10), VoldonEliteEntity.this.f_19796_.m_216339_(2, 4), VoldonEliteEntity.this.f_19796_.m_216339_(2, 10));
            for (int i = 0; i < familiarCount; ++i) {
                VoldonFamiliarEntity familiar = new VoldonFamiliarEntity(VoldonEliteEntity.this.f_19853_, VoldonEliteEntity.this);
                familiar.m_20035_(familiarPos.get(), 0.0f, 0.0f);
                familiar.m_6853_(true);
                familiar.m_20049_(VoldonEliteEntity.this.familiarTag);
                familiar.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 10000, 1, false, false));
                VoldonEliteEntity.this.f_19853_.m_7967_((Entity)familiar);
                VoldonEliteEntity.this.familiars.add((LivingEntity)familiar);
            }
        }

        @Override
        public boolean m_8036_() {
            return super.m_8036_() && VoldonEliteEntity.this.areFamiliarsDead() && VoldonEliteEntity.this.familiarCooldown <= 0;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 100;
        }

        @Override
        protected int getCastWarmupTime() {
            return 20;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11868_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.VOLDON_SUMMON_FAMILIARS;
        }
    }

    private class VoldonTeleportFamiliarSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private VoldonTeleportFamiliarSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            List<LivingEntity> familiars = VoldonEliteEntity.this.familiars.stream().filter(LivingEntity::m_6084_).toList();
            if (!familiars.isEmpty()) {
                LivingEntity target = familiars.get(VoldonEliteEntity.this.f_19796_.m_188503_(familiars.size()));
                VoldonEliteEntity.this.m_21563_().m_148051_((Entity)target);
                double yOffset = 0.3;
                BlockPos targetPos = target.m_20183_().m_7637_(0.0, yOffset, 0.0);
                BlockPos thisPos = VoldonEliteEntity.this.m_20183_().m_7637_(0.0, yOffset, 0.0);
                VoldonEliteEntity.this.m_20324_(targetPos.m_123341_(), targetPos.m_123342_(), targetPos.m_123343_());
                target.m_20324_((double)thisPos.m_123341_(), (double)thisPos.m_123342_(), (double)thisPos.m_123343_());
                target.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 140, 2, false, true));
            }
        }

        @Override
        public boolean m_8036_() {
            return VoldonEliteEntity.this.f_19797_ >= this.spellCooldown && !VoldonEliteEntity.this.areFamiliarsDead();
        }

        @Override
        protected int getCastingTime() {
            return 10;
        }

        @Override
        protected int getCastingInterval() {
            return 400;
        }

        @Override
        protected int getCastWarmupTime() {
            return 5;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_11852_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.VOLDON_TELEPORT_FAMILIAR;
        }
    }

    private class VoldonSacrificeFamiliarSpellGoal
    extends AbstractEvokerVariant.SpellcastingIllagerUseSpellGoal {
        private VoldonSacrificeFamiliarSpellGoal() {
            super(new Goal.Flag[0]);
        }

        @Override
        protected void castSpell() {
            ArrayList<LivingEntity> familiars = new ArrayList<LivingEntity>(VoldonEliteEntity.this.familiars);
            LivingEntity sacrifice = null;
            for (LivingEntity e : familiars) {
                if (!(e.m_21223_() <= e.m_21233_() * 0.25f)) continue;
                sacrifice = e;
                break;
            }
            if (!familiars.isEmpty() && sacrifice != null) {
                VoldonEliteEntity.this.m_21563_().m_148051_(sacrifice);
                ((Mob)sacrifice).m_21563_().m_148051_((Entity)VoldonEliteEntity.this);
                int effectDuration = VoldonEliteEntity.this.config().voldon.sacrificeBuffDuration;
                familiars.forEach(f -> {
                    f.m_7292_(new MobEffectInstance(MobEffects.f_19596_, effectDuration, 1, false, false));
                    f.m_7292_(new MobEffectInstance(MobEffects.f_19600_, effectDuration, 3, false, false));
                    f.m_7292_(new MobEffectInstance(MobEffects.f_19606_, effectDuration / 4, 1, false, false));
                });
                sacrifice.m_6469_(DamageSource.f_19313_, sacrifice.m_21223_() + 1.0f);
            }
        }

        @Override
        public boolean m_8036_() {
            return VoldonEliteEntity.this.f_19797_ >= this.spellCooldown && !VoldonEliteEntity.this.areFamiliarsDead() && VoldonEliteEntity.this.familiars.stream().anyMatch(e -> e.m_21223_() <= e.m_21233_() * 0.25f) && VoldonEliteEntity.this.familiars.size() > 2;
        }

        @Override
        protected int getCastingTime() {
            return 40;
        }

        @Override
        protected int getCastingInterval() {
            return 900;
        }

        @Override
        protected int getCastWarmupTime() {
            return 10;
        }

        @Override
        @Nullable
        protected SoundEvent getSpellPrepareSound() {
            return SoundEvents.f_12551_;
        }

        @Override
        protected AbstractEvokerVariant.SpellType getSpellType() {
            return AbstractEvokerVariant.SpellType.VOLDON_SACRIFICE_FAMILIAR;
        }
    }
}

