/*
 * Decompiled with CFR 0.152.
 */
package com.calculusmaster.difficultraids.data.raiderentries;

import com.calculusmaster.difficultraids.data.raiderentries.DifficultyRaiderEntries;
import com.calculusmaster.difficultraids.data.raiderentries.RaiderEntriesHolder;
import com.calculusmaster.difficultraids.raids.RaidEnemyRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;

public class RaidWaveReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, RaiderEntriesHolder>> {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected static final String JSON_EXTENSION = ".json";
    protected static final int JSON_EXTENSION_LENGTH = ".json".length();
    protected Map<ResourceLocation, RaiderEntriesHolder> data = new HashMap<ResourceLocation, RaiderEntriesHolder>();
    private static final String FOLDER_NAME = "raids";
    private static final Function<List<DifficultyRaiderEntries>, RaiderEntriesHolder> MERGER = RaiderEntriesHolder::new;

    public Map<ResourceLocation, RaiderEntriesHolder> getData() {
        return this.data;
    }

    protected Map<ResourceLocation, RaiderEntriesHolder> prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        LOGGER.info("DifficultRaids: Starting Data Loading for Raid Waves ({}).", (Object)FOLDER_NAME);
        HashMap<ResourceLocation, RaiderEntriesHolder> map = new HashMap<ResourceLocation, RaiderEntriesHolder>();
        Map resourceStacks = resourceManager.m_214160_(FOLDER_NAME, id -> id.m_135815_().endsWith(JSON_EXTENSION));
        for (Map.Entry entry : resourceStacks.entrySet()) {
            ArrayList raws = new ArrayList();
            ResourceLocation fullId = (ResourceLocation)entry.getKey();
            String fullPath = fullId.m_135815_();
            ResourceLocation id2 = new ResourceLocation(fullId.m_135827_(), fullPath.substring(FOLDER_NAME.length() + 1, fullPath.length() - JSON_EXTENSION_LENGTH));
            for (Resource resource : (List)entry.getValue()) {
                try {
                    BufferedReader reader = resource.m_215508_();
                    try {
                        JsonElement jsonElement = JsonParser.parseReader((Reader)reader);
                        DifficultyRaiderEntries.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial(errorMsg -> LOGGER.error("DifficultRaids: Error deserializing json {} in folder {} from pack {}: {}", new Object[]{id2, FOLDER_NAME, resource.m_215506_(), errorMsg})).ifPresent(raws::add);
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format(Locale.ENGLISH, "DifficultRaids: Error reading resource %s in folder %s from pack %s: ", id2, FOLDER_NAME, resource.m_215506_()), (Throwable)e);
                }
            }
            map.put(id2, MERGER.apply(raws));
        }
        LOGGER.info("DifficultRaids: Data Loader for {} loaded {} finalized objects", (Object)FOLDER_NAME, (Object)map.size());
        return Map.copyOf(map);
    }

    protected void apply(Map<ResourceLocation, RaiderEntriesHolder> processedData, ResourceManager resourceManager, ProfilerFiller profiler) {
        this.data = processedData;
        RaidEnemyRegistry.compileWaveData(this.data);
    }
}

