/*
 * Decompiled with CFR 0.152.
 */
package com.brutalbosses.entity.ai;

import com.brutalbosses.BrutalBosses;
import com.brutalbosses.entity.ai.IAIParams;
import com.google.gson.JsonObject;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Path;

public class ChargeGoal
extends Goal {
    public static ResourceLocation ID = new ResourceLocation("brutalbosses:charge");
    private static final AttributeModifier speedMod = new AttributeModifier("brutalbosses:speedbuff", 2.0, AttributeModifier.Operation.MULTIPLY_TOTAL);
    private final Mob mob;
    private ChargeParams params;
    private LivingEntity target = null;
    private int ticksToNextUpdate = 0;
    private boolean isCharging = false;

    public ChargeGoal(Mob mob, IAIParams params) {
        this.params = (ChargeParams)params;
        this.mob = mob;
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && target.m_6084_()) {
            this.target = target;
            return this.params.healthPhaseCheck.test(this.mob);
        }
        return false;
    }

    public void m_8041_() {
        this.target = null;
    }

    public void m_8037_() {
        Path path;
        if (--this.ticksToNextUpdate > 0) {
            return;
        }
        double distSqr = this.mob.m_20275_(this.target.m_20185_(), this.target.m_20186_(), this.target.m_20189_());
        this.ticksToNextUpdate = (int)Math.max(4.0, distSqr / 100.0);
        if (distSqr >= (double)this.params.minDistance && !this.isCharging && (path = this.mob.m_21573_().m_26570_()) != null) {
            this.isCharging = true;
            this.ticksToNextUpdate = (int)this.params.duration;
            if (!this.mob.m_21051_(Attributes.f_22279_).m_22109_(speedMod)) {
                this.mob.m_21051_(Attributes.f_22279_).m_22118_(speedMod);
            }
            this.mob.m_7910_((float)this.mob.m_21051_(Attributes.f_22279_).m_22135_());
            this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_11789_, this.mob.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            if (this.mob.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 20, d0, 0.0, d1, 0.0);
            }
            return;
        }
        if (this.isCharging) {
            this.isCharging = false;
            this.ticksToNextUpdate = (int)(this.params.interval + (float)(BrutalBosses.rand.nextInt(20) - 10));
            this.mob.m_21051_(Attributes.f_22279_).m_22130_(speedMod);
            this.mob.m_7910_((float)this.mob.m_21051_(Attributes.f_22279_).m_22135_());
            this.mob.f_19853_.m_6263_(null, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_(), SoundEvents.f_11789_, this.mob.m_5720_(), 1.0f, 1.0f);
            double d0 = -Mth.m_14031_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(this.mob.m_146908_() * ((float)Math.PI / 180)));
            if (this.mob.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.mob.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.mob.m_20185_() + d0, this.mob.m_20227_(0.5), this.mob.m_20189_() + d1, 20, d0, 0.0, d1, 0.0);
            }
        }
    }

    public static class ChargeParams
    extends IAIParams.DefaultParams {
        private float minDistance = 3.0f;
        private float duration = 20.0f;
        private float interval = 200.0f;
        public static final String CHARGE_MINDIST = "mindist";
        public static final String CHARGE_DURATION = "duration";
        public static final String CHARGE_COOLDOWN = "interval";

        public ChargeParams(JsonObject jsonData) {
            super(jsonData);
            this.parse(jsonData);
        }

        @Override
        public IAIParams parse(JsonObject jsonElement) {
            super.parse(jsonElement);
            if (jsonElement.has(CHARGE_MINDIST)) {
                this.minDistance = jsonElement.get(CHARGE_MINDIST).getAsFloat();
            }
            if (jsonElement.has(CHARGE_DURATION)) {
                this.duration = jsonElement.get(CHARGE_DURATION).getAsFloat();
            }
            if (jsonElement.has(CHARGE_COOLDOWN)) {
                this.interval = jsonElement.get(CHARGE_COOLDOWN).getAsFloat();
            }
            return this;
        }
    }
}

