/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy.listeners;

import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.events.OnUndeadArmyStateChanged;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class MessageSender {
    private static void send(OnUndeadArmyStateChanged data) {
        MessageSender.getChatMessage(data.undeadArmy).ifPresent(message -> data.undeadArmy.participants.forEach(participant -> participant.m_5661_((Component)message, false)));
    }

    private static Optional<MutableComponent> getChatMessage(UndeadArmy undeadArmy) {
        if (undeadArmy.phase.state == UndeadArmy.Phase.State.WAVE_PREPARING && undeadArmy.currentWave == 0) {
            String directionId = undeadArmy.direction.toString().toLowerCase();
            MutableComponent direction = TextHelper.translatable((String)"majruszsdifficulty.undead_army.%s".formatted(directionId), (Object[])new Object[0]);
            MutableComponent approaching = TextHelper.translatable((String)"majruszsdifficulty.undead_army.approaching", (Object[])new Object[]{direction});
            return Optional.of(approaching.m_130940_(ChatFormatting.DARK_PURPLE));
        }
        if (undeadArmy.phase.state == UndeadArmy.Phase.State.WAVE_ONGOING && undeadArmy.currentWave == 1) {
            MutableComponent approached = TextHelper.translatable((String)"majruszsdifficulty.undead_army.approached", (Object[])new Object[0]);
            return Optional.of(approached.m_130944_(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.DARK_PURPLE}));
        }
        return Optional.empty();
    }

    static {
        OnUndeadArmyStateChanged.listen(MessageSender::send).addCondition(data -> data.undeadArmy.phase.state != UndeadArmy.Phase.State.FINISHED);
    }
}

