/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.undeadarmy;

import com.majruszlibrary.command.Command;
import com.majruszlibrary.command.CommandData;
import com.majruszlibrary.command.IParameter;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.undeadarmy.UndeadArmy;
import com.majruszsdifficulty.undeadarmy.UndeadArmyConfig;
import com.majruszsdifficulty.undeadarmy.UndeadArmyHelper;
import com.majruszsdifficulty.undeadarmy.listeners.UndeadArmyTrigger;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class UndeadArmyCommands {
    private static final IParameter<UndeadArmy.Direction> DIRECTION = Command.enumeration(UndeadArmy.Direction::values).named("direction");
    private static final IParameter<List<Vec3>> POSITIONS = Command.anyPosition();
    private static final IParameter<List<? extends Entity>> ENTITIES = Command.entities();

    private static int start(CommandData data) throws CommandSyntaxException {
        Optional direction = data.getOptional(DIRECTION);
        List positions = data.getOptional(POSITIONS).orElseGet(List::of);
        if (positions.isEmpty()) {
            positions.add(data.getCaller().m_20182_());
        }
        for (Vec3 position : positions) {
            BlockPos blockPos = AnyPos.from((Vec3)position).block();
            if (UndeadArmyHelper.tryToSpawn(blockPos, direction)) {
                data.source.m_81354_((Component)TextHelper.translatable((String)"commands.undeadarmy.started", (Object[])new Object[]{"(%s)".formatted(blockPos.m_123344_())}), true);
                continue;
            }
            data.source.m_81352_((Component)TextHelper.translatable((String)"commands.undeadarmy.cannot_start", (Object[])new Object[]{"(%s)".formatted(blockPos.m_123344_())}));
        }
        return 0;
    }

    private static int listAll(CommandData data) throws CommandSyntaxException {
        List<UndeadArmy> undeadArmies = UndeadArmyHelper.getUndeadArmies();
        if (!undeadArmies.isEmpty()) {
            MutableComponent component = TextHelper.translatable((String)"commands.undeadarmy.list", (Object[])new Object[0]);
            undeadArmies.forEach(undeadArmy -> {
                component.m_130946_("\n- ");
                component.m_7220_((Component)TextHelper.translatable((String)"majruszsdifficulty.undead_army.title", (Object[])new Object[0]));
                component.m_7220_((Component)TextHelper.empty());
                component.m_7220_((Component)TextHelper.translatable((String)"majruszsdifficulty.undead_army.wave", (Object[])new Object[]{TextHelper.toRoman((int)Math.max(undeadArmy.currentWave, 1))}));
                component.m_130946_(" (%s)".formatted(undeadArmy.position.m_123344_()));
            });
            data.source.m_81354_((Component)component, true);
            return 0;
        }
        data.source.m_81352_((Component)TextHelper.translatable((String)"commands.undeadarmy.list_empty", (Object[])new Object[0]));
        return -1;
    }

    private static int sendProgress(CommandData data) throws CommandSyntaxException {
        for (Entity entity : data.getOptional(ENTITIES).orElseGet(() -> List.of(data.getCaller()))) {
            CompoundTag tag = EntityHelper.getExtraTag((Entity)entity);
            int undeadLeft = tag != null ? ((UndeadArmyTrigger.Progress)Serializables.read((Object)new UndeadArmyTrigger.Progress(), (Tag)tag)).undeadLeft : UndeadArmyConfig.KILL_REQUIREMENT_FIRST;
            data.source.m_81354_((Component)TextHelper.translatable((String)"commands.undeadarmy.progress", (Object[])new Object[]{entity.m_5446_(), Math.max(undeadLeft, 1)}), true);
        }
        return 0;
    }

    private static void create(String command, String successId, Consumer<UndeadArmy> consumer) {
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{command}).execute(data -> UndeadArmyCommands.handle(data, successId, consumer)).parameter(POSITIONS).execute(data -> UndeadArmyCommands.handle(data, successId, consumer)).register();
    }

    private static int handle(CommandData data, String successId, Consumer<UndeadArmy> consumer) {
        List positions = data.getOptional(POSITIONS).orElseGet(List::of);
        if (positions.isEmpty()) {
            positions.add(data.getCaller().m_20182_());
        }
        for (Vec3 position : positions) {
            BlockPos blockPos = AnyPos.from((Vec3)position).block();
            UndeadArmy undeadArmy = UndeadArmyHelper.findNearestUndeadArmy(blockPos);
            if (undeadArmy != null) {
                consumer.accept(undeadArmy);
                data.source.m_81354_((Component)TextHelper.translatable((String)("commands.undeadarmy." + successId), (Object[])new Object[]{"(%s)".formatted(blockPos.m_123344_())}), true);
                continue;
            }
            data.source.m_81352_((Component)TextHelper.translatable((String)"commands.undeadarmy.missing", (Object[])new Object[]{"(%s)".formatted(blockPos.m_123344_())}));
        }
        return 0;
    }

    static {
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{"start"}).execute(UndeadArmyCommands::start).parameter(DIRECTION).execute(UndeadArmyCommands::start).parameter(POSITIONS).execute(UndeadArmyCommands::start).register();
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{"listall"}).execute(UndeadArmyCommands::listAll).register();
        Command.create().literal(new String[]{"undeadarmy"}).hasPermission(4).literal(new String[]{"progress"}).execute(UndeadArmyCommands::sendProgress).parameter(ENTITIES).execute(UndeadArmyCommands::sendProgress).register();
        UndeadArmyCommands.create("highlight", "highlighted", UndeadArmy::highlight);
        UndeadArmyCommands.create("killall", "killed", UndeadArmy::killAllMobs);
        UndeadArmyCommands.create("stop", "finished", UndeadArmy::finish);
    }
}

