/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.recipes;

import com.majruszlibrary.data.Serializables;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.items.SoulJar;
import java.util.function.Supplier;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleRecipeSerializer;
import net.minecraft.world.level.Level;

public class SoulJarShieldRecipe
extends CustomRecipe {
    public static Supplier<RecipeSerializer<?>> create() {
        return () -> new SimpleRecipeSerializer(SoulJarShieldRecipe::new);
    }

    public SoulJarShieldRecipe(ResourceLocation id) {
        super(id);
    }

    public boolean matches(CraftingContainer container, Level level) {
        RecipeData recipeData = SoulJarShieldRecipe.convert(container);
        return !recipeData.shield.m_41619_() && !recipeData.soulJar.m_41619_();
    }

    public ItemStack assemble(CraftingContainer container) {
        RecipeData recipeData = SoulJarShieldRecipe.convert(container);
        ItemStack shield = recipeData.shield.m_41777_();
        Serializables.write((Object)SoulJar.BonusInfo.read(recipeData.soulJar), (Tag)shield.m_41784_());
        return shield;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)MajruszsDifficulty.SOUL_JAR_SHIELD_RECIPE.get();
    }

    private static RecipeData convert(CraftingContainer container) {
        ItemStack soulJar = ItemStack.f_41583_;
        ItemStack shield = ItemStack.f_41583_;
        for (int i = 0; i < container.m_6643_(); ++i) {
            ItemStack itemStack = container.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            if (itemStack.m_41720_() instanceof SoulJar && soulJar.m_41619_()) {
                soulJar = itemStack;
                continue;
            }
            if (itemStack.m_41720_() instanceof ShieldItem && shield.m_41619_()) {
                shield = itemStack;
                continue;
            }
            return new RecipeData(ItemStack.f_41583_, ItemStack.f_41583_);
        }
        return new RecipeData(soulJar, shield);
    }

    record RecipeData(ItemStack soulJar, ItemStack shield) {
    }
}

