/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.itemsets;

import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.itemsets.ItemSet;
import com.majruszsdifficulty.itemsets.ItemSetRequirement;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class ItemSetBonus {
    private final Predicate<List<ItemSetRequirement>> predicate;
    private final Function<ItemSet, Component> requirementComponent;
    private String id;
    private Object[] args;

    public static ItemSetBonus any(int count) {
        return new ItemSetBonus(requirements -> requirements.size() >= count, itemSet -> TextHelper.literal((String)"%1$s/%2$s", (Object[])new Object[]{count, itemSet.getRequirementsSize()}));
    }

    public static ItemSetBonus requires(ItemSetRequirement requirement) {
        return new ItemSetBonus(requirements -> requirements.contains(requirement), itemSet -> requirement.getComponent());
    }

    public ItemSetBonus component(String id, Object ... args) {
        this.id = id;
        this.args = args;
        return this;
    }

    public boolean canTrigger(List<ItemSetRequirement> requirementsMet) {
        return this.predicate.test(requirementsMet);
    }

    public Component toComponent(ItemSet itemSet, List<ItemSetRequirement> requirementsMet) {
        ChatFormatting[] chatFormattingArray;
        ChatFormatting[] chatFormattingArray2;
        boolean canTrigger = this.canTrigger(requirementsMet);
        if (canTrigger) {
            chatFormattingArray2 = itemSet.getFormatting();
        } else {
            ChatFormatting[] chatFormattingArray3 = new ChatFormatting[1];
            chatFormattingArray2 = chatFormattingArray3;
            chatFormattingArray3[0] = ChatFormatting.DARK_GRAY;
        }
        ChatFormatting[] formatting = chatFormattingArray2;
        Object[] args = Arrays.stream(this.args).map(arg -> {
            MutableComponent component;
            return (arg instanceof MutableComponent ? (component = (MutableComponent)arg) : TextHelper.literal((String)arg.toString())).m_130944_(formatting);
        }).toArray();
        MutableComponent bonus = TextHelper.translatable((String)this.id, (Object[])args).m_130940_(canTrigger ? ChatFormatting.GRAY : ChatFormatting.DARK_GRAY);
        MutableComponent mutableComponent = TextHelper.translatable((String)"majruszsdifficulty.item_sets.bonus", (Object[])new Object[]{this.requirementComponent.apply(itemSet), bonus});
        if (canTrigger) {
            chatFormattingArray = itemSet.getFormatting();
        } else {
            ChatFormatting[] chatFormattingArray4 = new ChatFormatting[1];
            chatFormattingArray = chatFormattingArray4;
            chatFormattingArray4[0] = ChatFormatting.DARK_GRAY;
        }
        return mutableComponent.m_130944_(chatFormattingArray);
    }

    private ItemSetBonus(Predicate<List<ItemSetRequirement>> predicate, Function<ItemSet, Component> requirementComponent) {
        this.predicate = predicate;
        this.requirementComponent = requirementComponent;
    }
}

