/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.level.BlockHelper;
import com.majruszlibrary.math.AnyPos;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EnderiumShardLocator
extends Item {
    private static final int OFFSET = 26;

    public EnderiumShardLocator() {
        super(new Item.Properties().m_41497_(Rarity.UNCOMMON));
    }

    private static boolean isOre(Level level, BlockPos position) {
        return BlockHelper.getState((Level)level, (BlockPos)position).m_60734_() == MajruszsDifficulty.ENDERIUM_SHARD_ORE_BLOCK.get();
    }

    static {
        Serializables.get(ItemInfo.class).define("EnderiumShardLocatorPos", Reader.optional((IReader)Reader.blockPos()), s -> s.position, (s, v) -> {
            s.position = v;
        }).define("EnderiumShardLocatorCounter", Reader.integer(), s -> s.counter, (s, v) -> {
            s.counter = v;
        });
    }

    private static class ItemInfo {
        public BlockPos position = null;
        public int counter = 0;

        private ItemInfo() {
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Client {
        public static float getShardDistance(ItemStack itemStack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            Player player;
            block6: {
                block5: {
                    if (!(entity instanceof Player)) break block5;
                    player = (Player)entity;
                    if (level != null) break block6;
                }
                return 1.0f;
            }
            if (player.m_150109_().m_36030_(itemStack) == -1 && !player.m_21206_().equals(itemStack)) {
                return 1.0f;
            }
            ItemInfo itemInfo = new ItemInfo();
            Serializables.modify((Object)itemInfo, (Tag)itemStack.m_41784_(), info -> {
                if (itemInfo.position != null && !EnderiumShardLocator.isOre((Level)level, itemInfo.position)) {
                    info.position = null;
                }
                info.position = Client.findNearestOre(level, player, info);
                info.counter = (info.counter + 1) % 52;
            });
            if (itemInfo.position == null) {
                return 1.0f;
            }
            return (float)Mth.m_14008_((double)(AnyPos.from((Vec3)player.m_20182_()).dist(itemInfo.position).doubleValue() / 26.0), (double)0.0, (double)1.0);
        }

        private static BlockPos findNearestOre(ClientLevel level, Player player, ItemInfo itemInfo) {
            BlockPos nearestPosition = itemInfo.position;
            float nearestDistance = nearestPosition != null ? AnyPos.from((Vec3)player.m_20182_()).dist(AnyPos.from((BlockPos)nearestPosition).center()).floatValue() : 26.0f;
            for (int x = -26; x < 26; ++x) {
                for (int z = -26; z < 26; ++z) {
                    float distance;
                    BlockPos position = AnyPos.from((BlockPos)player.m_20183_()).add((Number)x, (Number)(itemInfo.counter - 26), (Number)z).block();
                    if (!EnderiumShardLocator.isOre((Level)level, position) || !(nearestDistance > (distance = AnyPos.from((Vec3)player.m_20182_()).dist(AnyPos.from((BlockPos)position).center()).floatValue()))) continue;
                    nearestPosition = position;
                    nearestDistance = distance;
                }
            }
            return nearestPosition;
        }
    }
}

