/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.items;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EffectDef;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.events.OnPlayerInteracted;
import com.majruszlibrary.item.ItemHelper;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.text.TextHelper;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.data.Config;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;

public class Bandage
extends Item {
    private static List<EffectDef> NORMAL_EFFECTS = List.of(new EffectDef(MajruszsDifficulty.GLASS_REGENERATION_EFFECT, 0, 20.0f));
    private static List<EffectDef> GOLDEN_EFFECTS = List.of(new EffectDef(MajruszsDifficulty.GLASS_REGENERATION_EFFECT, 1, 20.0f), new EffectDef(MajruszsDifficulty.BLEEDING_IMMUNITY_EFFECT, 0, 90.0f));
    private final Supplier<List<EffectDef>> effects;

    public static Supplier<Bandage> normal() {
        return () -> new Bandage(Rarity.COMMON, () -> NORMAL_EFFECTS);
    }

    public static Supplier<Bandage> golden() {
        return () -> new Bandage(Rarity.UNCOMMON, () -> GOLDEN_EFFECTS);
    }

    private static void use(OnPlayerInteracted data) {
        Player player;
        Bandage bandage = (Bandage)data.itemStack.m_41720_();
        Entity entity = data.entity;
        if (entity instanceof LivingEntity) {
            LivingEntity entity2 = (LivingEntity)entity;
            player = entity2;
        } else {
            player = data.player;
        }
        Player target = player;
        bandage.getEffects().forEach(arg_0 -> Bandage.lambda$use$11((LivingEntity)target, arg_0));
        SoundEmitter.of((SoundEvent)SoundEvents.f_12019_).volume(Random.nextFloat((float)0.4f, (float)0.6f)).position(target.m_20182_()).emit(target.m_9236_());
        Bandage.removeBleeding(bandage, data.player, (LivingEntity)target);
        ItemHelper.addCooldown((Player)data.player, (int)TimeHelper.toTicks((double)0.7), (Item[])new Item[]{(Item)MajruszsDifficulty.BANDAGE_ITEM.get(), (Item)MajruszsDifficulty.GOLDEN_BANDAGE_ITEM.get()});
        ItemHelper.consumeItemOnUse((ItemStack)data.itemStack, (Player)data.player);
        data.finish();
    }

    private static void removeBleeding(Bandage item, Player player, LivingEntity target) {
        if (target.m_21023_((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get()) && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target.equals((Object)serverPlayer)) {
                MajruszsDifficulty.HELPER.triggerAchievement(serverPlayer, "bandage_used");
            } else if (((Object)((Object)item)).equals(MajruszsDifficulty.GOLDEN_BANDAGE_ITEM.get())) {
                MajruszsDifficulty.HELPER.triggerAchievement(serverPlayer, "golden_bandage_used_on_others");
            }
        }
        target.m_21195_((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get());
    }

    private static void addEffectInfo(OnItemTooltip data) {
        Bandage bandage = (Bandage)data.itemStack.m_41720_();
        for (EffectDef effectDef : bandage.effects.get()) {
            data.components.add(effectDef.toComponent().m_130940_(ChatFormatting.BLUE));
        }
        data.components.add(TextHelper.empty());
        data.components.add(TextHelper.translatable((String)"potion.whenDrank", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
        data.components.add(TextHelper.translatable((String)"item.majruszsdifficulty.bandage.effect", (Object[])new Object[0]).m_130940_(ChatFormatting.BLUE));
    }

    private Bandage(Rarity rarity, Supplier<List<EffectDef>> effects) {
        super(new Item.Properties().m_41487_(16).m_41497_(rarity));
        this.effects = effects;
    }

    private List<EffectDef> getEffects() {
        return this.effects.get();
    }

    private static /* synthetic */ void lambda$use$11(LivingEntity target, EffectDef effectDef) {
        target.m_7292_(effectDef.toEffectInstance());
    }

    static {
        OnPlayerInteracted.listen(Bandage::use).addCondition(data -> data.itemStack.m_41720_() instanceof Bandage).addCondition(data -> !ItemHelper.isOnCooldown((Player)data.player, (Item[])new Item[]{(Item)MajruszsDifficulty.BANDAGE_ITEM.get(), (Item)MajruszsDifficulty.GOLDEN_BANDAGE_ITEM.get()}));
        OnItemTooltip.listen(Bandage::addEffectInfo).addCondition(data -> data.itemStack.m_41720_() instanceof Bandage);
        Serializables.getStatic(Config.Items.class).define("bandage", Bandage.class);
        Serializables.getStatic(Bandage.class).define("normal_effects", Reader.list((IReader)Reader.custom(EffectDef::new)), () -> NORMAL_EFFECTS, v -> {
            NORMAL_EFFECTS = v;
        }).define("golden_effects", Reader.list((IReader)Reader.custom(EffectDef::new)), () -> GOLDEN_EFFECTS, v -> {
            GOLDEN_EFFECTS = v;
        });
    }
}

