/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.gamestage;

import com.majruszlibrary.data.IReader;
import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.text.RegexString;
import com.majruszlibrary.text.TextHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;

public class GameStage {
    public static final String NORMAL_ID = "normal";
    public static final String EXPERT_ID = "expert";
    public static final String MASTER_ID = "master";
    private String id = "";
    private List<ChatFormatting> format = new ArrayList<ChatFormatting>();
    private Trigger trigger = new Trigger();
    private List<Message> messages = new ArrayList<Message>();
    int ordinal = 0;

    public static Builder named(String name) {
        return new Builder(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        if (!(object instanceof GameStage)) return false;
        GameStage gameStage = (GameStage)object;
        if (!this.id.equals(gameStage.id)) return false;
        return true;
    }

    public boolean checkDimension(String dimensionId) {
        return this.trigger.dimensions.stream().anyMatch(string -> string.matches(dimensionId));
    }

    public boolean checkEntity(String entityId) {
        return this.trigger.entities.stream().anyMatch(string -> string.matches(entityId));
    }

    public boolean is(String name) {
        return this.id.equals(name);
    }

    public String getId() {
        return this.id;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public MutableComponent getComponent() {
        return TextHelper.translatable((String)"majruszsdifficulty.stages.%s".formatted(this.id.toLowerCase()), (Object[])new Object[0]).m_130944_((ChatFormatting[])this.format.toArray(ChatFormatting[]::new));
    }

    public List<MutableComponent> getMessages() {
        return this.messages.stream().map(message -> TextHelper.translatable((String)message.id, (Object[])new Object[0]).m_130944_((ChatFormatting[])message.format.toArray(ChatFormatting[]::new))).toList();
    }

    GameStage copy(GameStage gameStage) {
        this.format = gameStage.format;
        this.trigger = gameStage.trigger;
        this.messages = gameStage.messages;
        return this;
    }

    static {
        Serializables.get(GameStage.class).define("id", Reader.string(), s -> s.id, (s, v) -> {
            s.id = v;
        }).define("format", Reader.list((IReader)Reader.enumeration(ChatFormatting::values)), s -> s.format, (s, v) -> {
            s.format = v;
        }).define("triggers", Reader.custom(Trigger::new), s -> s.trigger, (s, v) -> {
            s.trigger = v;
        }).define("messages", Reader.list((IReader)Reader.custom(Message::new)), s -> s.messages, (s, v) -> {
            s.messages = v;
        });
        Serializables.get(Trigger.class).define("dimensions", Reader.list((IReader)Reader.string()), s -> RegexString.toString(s.dimensions), (s, v) -> {
            s.dimensions = RegexString.toRegex((List)v);
        }).define("entities", Reader.list((IReader)Reader.string()), s -> RegexString.toString(s.entities), (s, v) -> {
            s.entities = RegexString.toRegex((List)v);
        });
        Serializables.get(Message.class).define("id", Reader.string(), s -> s.id, (s, v) -> {
            s.id = v;
        }).define("format", Reader.list((IReader)Reader.enumeration(ChatFormatting::values)), s -> s.format, (s, v) -> {
            s.format = v;
        });
    }

    private static class Trigger {
        public List<RegexString> dimensions = new ArrayList<RegexString>();
        public List<RegexString> entities = new ArrayList<RegexString>();

        private Trigger() {
        }
    }

    public static class Builder {
        private final GameStage gameStage = new GameStage();

        public Builder(String name) {
            this.gameStage.id = name;
        }

        public Builder format(ChatFormatting ... format) {
            this.gameStage.format = List.of(format);
            return this;
        }

        public Builder triggersIn(String dimensionId) {
            this.gameStage.trigger.dimensions.add(new RegexString(dimensionId));
            return this;
        }

        public Builder triggersByKilling(String entityId) {
            this.gameStage.trigger.entities.add(new RegexString(entityId));
            return this;
        }

        public Builder message(String id, ChatFormatting ... format) {
            Message message = new Message();
            message.id = id;
            message.format = List.of(format);
            this.gameStage.messages.add(message);
            return this;
        }

        public GameStage create() {
            return this.gameStage;
        }
    }

    private static class Message {
        public String id;
        public List<ChatFormatting> format = new ArrayList<ChatFormatting>();

        private Message() {
        }
    }
}

