/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.features;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnEntitySpawned;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.data.Config;
import com.majruszsdifficulty.events.base.CustomCondition;
import com.majruszsdifficulty.gamestage.GameStage;
import com.majruszsdifficulty.gamestage.GameStageHelper;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;

public class CreeperSpawnCharged {
    private static boolean IS_ENABLED = true;
    private static GameStage REQUIRED_GAME_STAGE = GameStageHelper.find("normal");
    private static float CHANCE = 0.125f;
    private static boolean IS_SCALED_BY_CRD = true;

    private static void charge(OnEntitySpawned data) {
        Creeper creeper = (Creeper)data.entity;
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)data.getServerLevel());
        if (lightningBolt != null) {
            creeper.m_8038_(data.getServerLevel(), lightningBolt);
            creeper.m_20095_();
        }
    }

    static {
        OnEntitySpawned.listen(CreeperSpawnCharged::charge).addCondition(Condition.isLogicalServer()).addCondition(Condition.chanceCRD(() -> Float.valueOf(CHANCE), () -> IS_SCALED_BY_CRD)).addCondition(data -> IS_ENABLED).addCondition(CustomCondition.check(REQUIRED_GAME_STAGE)).addCondition(data -> !data.isLoadedFromDisk).addCondition(data -> data.entity instanceof Creeper);
        Serializables.getStatic(Config.Features.class).define("creeper_spawn_charged", CreeperSpawnCharged.class);
        Serializables.getStatic(CreeperSpawnCharged.class).define("is_enabled", Reader.bool(), () -> IS_ENABLED, v -> {
            IS_ENABLED = v;
        }).define("required_game_stage", Reader.string(), () -> REQUIRED_GAME_STAGE.getId(), v -> {
            REQUIRED_GAME_STAGE = GameStageHelper.find(v);
        }).define("chance", Reader.number(), () -> Float.valueOf(CHANCE), v -> {
            CHANCE = ((Float)Range.CHANCE.clamp((Number)v)).floatValue();
        }).define("is_scaled_by_crd", Reader.bool(), () -> IS_SCALED_BY_CRD, v -> {
            IS_SCALED_BY_CRD = v;
        });
    }
}

