/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.entity;

import com.majruszlibrary.animations.Animations;
import com.majruszlibrary.animations.AnimationsDef;
import com.majruszlibrary.animations.IAnimableEntity;
import com.majruszlibrary.emitter.ParticleEmitter;
import com.majruszlibrary.emitter.SoundEmitter;
import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.events.OnEntityDamaged;
import com.majruszlibrary.events.OnEntityEffectCheck;
import com.majruszlibrary.events.OnEntityTicked;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.modhelper.Resource;
import com.majruszlibrary.time.TimeHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Cerberus
extends Monster
implements IAnimableEntity {
    private static final Resource<AnimationsDef> ANIMATIONS = MajruszsDifficulty.HELPER.load("cerberus_animation", AnimationsDef.class);
    private final Animations animations = Animations.create();

    public static EntityType<Cerberus> createEntityType() {
        return EntityType.Builder.m_20704_(Cerberus::new, (MobCategory)MobCategory.MONSTER).m_20699_(1.2f, 1.75f).m_20712_("cerberus");
    }

    public static AttributeSupplier createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 240.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_(Attributes.f_22278_, 0.5).m_22265_();
    }

    public Cerberus(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        this.f_19793_ = 1.6f;
    }

    public int m_213860_() {
        return Random.nextInt((int)26, (int)46);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_5496_(SoundEvent sound, float volume, float pitch) {
        if (!this.m_20067_()) {
            SoundEmitter.of((SoundEvent)sound).volume(SoundEmitter.randomized((float)volume)).pitch(SoundEmitter.randomized((float)(pitch * 0.75f))).source(this.m_5720_()).position(this.m_20182_()).emit(this.m_9236_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_21527_()) {
            this.m_20254_(8);
        }
    }

    public AnimationsDef getAnimationsDef() {
        return (AnimationsDef)ANIMATIONS.get();
    }

    public Animations getAnimations() {
        return this.animations;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12619_;
    }

    protected float m_6431_(Pose pose, EntityDimensions dimensions) {
        return 1.6f;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundEvents.f_12561_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12560_;
    }

    protected void m_7355_(BlockPos blockPos, BlockState blockState) {
        this.m_5496_(SoundEvents.f_12562_, 0.15f, 1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new CerberusMeleeAttackGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    private static void applyWither(OnEntityDamaged data) {
        data.target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, TimeHelper.toTicks((double)10.0), 1));
    }

    private static void spawnParticle(OnEntityTicked data) {
        ParticleEmitter.of((ParticleOptions)ParticleTypes.f_123762_).sizeBased((Entity)data.entity).count(1).offset(() -> new Vec3(0.25, 0.5, 0.25)).speed(ParticleEmitter.speed((float)0.001f, (float)0.002f)).emit(data.getLevel());
    }

    static {
        OnEntityDamaged.listen(Cerberus::applyWither).addCondition(OnEntityDamaged::isDirect).addCondition(data -> data.attacker instanceof Cerberus);
        OnEntityEffectCheck.listen(OnEntityEffectCheck::cancelEffect).addCondition(data -> data.effect.equals(MobEffects.f_19615_)).addCondition(data -> data.entity instanceof Cerberus);
        OnEntityTicked.listen(Cerberus::spawnParticle).addCondition(Condition.isLogicalServer()).addCondition(Condition.cooldown((float)0.2f)).addCondition(data -> data.entity instanceof Cerberus);
    }

    private static class CerberusMeleeAttackGoal
    extends MeleeAttackGoal {
        private final Cerberus cerberus;
        private int fireballCooldownLeft = 0;

        public CerberusMeleeAttackGoal(Cerberus cerberus) {
            super((PathfinderMob)cerberus, 1.5, true);
            this.cerberus = cerberus;
        }

        public void m_8037_() {
            super.m_8037_();
            this.cerberus.m_21561_(!this.cerberus.animations.isEmpty());
            this.fireballCooldownLeft = Math.max(this.fireballCooldownLeft - 1, 0);
        }

        protected void m_6739_(LivingEntity target, double distanceSqr) {
            if (!this.cerberus.animations.isEmpty() || !(target.m_9236_() instanceof ServerLevel)) {
                return;
            }
            if (distanceSqr > 100.0 && this.fireballCooldownLeft == 0) {
                this.fireballCooldownLeft = TimeHelper.toTicks((double)10.0);
                this.m_25563_();
                this.useFireBreath(target);
            } else if (distanceSqr < this.m_6639_(target)) {
                this.m_25563_();
                this.bite(target);
            }
        }

        private void useFireBreath(LivingEntity target) {
            this.cerberus.playAnimation("fire_breath").addCallback(3, () -> this.spawnFireballTowards(target)).addCallback(11, () -> this.spawnFireballTowards(target)).addCallback(19, () -> this.spawnFireballTowards(target));
        }

        private void bite(LivingEntity target) {
            this.cerberus.playAnimation("bite").addCallback(2, () -> this.cerberus.m_5496_(SoundEvents.f_12617_, 0.5f, 0.8f)).addCallback(3, () -> this.cerberus.m_5496_(SoundEvents.f_12617_, 0.5f, 0.7f)).addCallback(4, () -> this.cerberus.m_5496_(SoundEvents.f_12617_, 0.5f, 0.9f)).addCallback(7, () -> this.hitAllNearbyEntities((ServerLevel)target.m_9236_()));
        }

        private void hitAllNearbyEntities(ServerLevel level) {
            Vec3 position = AnyPos.from((Vec3)this.cerberus.m_20182_()).add(EntityHelper.getDirection2d((Entity)this.cerberus).mul((Number)1.5)).vec3();
            for (LivingEntity entity : EntityHelper.getEntitiesNearby(LivingEntity.class, (ServerLevel)level, (Vec3)position, (double)2.0)) {
                ServerPlayer player;
                if (entity.equals((Object)this.cerberus) || !this.cerberus.m_21040_(entity, TargetingConditions.f_26872_)) continue;
                this.cerberus.m_7327_((Entity)entity);
                if (!(entity instanceof ServerPlayer) || !(player = (ServerPlayer)entity).m_21254_()) continue;
                player.m_36384_(true);
            }
        }

        private void spawnFireballTowards(LivingEntity target) {
            Vec3 offset = AnyPos.from((Vec3)target.m_20182_()).sub(this.f_25540_.m_20182_()).vec3();
            for (double angle : new double[]{-30.0, 0.0, 30.0}) {
                Vec3 power = AnyPos.from((Vec3)offset).mul(Random.nextVector((double)0.8, (double)1.2, (double)0.8, (double)1.2, (double)0.8, (double)1.2)).vec3();
                double cos = Math.cos(Math.toRadians(angle));
                double sin = Math.sin(Math.toRadians(angle));
                Vec3 normalized = AnyPos.from((Vec3)offset).norm().vec3();
                normalized = new Vec3(cos * normalized.f_82479_ - sin * normalized.f_82481_, normalized.f_82480_, sin * normalized.f_82479_ + cos * normalized.f_82481_);
                Vec3 spawnPosition = AnyPos.from((Vec3)this.f_25540_.m_20182_()).add(normalized).add((Number)0.0, (Number)Random.nextDouble((double)1.2, (double)1.5), (Number)0.0).vec3();
                SmallFireball fireball = new SmallFireball(this.f_25540_.m_9236_(), (LivingEntity)this.f_25540_, power.f_82479_, power.f_82480_, power.f_82481_);
                fireball.m_6034_(spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_);
                fireball.m_20256_(AnyPos.from((Vec3)power).norm().mul((Number)0.25).vec3());
                this.f_25540_.m_9236_().m_7967_((Entity)fireball);
            }
            SoundEmitter.of((SoundEvent)SoundEvents.f_11907_).position(this.f_25540_.m_20182_()).emit(this.f_25540_.m_9236_());
        }
    }
}

