/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.data.Reader;
import com.majruszlibrary.data.Serializables;
import com.majruszlibrary.events.OnEntityEffectCheck;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.item.EquipmentSlots;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.bleeding.BleedingConfig;
import com.majruszsdifficulty.events.OnBleedingTooltip;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class BleedingArmorProtection {
    private static float BASE_BONUS = 0.09f;
    private static float ARMOR_BONUS = 0.03f;
    private static float TOUGHNESS_BONUS = 0.03f;

    private static float calculateCancelChance(OnEntityEffectCheck data) {
        float chance = 1.0f;
        for (EquipmentSlot slot : EquipmentSlots.ARMOR) {
            Item item = data.entity.m_6844_(slot).m_41720_();
            if (!(item instanceof ArmorItem)) continue;
            ArmorItem armorItem = (ArmorItem)item;
            chance *= 1.0f - BleedingArmorProtection.getArmorMultiplier(armorItem);
        }
        return 1.0f - chance;
    }

    private static void addTooltip(OnBleedingTooltip data) {
        data.addArmor(LivingEntity.m_147233_((ItemStack)data.itemStack), BleedingArmorProtection.getArmorMultiplier((ArmorItem)data.itemStack.m_41720_()));
    }

    private static float getArmorMultiplier(ArmorItem item) {
        return 1.0f - ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(0.9f)).clamp((Number)Float.valueOf(BASE_BONUS + ARMOR_BONUS * (float)item.m_40404_() + TOUGHNESS_BONUS * item.m_40405_()))).floatValue();
    }

    static {
        OnEntityEffectCheck.listen(OnEntityEffectCheck::cancelEffect).addCondition(Condition.isLogicalServer()).addCondition(data -> data.effect.equals(MajruszsDifficulty.BLEEDING_EFFECT.get())).addCondition(data -> Random.check((float)BleedingArmorProtection.calculateCancelChance(data)));
        OnBleedingTooltip.listen(BleedingArmorProtection::addTooltip).addCondition(data -> data.itemStack.m_41720_() instanceof ArmorItem);
        Serializables.getStatic(BleedingConfig.class).define("chance_multiplier_base", Reader.number(), () -> Float.valueOf(BASE_BONUS), v -> {
            BASE_BONUS = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        }).define("chance_multiplier_per_armor", Reader.number(), () -> Float.valueOf(ARMOR_BONUS), v -> {
            ARMOR_BONUS = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        }).define("chance_multiplier_per_armor_toughness", Reader.number(), () -> Float.valueOf(TOUGHNESS_BONUS), v -> {
            TOUGHNESS_BONUS = ((Float)Range.of((Number)Float.valueOf(0.0f), (Number)Float.valueOf(1.0f)).clamp((Number)v)).floatValue();
        });
    }
}

