/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsdifficulty.effects.bleeding;

import com.majruszlibrary.events.OnItemEaten;
import com.majruszlibrary.events.OnItemTooltip;
import com.majruszlibrary.events.base.Condition;
import com.majruszlibrary.text.TextHelper;
import com.majruszsdifficulty.MajruszsDifficulty;
import com.majruszsdifficulty.effects.bleeding.BleedingConfig;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;

public class BleedingAppleProtection {
    private static final List<Item> ITEMS = List.of(Items.f_42436_, Items.f_42437_);

    private static void cancelBleeding(OnItemEaten data) {
        data.entity.m_21195_((MobEffect)MajruszsDifficulty.BLEEDING_EFFECT.get());
    }

    private static void addTooltip(OnItemTooltip data) {
        data.components.add(TextHelper.empty());
        data.components.add(TextHelper.translatable((String)"effect.majruszsdifficulty.bleeding.item_consumed", (Object[])new Object[0]).m_130940_(ChatFormatting.DARK_PURPLE));
        data.components.add(TextHelper.translatable((String)"item.majruszsdifficulty.bandage.effect", (Object[])new Object[0]).m_130940_(ChatFormatting.BLUE));
    }

    static {
        OnItemEaten.listen(BleedingAppleProtection::cancelBleeding).addCondition(Condition.isLogicalServer()).addCondition(data -> BleedingConfig.CAN_BE_CURED_WITH_GOLDEN_APPLES).addCondition(data -> ITEMS.contains(data.itemStack.m_41720_()));
        OnItemTooltip.listen(BleedingAppleProtection::addTooltip).addCondition(OnItemTooltip::isAdvanced).addCondition(data -> BleedingConfig.CAN_BE_CURED_WITH_GOLDEN_APPLES).addCondition(data -> ITEMS.contains(data.itemStack.m_41720_()));
    }
}

