/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.platform;

import com.majruszlibrary.platform.ISidePlatform;
import com.majruszlibrary.platform.Services;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Side {
    private static final ISidePlatform PLATFORM = Services.load(ISidePlatform.class);

    public static void run(Supplier<Runnable> logicalClient, Supplier<Runnable> logicalServer) {
        (Side.isLogicalClient() ? logicalClient : logicalServer).get().run();
    }

    public static <Type> Type get(Supplier<Supplier<Type>> logicalClient, Supplier<Supplier<Type>> logicalServer) {
        return (Side.isLogicalClient() ? logicalClient : logicalServer).get().get();
    }

    public static void runOnClient(Supplier<Runnable> supplier) {
        if (Side.isClient()) {
            supplier.get().run();
        }
    }

    public static boolean isLogicalClient() {
        return Side.isClient() && Side.getMinecraft().m_18695_();
    }

    public static boolean isLogicalServer() {
        return !Side.isLogicalClient();
    }

    public static boolean isDevBuild() {
        return PLATFORM.isDevBuild();
    }

    public static boolean isDedicatedServer() {
        return PLATFORM.isDedicatedServer();
    }

    public static boolean isClient() {
        return PLATFORM.isClient();
    }

    public static boolean canLoadClassOnServer(String annotations) {
        return PLATFORM.canLoadClassOnServer(annotations);
    }

    public static MinecraftServer getServer() {
        return PLATFORM.getServer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Minecraft getMinecraft() {
        return Minecraft.m_91087_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ClientLevel getLocalLevel() {
        return Minecraft.m_91087_().f_91073_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static LocalPlayer getLocalPlayer() {
        return Minecraft.m_91087_().f_91074_;
    }
}

