/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.item;

import com.majruszlibrary.entity.EntityHelper;
import com.majruszlibrary.item.IItemPlatform;
import com.majruszlibrary.math.Random;
import com.majruszlibrary.math.Range;
import com.majruszlibrary.platform.Services;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class ItemHelper {
    private static final IItemPlatform PLATFORM = Services.load(IItemPlatform.class);
    private static final float MINECRAFT_WEAPON_ENCHANT_CHANCE = 0.25f;
    private static final float MINECRAFT_ARMOR_PIECE_ENCHANT_CHANCE = 0.5f;

    public static Decorator decorate(ItemStack itemStack) {
        return new Decorator(itemStack);
    }

    public static Optional<SmeltResult> tryToSmelt(Level level, ItemStack itemStack) {
        Optional recipe = level.m_7465_().m_44015_(RecipeType.f_44108_, (Container)new SimpleContainer(new ItemStack[]{itemStack}), level);
        if (recipe.isPresent()) {
            float experience = ((SmeltingRecipe)recipe.get()).m_43750_() * (float)itemStack.m_41613_();
            ItemStack result = ((SmeltingRecipe)recipe.get()).m_8043_().m_41777_();
            result.m_41764_(result.m_41613_() * itemStack.m_41613_());
            return Optional.of(new SmeltResult(result, experience));
        }
        return Optional.empty();
    }

    public static void giveToPlayer(ItemStack itemStack, Player player) {
        if (!player.m_150109_().m_36054_(itemStack)) {
            player.m_9236_().m_7967_((Entity)new ItemEntity(player.m_9236_(), player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), itemStack));
        }
    }

    public static void damage(LivingEntity entity, EquipmentSlot slot, int damage) {
        entity.m_6844_(slot).m_41622_(damage, entity, subentity -> subentity.m_21166_(slot));
    }

    public static void damage(LivingEntity entity, InteractionHand hand, int damage) {
        entity.m_21120_(hand).m_41622_(damage, entity, subentity -> subentity.m_21190_(hand));
    }

    @Nullable
    public static EquipmentSlot equip(Mob mob, ItemStack itemStack) {
        if (!mob.m_7252_(itemStack)) {
            return null;
        }
        EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
        equipmentSlot = equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR ? equipmentSlot : EquipmentSlot.MAINHAND;
        mob.m_8061_(equipmentSlot, itemStack);
        return equipmentSlot;
    }

    public static void consumeItemOnUse(ItemStack itemStack, Player player) {
        player.m_36246_(Stats.f_12982_.m_12902_((Object)itemStack.m_41720_()));
        if (!EntityHelper.isOnCreativeMode(player)) {
            itemStack.m_41774_(1);
        }
    }

    public static void addCooldown(Player player, int duration, Item ... items) {
        for (Item item : items) {
            player.m_36335_().m_41524_(item, duration);
        }
    }

    public static <Type extends EntityType<? extends Mob>> Supplier<SpawnEggItem> createEgg(Supplier<Type> type, int backgroundColor, int highlightColor) {
        return PLATFORM.createEgg(type, backgroundColor, highlightColor);
    }

    public static ItemStack getHandItem(LivingEntity entity, Predicate<ItemStack> predicate) {
        return predicate.test(entity.m_21205_()) ? entity.m_21205_() : entity.m_21206_();
    }

    public static ItemStack getCurrentlyUsedItem(LivingEntity entity) {
        return entity.m_6117_() ? entity.m_21120_(entity.m_7655_()) : ItemStack.f_41583_;
    }

    public static boolean isOnCooldown(Player player, Item ... items) {
        for (Item item : items) {
            if (!player.m_36335_().m_41519_(item)) continue;
            return true;
        }
        return false;
    }

    public static boolean isShield(Item item) {
        return item instanceof ShieldItem;
    }

    public static boolean isRangedWeapon(Item item) {
        return item instanceof BowItem || item instanceof CrossbowItem;
    }

    public static boolean isMeleeWeapon(Item item) {
        return item instanceof SwordItem || item instanceof TridentItem || item instanceof AxeItem;
    }

    public static boolean isGoldenToolOrArmor(Item item) {
        ArmorItem armorItem;
        DiggerItem diggerItem;
        SwordItem swordItem;
        return item instanceof SwordItem && (swordItem = (SwordItem)item).m_43314_() == Tiers.GOLD || item instanceof DiggerItem && (diggerItem = (DiggerItem)item).m_43314_() == Tiers.GOLD || item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40401_() == ArmorMaterials.GOLD;
    }

    public static boolean isAnyTool(Item item) {
        return item instanceof SwordItem || item instanceof TridentItem || item instanceof DiggerItem || item instanceof BowItem || item instanceof CrossbowItem;
    }

    public static boolean isFishingRod(Item item) {
        return item instanceof FishingRodItem;
    }

    public static class Decorator {
        private final ItemStack itemStack;
        private final List<Runnable> modifications = new ArrayList<Runnable>();
        private boolean isTreasureAllowed = false;
        private float enchantChance = 1.0f;

        public Decorator damage(float ratio) {
            this.modifications.add(() -> {
                if (!this.itemStack.m_41763_()) {
                    return;
                }
                this.itemStack.m_41721_((int)(ratio * (float)this.itemStack.m_41776_()));
            });
            return this;
        }

        public Decorator damage(Range<Float> ratio) {
            this.damage(Random.nextFloat(ratio));
            return this;
        }

        public Decorator allowTreasureEnchantments() {
            this.isTreasureAllowed = true;
            return this;
        }

        public Decorator withVanillaEnchantmentChance() {
            this.enchantChance = this.itemStack.m_41720_() instanceof ArmorItem ? 0.5f : 0.25f;
            return this;
        }

        public Decorator enchant(double clampedRegionalDifficulty) {
            this.modifications.add(() -> {
                if (!this.itemStack.m_41792_() || !Random.check(this.enchantChance)) {
                    return;
                }
                int level = (int)(5.0 + clampedRegionalDifficulty * (double)Random.nextInt(18));
                EnchantmentHelper.m_220292_((RandomSource)Random.getThreadSafe(), (ItemStack)this.itemStack, (int)level, (boolean)this.isTreasureAllowed);
            });
            return this;
        }

        public ItemStack apply() {
            this.modifications.forEach(Runnable::run);
            return this.itemStack;
        }

        private Decorator(ItemStack itemStack) {
            this.itemStack = itemStack;
        }
    }

    public record SmeltResult(ItemStack itemStack, float experience) {
    }
}

