/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.item;

import com.majruszlibrary.mixin.IMixinEnchantment;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;

public class CustomEnchantment
extends Enchantment {
    private boolean isCurse = false;
    private boolean isEnabled = true;
    private int maxLevel = 1;
    private CostFormula minLevelCost = level -> 10;
    private CostFormula maxLevelCost = level -> 50;
    private Predicate<Enchantment> compatibility = enchantment -> true;
    private Predicate<ItemStack> enchantability = itemStack -> false;

    public CustomEnchantment() {
        super(null, EnchantmentCategory.BREAKABLE, null);
    }

    public int m_6586_() {
        return this.maxLevel;
    }

    public int m_6183_(int enchantmentLevel) {
        return this.minLevelCost.getLevelCost(enchantmentLevel);
    }

    public int m_6175_(int enchantmentLevel) {
        return this.maxLevelCost.getLevelCost(enchantmentLevel);
    }

    public boolean m_6081_(ItemStack itemStack) {
        return this.isEnabled() && this.enchantability.test(itemStack);
    }

    public boolean m_6594_() {
        return this.isEnabled() && super.m_6594_();
    }

    public boolean m_6592_() {
        return this.isEnabled() && super.m_6592_();
    }

    public boolean m_6591_() {
        return this.isCurse;
    }

    public boolean m_6589_() {
        return this.isCurse;
    }

    public boolean m_5975_(Enchantment enchantment) {
        return this.compatibility.test(enchantment) && super.m_5975_(enchantment);
    }

    public CustomEnchantment slots(List<EquipmentSlot> slots) {
        ((IMixinEnchantment)((Object)this)).setSlots((EquipmentSlot[])slots.toArray(EquipmentSlot[]::new));
        return this;
    }

    public CustomEnchantment rarity(Enchantment.Rarity rarity) {
        ((IMixinEnchantment)((Object)this)).setRarity(rarity);
        return this;
    }

    public CustomEnchantment category(EnchantmentCategory category) {
        ((IMixinEnchantment)((Object)this)).setCategory(category);
        return this.category((ItemStack itemStack) -> category.m_7454_(itemStack.m_41720_()));
    }

    public CustomEnchantment category(Predicate<ItemStack> predicate) {
        this.enchantability = predicate;
        return this;
    }

    public CustomEnchantment curse() {
        this.isCurse = true;
        return this;
    }

    public CustomEnchantment maxLevel(int level) {
        this.maxLevel = level;
        return this;
    }

    public CustomEnchantment minLevelCost(CostFormula formula) {
        this.minLevelCost = formula;
        return this;
    }

    public CustomEnchantment maxLevelCost(CostFormula formula) {
        this.maxLevelCost = formula;
        return this;
    }

    public CustomEnchantment compatibility(Predicate<Enchantment> predicate) {
        this.compatibility = predicate;
        return this;
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean canEnchantUsingEnchantingTable(ItemStack itemStack) {
        return this.m_6081_(itemStack);
    }

    @FunctionalInterface
    public static interface CostFormula {
        public int getLevelCost(int var1);
    }
}

