/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.emitter;

import com.majruszlibrary.math.AnyPos;
import com.majruszlibrary.math.Random;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class ParticleEmitter {
    static final Properties DEFAULT_PROPERTIES = new Properties(ParticleEmitter.offset(0.25f), ParticleEmitter.speed(0.025f, 0.1f));
    static final Map<Object, Properties> PROPERTIES = new HashMap<Object, Properties>();
    private final Supplier<? extends ParticleOptions> type;
    private Supplier<Vec3> position = () -> Vec3.f_82478_;
    private Supplier<Vec3> offset;
    private Supplier<Float> speed;
    private int count = 1;
    private float countMultiplier = 1.0f;

    public static void setDefault(ParticleType<?> type, Properties properties) {
        PROPERTIES.put(type, properties);
    }

    public static ParticleEmitter of(Supplier<? extends ParticleOptions> type) {
        return new ParticleEmitter(type, PROPERTIES.getOrDefault(type.get().m_6012_(), DEFAULT_PROPERTIES));
    }

    public static ParticleEmitter of(ParticleOptions type) {
        return ParticleEmitter.of(() -> type);
    }

    public static Supplier<Vec3> offset(float value) {
        return () -> new Vec3((double)value, (double)value, (double)value);
    }

    public static Supplier<Float> speed(float min, float max) {
        return () -> Float.valueOf(Random.nextFloat(min, max));
    }

    public void emit(Level level) {
        this.emit(level, this.position.get(), this.offset.get(), Math.round((float)this.count * this.countMultiplier));
    }

    public void emitLine(Level level, Vec3 end) {
        Vec3 start = this.position.get();
        int count = Math.round((float)this.count * this.countMultiplier);
        AnyPos direction = AnyPos.from(end).sub(start);
        if (count == 1) {
            this.emit(level, AnyPos.from(start).add(direction.div(2)).vec3(), this.offset.get(), 1);
            return;
        }
        for (int idx = 0; idx < count; ++idx) {
            this.emit(level, AnyPos.from(start).add(direction.mul(Float.valueOf((float)idx / ((float)count - 1.0f)))).vec3(), this.offset.get(), 1);
        }
    }

    public ParticleEmitter position(Supplier<Vec3> position) {
        this.position = position;
        return this;
    }

    public ParticleEmitter position(Vec3 position) {
        return this.position(() -> position);
    }

    public ParticleEmitter offset(Supplier<Vec3> offset) {
        this.offset = offset;
        return this;
    }

    public ParticleEmitter offset(Vec3 offset) {
        return this.offset(() -> offset);
    }

    public ParticleEmitter speed(Supplier<Float> speed) {
        this.speed = speed;
        return this;
    }

    public ParticleEmitter speed(float speed) {
        return this.speed(() -> Float.valueOf(speed));
    }

    public ParticleEmitter count(int count) {
        this.count = count;
        return this;
    }

    public ParticleEmitter sizeBased(Entity entity) {
        float width = entity.m_20205_();
        float height = entity.m_20206_();
        this.position = () -> AnyPos.from(entity.m_20182_()).add(0.0, 0.5 * (double)height, 0.0).vec3();
        this.offset = () -> AnyPos.from(Float.valueOf(width), Float.valueOf(height), Float.valueOf(width)).mul(0.5, 0.25, 0.5).vec3();
        this.countMultiplier = Math.round(1.0f + width + height);
        return this;
    }

    private ParticleEmitter(Supplier<? extends ParticleOptions> type, Properties properties) {
        this.type = type;
        this.offset = properties.offset;
        this.speed = properties.speed;
    }

    private void emit(Level level, Vec3 position, Vec3 offset, int count) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_(this.type.get(), position.f_82479_, position.f_82480_, position.f_82481_, count, offset.f_82479_, offset.f_82480_, offset.f_82481_, (double)this.speed.get().floatValue());
        } else {
            ParticleOptions type = this.type.get();
            float speed = this.speed.get().floatValue();
            for (int idx = 0; idx < count; ++idx) {
                level.m_7106_(type, position.f_82479_, position.f_82480_, position.f_82481_, offset.f_82479_ * (double)speed, offset.f_82480_ * (double)speed, offset.f_82481_ * (double)speed);
            }
        }
    }

    static {
        ParticleEmitter.setDefault(ParticleTypes.f_123760_, new Properties(ParticleEmitter.offset(0.5f), ParticleEmitter.speed(-1.0f, 0.0f)));
        ParticleEmitter.setDefault(ParticleTypes.f_123744_, new Properties(ParticleEmitter.offset(0.15f), ParticleEmitter.speed(0.0025f, 0.01f)));
        ParticleEmitter.setDefault(ParticleTypes.f_123762_, new Properties(ParticleEmitter.offset(0.25f), ParticleEmitter.speed(0.0025f, 0.01f)));
        ParticleEmitter.setDefault(ParticleTypes.f_235902_, new Properties(() -> Vec3.f_82478_, () -> Float.valueOf(0.0f)));
        ParticleEmitter.setDefault(ParticleTypes.f_123746_, new Properties(ParticleEmitter.offset(0.5f), ParticleEmitter.speed(0.005f, 0.02f)));
        ParticleEmitter.setDefault(ParticleTypes.f_123771_, new Properties(ParticleEmitter.offset(0.5f), ParticleEmitter.speed(0.0025f, 0.01f)));
    }

    public record Properties(Supplier<Vec3> offset, Supplier<Float> speed) {
    }
}

