/*
 * Decompiled with CFR 0.152.
 */
package com.majruszlibrary.animations;

import com.majruszlibrary.animations.ModelDef;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelParts {
    private final ModelPart root;
    private final ModelDef model;
    private final Map<String, ModelPart> parts = new HashMap<String, ModelPart>();

    public ModelParts(ModelPart root, ModelDef model) {
        this.root = root;
        this.model = model;
        for (ModelDef.BoneDef bone : model.geometries.get((int)0).bones) {
            this.parts.put(bone.name, (bone.parent != null ? this.parts.get(bone.parent) : this.root).m_171324_(bone.name));
        }
    }

    public void reset() {
        this.model.geometries.get((int)0).bones.forEach(bone -> {
            ModelPart modelPart = this.get(bone.name);
            modelPart.m_104227_(bone.pivot.m_122239_(), bone.pivot.m_122260_(), bone.pivot.m_122269_());
            if (bone.rotation != null) {
                float toRadiansScale = (float)Math.PI / 180;
                modelPart.m_171327_(bone.rotation.m_122239_() * toRadiansScale, bone.rotation.m_122260_() * toRadiansScale, bone.rotation.m_122269_() * toRadiansScale);
            } else {
                modelPart.m_171327_(0.0f, 0.0f, 0.0f);
            }
            modelPart.f_233555_ = 1.0f;
            modelPart.f_233554_ = 1.0f;
            modelPart.f_233553_ = 1.0f;
        });
    }

    public ModelPart get(String name) {
        return this.parts.get(name);
    }

    public ModelPart getRoot() {
        return this.root;
    }
}

