/*
 * Decompiled with CFR 0.152.
 */
package com.cerbon.bosses_of_mass_destruction.projectile;

import com.cerbon.bosses_of_mass_destruction.entity.BMDEntities;
import com.cerbon.bosses_of_mass_destruction.projectile.BaseThrownItemProjectile;
import com.cerbon.bosses_of_mass_destruction.projectile.util.ExemptEntities;
import com.cerbon.bosses_of_mass_destruction.sound.BMDSounds;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class MagicMissileProjectile
extends BaseThrownItemProjectile {
    private Consumer<LivingEntity> entityHit;

    public MagicMissileProjectile(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public MagicMissileProjectile(LivingEntity livingEntity, Level level, Consumer<LivingEntity> entityHit, List<EntityType<?>> exemptEntities) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BMDEntities.MAGIC_MISSILE.get()), livingEntity, level, new ExemptEntities(exemptEntities));
        this.entityHit = entityHit;
    }

    @Override
    public void entityHit(EntityHitResult entityHitResult) {
        Entity entity = entityHitResult.m_82443_();
        Entity owner = this.m_37282_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            entity.m_6469_(DamageSource.m_19361_((Entity)this, (Entity)owner), (float)livingEntity.m_21133_(Attributes.f_22281_));
            if (entity instanceof LivingEntity && this.entityHit != null) {
                this.entityHit.accept((LivingEntity)entity);
            }
        }
        this.m_146870_();
    }

    protected void m_8060_(@NotNull BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        this.m_5496_((SoundEvent)BMDSounds.BLUE_FIREBALL_LAND.get(), 1.0f, 1.0f);
        this.m_146870_();
    }
}

